/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import java.util.Objects;
import java.util.UUID;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboMealCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final UUID UUID = java.util.UUID.fromString("41DD0153-E92A-B00B-9800-EFFEC53C00B0");
    public float speed = 1.0f;
    public int duration = 0;
    private final LazyOptional<ComboMealCapability> optional = LazyOptional.of(() -> this);
    public static final ResourceLocation ID = MoreSnifferFlowers.loc("combo_meal");

    public void onEffectEnd(Player player) {
        this.speed = 1.0f;
        this.duration = 0;
        player.m_21051_(Attributes.f_22283_).m_22120_(UUID);
    }

    public void onAttack(Player player, boolean isCharged) {
        int amplifier = Objects.requireNonNull(player.m_21124_((MobEffect)ModEffects.COMBO_MEAL.get())).m_19564_();
        if (isCharged) {
            this.speed *= 1.0f + ((float)amplifier / 4.0f + 1.0f) / 10.0f;
            this.duration = (int)(150.0f / (this.speed * 2.0f));
            player.m_21051_(Attributes.f_22283_).m_22120_(UUID);
            AttributeModifier mod = new AttributeModifier(UUID, "combo_meal", (double)(this.speed - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL);
            player.m_21051_(Attributes.f_22283_).m_22118_(mod);
        } else {
            this.duration /= 2;
        }
    }

    public void tick(Player player) {
        if (this.duration <= 0) {
            this.speed = 1.0f;
            player.m_21051_(Attributes.f_22283_).m_22120_(UUID);
        }
        if (this.duration > 0) {
            --this.duration;
        }
    }

    public void debugPrint() {
        System.out.println("lastSpeed: " + this.speed + " duration: " + this.duration);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityList.COMBO_MEAL.orEmpty(cap, this.optional.cast());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("speed", this.speed);
        tag.m_128405_("duration", this.duration);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.speed = tag.m_128457_("speed");
        this.duration = tag.m_128451_("duration");
    }
}

