/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.SyncNutritionPacket;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NutritionCapability
implements INBTSerializable<CompoundTag>,
ICapabilityProvider {
    static ResourceLocation ID = MoreSnifferFlowers.loc("unlocked_nutrition");
    private Set<Item> items = new HashSet<Item>();
    public Set<Integer> unlockedEffects = new HashSet<Integer>();
    private final LazyOptional<NutritionCapability> optional = LazyOptional.of(() -> this);
    public static final Map<Integer, ResourceLocation> ICON_FROM_ID = Map.of(0, MoreSnifferFlowers.loc("textures/mob_effect/slippery.png"), 1, MoreSnifferFlowers.loc("textures/mob_effect/untouchable.png"), 2, MoreSnifferFlowers.loc("textures/mob_effect/salty.png"), 3, MoreSnifferFlowers.loc("textures/mob_effect/combo_meal.png"), 4, MoreSnifferFlowers.loc("textures/mob_effect/pants_on_fire.png"), 5, MoreSnifferFlowers.loc("textures/mob_effect/hardened_mouth.png"), 6, MoreSnifferFlowers.loc("textures/mob_effect/sticky.png"), 7, MoreSnifferFlowers.loc("textures/mob_effect/gluing_touch.png"), 8, MoreSnifferFlowers.loc("textures/mob_effect/bland.png"), 9, MoreSnifferFlowers.loc("textures/mob_effect/well_balanced.png"));

    public Set<Item> getItems() {
        return this.items;
    }

    public void setItems(Set<Item> items) {
        this.items = items;
    }

    public void addItem(Item item) {
        Set<Item> set = this.getItems();
        set.add(item);
        this.setItems(set);
    }

    public void sync(Player player) {
        if (!player.m_9236_().f_46443_) {
            ModPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SyncNutritionPacket(this.items, this.unlockedEffects));
        }
    }

    public static MobEffect effectFromId(int id) {
        if (id % 2 == 0) {
            return NutritionType.getEffect(NutritionType.byId(id / 2), false);
        }
        return NutritionType.getEffect(NutritionType.byId(Mth.m_14143_((float)((float)id / 2.0f))), true);
    }

    public static int idFromNutrition(NutritionType type, boolean isPositive) {
        int id = type.ordinal() * 2;
        if (isPositive) {
            ++id;
        }
        return id;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int i;
        this.items = new HashSet<Item>();
        for (i = 0; i < nbt.m_128451_("size"); ++i) {
            ResourceLocation location = ResourceLocation.m_135822_((String)nbt.m_128461_("unlocked" + i), (char)':');
            this.items.add((Item)ForgeRegistries.ITEMS.getValue(location));
        }
        this.unlockedEffects = new HashSet<Integer>();
        for (i = 0; i < nbt.m_128451_("effect_size"); ++i) {
            this.unlockedEffects.add(nbt.m_128451_("effect" + i));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("size", this.items.size());
        int i = 0;
        for (Item item : this.items) {
            tag.m_128359_("unlocked" + i, ForgeRegistries.ITEMS.getKey((Object)item).toString());
            ++i;
        }
        tag.m_128405_("effect_size", this.unlockedEffects.size());
        int i1 = 0;
        for (int id : this.unlockedEffects) {
            tag.m_128405_("effect" + i1, id);
            ++i1;
        }
        return tag;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityList.UNLOCKED_NUTRITIONS.orEmpty(cap, this.optional.cast());
    }
}

