/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client;

import java.awt.Color;
import net.abraxator.moresnifferflowers.blocks.ColorableVivicusBlock;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="moresnifferflowers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModColorHandler {
    @SubscribeEvent
    public static void onRegisterBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> {
            Colorable colorable = (Colorable)state.m_60734_();
            Dye dye = colorable.getDyeFromBlock(state);
            int color = Dye.colorForDye(colorable, dye.color());
            if (!dye.isEmpty()) {
                if (tintIndex == 0) {
                    float[] colorHSB = ModColorHandler.getColorHSB(color);
                    return Color.HSBtoRGB(colorHSB[0], Math.max(colorHSB[1] / 1.7f, 0.0f), Math.max(colorHSB[2], 0.0f));
                }
                if (tintIndex == 1) {
                    return color;
                }
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.CAULORFLOWER.get()});
        event.register((state, level, pos, tintIndex) -> {
            int color = ((BlockPattern)((Object)((Object)state.m_61143_(ModStateProperties.BLOCK_PATTERN)))).getColor();
            if (((Boolean)state.m_61143_((Property)ModStateProperties.EMPTY)).booleanValue()) {
                color = 0xFFFFFF;
            }
            if (tintIndex == 0) {
                float[] colorHSB = ModColorHandler.getColorHSB(color);
                return Color.HSBtoRGB(colorHSB[0], Math.max(colorHSB[1] / 1.7f, 0.0f), Math.max(colorHSB[2], 0.0f));
            }
            if (tintIndex == 1) {
                float[] colorHSB = ModColorHandler.getColorHSB(color);
                return Color.HSBtoRGB(colorHSB[0], Math.min(colorHSB[1] * 1.1f, 1.0f), Math.min(colorHSB[2] * 1.2f, 1.0f));
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.PATTERNFLOWER.get()});
        event.register((state, level, pos, tintIndex) -> {
            ColorableVivicusBlock colorable = (ColorableVivicusBlock)state.m_60734_();
            if (tintIndex == 0) {
                int dyedValue = Dye.colorForDye(colorable, (DyeColor)state.m_61143_(colorable.getColorProperty()));
                DyeColor color = colorable.getDyeFromBlock(state).color();
                if (state.m_60713_((Block)ModBlocks.VIVICUS_LEAVES.get()) || state.m_60713_((Block)ModBlocks.VIVICUS_LEAVES_SPROUT.get())) {
                    float[] colorHSB = ModColorHandler.getColorHSB(dyedValue);
                    if (pos == null) {
                        pos = new BlockPos(0, 0, 0);
                    }
                    float hue = colorHSB[0] + (1.0f + Mth.m_14031_((float)((float)pos.m_123341_() + (float)pos.m_123342_() + (float)pos.m_123343_()))) / 15.0f;
                    if ((double)colorHSB[1] < 0.3 && (double)colorHSB[2] < 0.8) {
                        colorHSB[2] = colorHSB[2] - (1.0f + Mth.m_14031_((float)((float)pos.m_123341_() + (float)pos.m_123342_() + (float)pos.m_123343_()))) / 15.0f;
                    }
                    if ((double)colorHSB[1] < 0.3) {
                        colorHSB[1] = colorHSB[1] + (1.0f + Mth.m_14031_((float)((float)pos.m_123341_() + (float)pos.m_123342_() + (float)pos.m_123343_()))) / 12.0f;
                    }
                    return Color.HSBtoRGB(hue, colorHSB[1], colorHSB[2]);
                }
                return dyedValue;
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.VIVICUS_LOG.get(), (Block)ModBlocks.VIVICUS_WOOD.get(), (Block)ModBlocks.STRIPPED_VIVICUS_LOG.get(), (Block)ModBlocks.STRIPPED_VIVICUS_WOOD.get(), (Block)ModBlocks.VIVICUS_PLANKS.get(), (Block)ModBlocks.VIVICUS_STAIRS.get(), (Block)ModBlocks.VIVICUS_SLAB.get(), (Block)ModBlocks.VIVICUS_FENCE.get(), (Block)ModBlocks.VIVICUS_FENCE_GATE.get(), (Block)ModBlocks.VIVICUS_DOOR.get(), (Block)ModBlocks.VIVICUS_TRAPDOOR.get(), (Block)ModBlocks.VIVICUS_PRESSURE_PLATE.get(), (Block)ModBlocks.VIVICUS_BUTTON.get(), (Block)ModBlocks.VIVICUS_LEAVES.get(), (Block)ModBlocks.VIVICUS_SAPLING.get(), (Block)ModBlocks.VIVICUS_LEAVES_SPROUT.get(), (Block)ModBlocks.VIVICUS_SIGN.get(), (Block)ModBlocks.VIVICUS_HANGING_SIGN.get(), (Block)ModBlocks.VIVICUS_SAPLING.get()});
    }

    @SubscribeEvent
    public static void onRegisterItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            Dye dye = Dye.getDyeFromDyespria(stack);
            if (tintIndex != 0 || dye.isEmpty()) {
                return -1;
            }
            return Dye.colorForDye((DyespriaItem)stack.m_41720_(), dye.color());
        }, new ItemLike[]{(ItemLike)ModItems.DYESPRIA.get()});
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : PotionUtils.m_43575_((ItemStack)stack), new ItemLike[]{(ItemLike)ModItems.EXTRACTED_BOTTLE.get(), (ItemLike)ModItems.REBREWED_POTION.get(), (ItemLike)ModItems.REBREWED_SPLASH_POTION.get(), (ItemLike)ModItems.REBREWED_LINGERING_POTION.get()});
        event.register((stack, tintIndex) -> {
            BlockPattern pattern = BlockPattern.fromPatternspria(stack);
            if (tintIndex != 0 || pattern == BlockPattern.EMPTY) {
                return -1;
            }
            if (stack.m_41784_().m_128441_("color")) {
                return stack.m_41784_().m_128451_("color");
            }
            return pattern.getColor();
        }, new ItemLike[]{(ItemLike)ModItems.PATTERNSPRIA.get()});
        event.register((stack, tintIndex) -> {
            if (stack.m_41784_().m_128441_("color") && tintIndex != 0) {
                return stack.m_41784_().m_128451_("color");
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)ModItems.ROOTED_SOUP.get()});
        event.register((stack, tintIndex) -> {
            if (stack.m_41784_().m_128441_("MSF_Hex")) {
                return stack.m_41784_().m_128451_("MSF_Hex");
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)ModBlocks.VIVICUS_LOG.get(), (ItemLike)ModBlocks.VIVICUS_WOOD.get(), (ItemLike)ModBlocks.STRIPPED_VIVICUS_LOG.get(), (ItemLike)ModBlocks.STRIPPED_VIVICUS_WOOD.get(), (ItemLike)ModBlocks.VIVICUS_PLANKS.get(), (ItemLike)ModBlocks.VIVICUS_STAIRS.get(), (ItemLike)ModBlocks.VIVICUS_SLAB.get(), (ItemLike)ModBlocks.VIVICUS_FENCE.get(), (ItemLike)ModBlocks.VIVICUS_FENCE_GATE.get(), (ItemLike)ModBlocks.VIVICUS_DOOR.get(), (ItemLike)ModBlocks.VIVICUS_TRAPDOOR.get(), (ItemLike)ModBlocks.VIVICUS_PRESSURE_PLATE.get(), (ItemLike)ModBlocks.VIVICUS_BUTTON.get(), (ItemLike)ModBlocks.VIVICUS_LEAVES.get(), (ItemLike)ModBlocks.VIVICUS_SAPLING.get(), (ItemLike)ModBlocks.VIVICUS_LEAVES_SPROUT.get(), (ItemLike)ModItems.VIVICUS_SIGN.get(), (ItemLike)ModItems.VIVICUS_HANGING_SIGN.get(), (ItemLike)ModItems.VIVICUS_BOAT.get(), (ItemLike)ModItems.VIVICUS_CHEST_BOAT.get()});
    }

    public static float @NotNull [] getColorHSB(int originalColor) {
        int startRed = originalColor >> 16 & 0xFF;
        int startGreen = originalColor >> 8 & 0xFF;
        int startBlue = originalColor & 0xFF;
        return Color.RGBtoHSB(startRed, startGreen, startBlue, null);
    }

    public static float[] hexToRGBLarge(int hex) {
        return new float[]{hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF};
    }

    public static float[] hexToRGB(int hex) {
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int RGBtoInt(Vec3 color) {
        int r = (int)color.f_82479_;
        int g = (int)color.f_82480_;
        int b = (int)color.f_82481_;
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static int barColorHelper(int input, int maxInput) {
        int lowColor = 0x8C1111;
        int highColor = 1545513;
        int lowRed = lowColor >> 16 & 0xFF;
        int lowGreen = lowColor >> 8 & 0xFF;
        int lowBlue = lowColor & 0xFF;
        int highRed = highColor >> 16 & 0xFF;
        int highGreen = highColor >> 8 & 0xFF;
        int highBlue = highColor & 0xFF;
        float[] lowHSB = Color.RGBtoHSB(lowRed, lowGreen, lowBlue, null);
        float[] highHSB = Color.RGBtoHSB(highRed, highGreen, highBlue, null);
        float finalHue = (lowHSB[0] * (float)Math.abs(input - maxInput) + highHSB[0] * (float)input) / (float)maxInput;
        return Mth.m_14169_((float)finalHue, (float)1.0f, (float)1.0f);
    }
}

