/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.BerootCauldronBlockEntity;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.nikdo53.tinymultiblocklib.client.IMultiblockRenderHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class BerootCauldronRenderer<T extends BerootCauldronBlockEntity>
implements BlockEntityRenderer<T>,
IMultiblockRenderHelper {
    private final ModelPart cauldron;
    private final ModelPart spoon;

    public BerootCauldronRenderer(BlockEntityRendererProvider.Context context) {
        this.cauldron = context.m_173582_(ModModelLayerLocations.BEROOT_CAULDRON);
        this.spoon = context.m_173582_(ModModelLayerLocations.BEROOT_SPOON);
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Material CAULDRON_TEXTURE = new Material(TextureAtlas.f_118259_, MoreSnifferFlowers.loc("block/beroot_cauldron"));
        Material SPOON_TEXTURE = new Material(TextureAtlas.f_118259_, MoreSnifferFlowers.loc("block/beroot_spoon"));
        PreviewMode previewMode = ((BerootCauldronBlockEntity)blockEntity).previewMode;
        Function renderType = this.getRenderTypeFunction(previewMode);
        VertexConsumer cauldron_consumer = CAULDRON_TEXTURE.m_119194_(buffer, renderType);
        VertexConsumer spoon_consumer = SPOON_TEXTURE.m_119194_(buffer, renderType);
        RandomSource randomSource = this.level().m_213780_();
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (blockEntity.isCenter()) {
            poseStack.m_85836_();
            poseStack.m_85837_(1.0, 1.5, 0.0);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(-180.0f));
            this.rotate(poseStack, direction, false);
            this.render(this.cauldron, poseStack, cauldron_consumer, packedLight, packedOverlay, previewMode);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(1.0, 0.5, 0.0);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(-180.0f));
            this.rotate(poseStack, direction, false);
            PoseStack.Pose pose = poseStack.m_85850_();
            Matrix4f matrix4f = pose.m_252922_();
            Matrix3f matrix3f = pose.m_252943_();
            int soupCount = ((BerootCauldronBlockEntity)blockEntity).soupCount;
            float size = 1.5f;
            float halfSize = size / 2.0f;
            float minX = -halfSize;
            float maxX = halfSize;
            float minZ = -halfSize;
            float maxZ = halfSize;
            float r = (float)(((BerootCauldronBlockEntity)blockEntity).color().f_82479_ / 255.0);
            float g = (float)(((BerootCauldronBlockEntity)blockEntity).color().f_82480_ / 255.0);
            float b = (float)(((BerootCauldronBlockEntity)blockEntity).color().f_82481_ / 255.0);
            float y = -(0.16666667f * (float)soupCount);
            float soupScale = 0.332f;
            if (soupCount > 0) {
                poseStack.m_85841_(1.0f + soupScale, 1.0f, 1.0f + soupScale);
                poseStack.m_85837_((double)(-soupScale) * 0.565, 0.0, (double)soupScale * 0.565);
                this.renderFace(matrix4f, matrix3f, buffer.m_6299_(RenderType.m_110457_()), r, g, b, 1.0f, minX, maxX, y, minZ, maxZ, packedLight, ((BerootCauldronBlockEntity)blockEntity).isCrafted);
            }
            poseStack.m_85849_();
            float rot = -((BerootCauldronBlockEntity)blockEntity).getSpoonRotation(partialTick);
            poseStack.m_85836_();
            poseStack.m_85837_(1.0, 1.5, 0.0);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(-180.0f));
            this.rotate(poseStack, direction, false);
            poseStack.m_252781_(new Quaternionf().rotationY((float)((double)rot * (Math.PI / 180))));
            this.render(this.spoon, poseStack, spoon_consumer, packedLight, packedOverlay, previewMode);
            poseStack.m_85849_();
            for (int i = 0; i < ((BerootCauldronBlockEntity)blockEntity).ingredients.getValidSize(); ++i) {
                poseStack.m_85836_();
                this.rotate(poseStack, direction, true);
                ItemStack itemStack = (ItemStack)((BerootCauldronBlockEntity)blockEntity).ingredients.get(i);
                float speed = (float)randomSource.m_216332_(50, 100) / 100.0f;
                float rot2 = (float)((double)((BerootCauldronBlockEntity)blockEntity).getItemsRotation(partialTick) * ((double)(i + 1) * 0.1));
                float a = (float)((double)i * 0.05);
                poseStack.m_85837_(0.8 + (double)a, (double)(-y + 0.51f), 0.0 - (double)a);
                poseStack.m_252781_(new Quaternionf().rotationY((float)((double)rot2 * (Math.PI / 180))));
                poseStack.m_85837_(0.25, 0.0, 0.25);
                poseStack.m_252781_(new Quaternionf().rotationY((float)((double)rot2 * 0.2 * (Math.PI / 180))));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.m_58904_(), (int)(blockEntity.m_58899_().m_121878_() + (long)i));
                poseStack.m_85849_();
            }
        }
    }

    private void rotate(PoseStack poseStack, Direction direction, Boolean isItems) {
        if (!isItems.booleanValue()) {
            switch (direction) {
                case EAST: {
                    poseStack.m_252880_(0.0f, 0.0f, -1.0f);
                    break;
                }
                case WEST: {
                    poseStack.m_252880_(-1.0f, 0.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.m_252880_(-1.0f, 0.0f, -1.0f);
                }
            }
        } else {
            switch (direction) {
                case EAST: {
                    poseStack.m_252880_(0.0f, 0.0f, 1.0f);
                    break;
                }
                case WEST: {
                    poseStack.m_252880_(-1.0f, 0.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.m_252880_(-1.0f, 0.0f, 1.0f);
                }
            }
            poseStack.m_85837_(0.0, 0.0, 0.1);
        }
        if (!isItems.booleanValue()) {
            poseStack.m_252781_(direction.m_253075_());
        }
        if (!isItems.booleanValue()) {
            poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
        }
    }

    private void renderFace(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, float red, float green, float blue, float alpha, float x0, float x1, float y, float z0, float z1, int light, boolean isCrafted) {
        String name = isCrafted ? "beroot_soup1" : "beroot_soup";
        ResourceLocation resourceLocation = MoreSnifferFlowers.loc("block/" + name);
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(resourceLocation);
        consumer.m_252986_(pose, x1, y, z0).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x1, y, z1).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x0, y, z1).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x0, y, z0).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }
}

