/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.entities.boat.ModBoatEntity;
import net.abraxator.moresnifferflowers.entities.boat.ModChestBoatEntity;
import net.abraxator.moresnifferflowers.entities.boat.VivicusBoatEntity;
import net.abraxator.moresnifferflowers.entities.boat.VivicusChestBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class ModBoatRenderer
extends BoatRenderer {
    private final Map<ModBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)MoreSnifferFlowers.loc(ModBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(context, (ModBoatEntity.Type)((Object)type), pChestBoat))));

    public ModBoatRenderer(EntityRendererProvider.Context context, boolean pChestBoat) {
        super(context, pChestBoat);
    }

    public void m_7392_(Boat entity, float pEntityYaw, float pPartialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float f2;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        float f = (float)entity.m_38385_() - pPartialTicks;
        float f1 = entity.m_38384_() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entity.m_38352_(pPartialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(entity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listmodel.m_6973_((Entity)entity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(listmodel.m_103119_(resourcelocation));
        int hex = this.boatColor(entity);
        listmodel.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f - ModColorHandler.hexToRGBLarge(hex)[0], 1.0f - ModColorHandler.hexToRGBLarge(hex)[1], 1.0f - ModColorHandler.hexToRGBLarge(hex)[2], 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexconsumer1 = buffer.m_6299_(RenderType.m_110478_());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.m_102282_().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
            }
        }
        poseStack.m_85849_();
    }

    private static String getTextureLocation(ModBoatEntity.Type type, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, ModBoatEntity.Type type, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? ModBoatRenderer.createChestBoatModelName(type) : ModBoatRenderer.createBoatModelName(type);
        ModelPart modelpart = context.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(ModBoatEntity.Type type) {
        return ModBoatRenderer.createLocation("boat/" + type.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoatEntity.Type type) {
        return ModBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String model) {
        return new ModelLayerLocation(MoreSnifferFlowers.loc(pPath), model);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        return null;
    }

    private ModBoatEntity.Type getType(Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return modBoat.getModVariant();
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return modChestBoatEntity.getModVariant();
        }
        return null;
    }

    private int boatColor(Boat boat) {
        if (this.getType(boat).equals((Object)ModBoatEntity.Type.VIVICUS)) {
            if (boat instanceof VivicusBoatEntity) {
                VivicusBoatEntity vivicusBoat = (VivicusBoatEntity)boat;
                return (Integer)vivicusBoat.colorValues().get(vivicusBoat.getColor());
            }
            if (boat instanceof VivicusChestBoatEntity) {
                VivicusChestBoatEntity vivicusChestBoat = (VivicusChestBoatEntity)boat;
                return (Integer)vivicusChestBoat.colorValues().get(vivicusChestBoat.getColor());
            }
        }
        return -1;
    }
}

