/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import java.util.Arrays;
import java.util.Objects;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.PatternspriaItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public enum BlockPattern implements StringRepresentable
{
    PIPES("pipes", MoreSnifferFlowers.loc("block_pattern_pipes"), 0, 7974997, DyeColor.LIME),
    BRICKS("bricks", MoreSnifferFlowers.loc("block_pattern_bricks"), 1, 11421052, DyeColor.MAGENTA),
    FOCUS("focus", MoreSnifferFlowers.loc("block_pattern_focus"), 2, 6962567, DyeColor.PURPLE),
    BUBBLES("bubbles", MoreSnifferFlowers.loc("block_pattern_bubbles"), 3, 7191994, DyeColor.LIGHT_BLUE),
    CLOUDS("clouds", MoreSnifferFlowers.loc("block_pattern_clouds"), 4, 0xDDDDD0, DyeColor.WHITE),
    DEEPSLATE("deepslate", MoreSnifferFlowers.loc("block_pattern_deepslate"), 5, 4276049, DyeColor.BLACK),
    DIAMOND("diamond", MoreSnifferFlowers.loc("block_pattern_diamond"), 6, 4888711, DyeColor.CYAN),
    EYE("eye", MoreSnifferFlowers.loc("block_pattern_eye"), 7, 10003879, DyeColor.LIGHT_GRAY),
    HEARTS("hearts", MoreSnifferFlowers.loc("block_pattern_hearts"), 8, 10894907, DyeColor.RED),
    HONEYCOMB("honeycomb", MoreSnifferFlowers.loc("block_pattern_honeycomb"), 9, 12483386, DyeColor.ORANGE),
    PAWS("paws", MoreSnifferFlowers.loc("block_pattern_paws"), 10, 8214592, DyeColor.BROWN),
    PRISMARINE("prismarine", MoreSnifferFlowers.loc("block_pattern_prismarine"), 11, 5460397, DyeColor.BLUE),
    SPROUTS("sprouts", MoreSnifferFlowers.loc("block_pattern_sprouts"), 12, 5146182, DyeColor.GREEN),
    STARS("stars", MoreSnifferFlowers.loc("block_pattern_stars"), 13, 15651938, DyeColor.YELLOW),
    COVER("cover", MoreSnifferFlowers.loc("block_pattern_cover"), 14, 7563641, DyeColor.GRAY),
    FLOWERS("flowers", MoreSnifferFlowers.loc("block_pattern_flowers"), 15, 11820454, DyeColor.PINK),
    FLOWER_CHARGE("flower_charge", MoreSnifferFlowers.vanillaLoc("flower_banner_pattern"), 16, 16772022, null),
    GLOBE("globe", MoreSnifferFlowers.vanillaLoc("globe_banner_pattern"), 17, 16772022, null),
    SNOUT("snout", MoreSnifferFlowers.vanillaLoc("piglin_banner_pattern"), 18, 16772022, null),
    CREEPER_CHARGE("creeper_charge", MoreSnifferFlowers.vanillaLoc("creeper_banner_pattern"), 19, 16772022, null),
    SKULL_CHARGE("skull_charge", MoreSnifferFlowers.vanillaLoc("skull_banner_pattern"), 20, 16772022, null),
    THING("thing", MoreSnifferFlowers.vanillaLoc("mojang_banner_pattern"), 21, 16772022, null),
    AMBUSH("ambush", MoreSnifferFlowers.loc("ambush_banner_pattern"), 22, 16772022, null),
    EVIL("evil", MoreSnifferFlowers.loc("evil_banner_pattern"), 23, 16772022, null),
    EMPTY("empty", null, -1, 0xDDDDD0, null);

    private final String name;
    private final ResourceLocation item;
    private final int id;
    private final int color;
    private final DyeColor dyeColor;

    private BlockPattern(String name, ResourceLocation item, int id, int color, DyeColor dyeColor) {
        this.name = name;
        this.item = item;
        this.id = id;
        this.color = color;
        this.dyeColor = dyeColor;
    }

    public static BlockPattern fromId(int index) {
        return Arrays.stream(BlockPattern.values()).filter(blockPattern -> blockPattern.id == index).findFirst().orElse(EMPTY);
    }

    public static BlockPattern fromItem(Item item) {
        return Arrays.stream(BlockPattern.values()).filter(blockPattern -> Objects.equals(blockPattern.item, ForgeRegistries.ITEMS.getKey((Object)item))).findFirst().orElse(EMPTY);
    }

    public static BlockPattern fromDyeColor(DyeColor dyeColor) {
        return Arrays.stream(BlockPattern.values()).filter(blockPattern -> blockPattern.dyeColor == dyeColor).findFirst().orElse(EMPTY);
    }

    public static BlockPattern fromState(BlockState state) {
        return (BlockPattern)((Object)state.m_61143_(ModStateProperties.BLOCK_PATTERN));
    }

    public static BlockPattern fromPatternspria(ItemStack stack) {
        if (stack.m_41784_().m_128441_("patternId")) {
            int patternId = stack.m_41783_().m_128451_("patternId");
            return BlockPattern.fromId(patternId);
        }
        return EMPTY;
    }

    public int getColor() {
        return this.color;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.item);
    }

    public boolean isBanner() {
        return this.id > 15 && this.id < 24;
    }

    public boolean isSamePattern(ItemStack patternspria) {
        int patternId = patternspria.m_41784_().m_128451_("patternId");
        return patternId == this.ordinal();
    }

    public ItemStack getItemStack(ItemStack patternspria) {
        int amount = patternspria.m_41784_().m_128451_("amount");
        return this.getItem().m_7968_().m_255036_(amount);
    }

    public static void setPatternToHolderStack(ItemStack itemStack, ItemStack patternToInsert, int amount) {
        BlockPattern.setPatternToHolderStack(itemStack, patternToInsert, amount, PatternspriaItem.getPatternspriaUses(itemStack));
    }

    public static void setPatternToHolderStack(ItemStack itemStack, ItemStack patternToInsert, int amount, int uses) {
        if (BlockPattern.fromItem(patternToInsert.m_41720_()) == EMPTY) {
            BlockPattern.removePatternFromStack(itemStack);
            return;
        }
        int patternId = Objects.requireNonNull(BlockPattern.fromItem(patternToInsert.m_41720_())).ordinal();
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("amount", amount);
        tag.m_128405_("patternId", patternId);
        tag.m_128405_("uses", uses);
        itemStack.m_41751_(tag);
    }

    public static void removePatternFromStack(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("amount", 4);
        tag.m_128405_("patternId", -1);
        tag.m_128405_("uses", 0);
        itemStack.m_41751_(tag);
    }

    public static boolean isEmpty(BlockState state) {
        return state.m_61143_(ModStateProperties.BLOCK_PATTERN) == EMPTY;
    }
}

