/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import java.util.Optional;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.capability.CorruptionCapability;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.recipes.CorruptionRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CorruptedProjectile
extends ThrowableItemProjectile {
    public CorruptedProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public CorruptedProjectile(Level level, LivingEntity pShooter) {
        super((EntityType)ModEntityTypes.CORRUPTED_SLIME_BALL.get(), pShooter, level);
    }

    public CorruptedProjectile(Level level) {
        super((EntityType)ModEntityTypes.CORRUPTED_SLIME_BALL.get(), level);
    }

    protected Item m_7881_() {
        return (Item)ModItems.CORRUPTED_SLIME_BALL.get();
    }

    private ParticleOptions getParticle() {
        return new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_());
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        for (int i = 0; i < 16; ++i) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 3) {
            this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)3549245).m_252839_(), 1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
            if (!this.m_9236_().f_46443_) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos pos = result.m_82425_();
        BlockPos posRelative = result.m_82425_().m_121945_(result.m_82434_());
        BlockPos posRelativeBelow = result.m_82425_().m_121945_(result.m_82434_()).m_7495_();
        BlockState state = this.m_9236_().m_8055_(pos);
        BlockState stateRelative = this.m_9236_().m_8055_(posRelative);
        BlockState stateRelativeBelow = this.m_9236_().m_8055_(result.m_82425_().m_121945_(result.m_82434_()).m_7495_());
        if (this.m_9236_().m_8055_(pos).m_204336_(ModTags.ModBlockTags.NO_CORRUPTED_SLIME_COLLISION)) {
            return;
        }
        if (CorruptedProjectile.checkState(this.m_9236_().m_8055_(result.m_82425_()))) {
            Integer layer = (Integer)state.m_61143_((Property)ModStateProperties.LAYER);
            this.m_9236_().m_46597_(pos, (BlockState)((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()).m_49966_().m_61124_((Property)ModStateProperties.LAYER, (Comparable)Integer.valueOf(layer + 1)));
        } else {
            this.transformBlock(this.m_9236_(), pos);
            if (CorruptedProjectile.checkState(this.m_9236_().m_8055_(result.m_82425_().m_121945_(result.m_82434_())))) {
                Integer layerRelative = (Integer)stateRelative.m_61143_((Property)ModStateProperties.LAYER);
                this.m_9236_().m_46597_(posRelative, (BlockState)((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()).m_49966_().m_61124_((Property)ModStateProperties.LAYER, (Comparable)Integer.valueOf(layerRelative + 1)));
            }
            if (stateRelative.m_60713_(Blocks.f_50016_) || stateRelative.m_204336_(BlockTags.f_13076_) || stateRelative.m_247087_() && !stateRelative.m_278721_()) {
                if (result.m_82434_() == Direction.UP && !state.m_60713_(Blocks.f_50016_)) {
                    this.m_9236_().m_46597_(result.m_82425_().m_121945_(result.m_82434_()), (BlockState)((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()).m_49966_().m_61124_((Property)ModStateProperties.LAYER, (Comparable)Integer.valueOf(1)));
                    this.m_146870_();
                } else {
                    CorruptedProjectile projectile = new CorruptedProjectile(this.m_9236_());
                    projectile.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    projectile.m_19915_(this.m_146908_(), (float)Math.PI / 90);
                    this.m_9236_().m_7967_((Entity)projectile);
                }
            } else if (CorruptionRecipe.canBeCorrupted(stateRelative.m_60734_(), this.m_9236_()) && !stateRelative.m_60713_((Block)ModBlocks.BONDRIPIA.get())) {
                this.transformBlock(this.m_9236_(), posRelative);
            }
        }
        this.m_146870_();
    }

    private boolean transformBlock(Level level, BlockPos blockPos) {
        Optional pos = BlockPos.m_121930_((BlockPos)blockPos, (int)1, (int)1, blockPos1 -> CorruptionRecipe.canBeCorrupted(level.m_8055_(blockPos1).m_60734_(), level));
        BlockState state = level.m_8055_(blockPos);
        if (CorruptionRecipe.canBeCorrupted(state.m_60734_(), level)) {
            Optional<Block> optional = CorruptionRecipe.getCorruptedBlock(state.m_60734_(), level);
            optional.ifPresent(block -> {
                Block patt6569$temp = level.m_8055_(blockPos).m_60734_();
                if (patt6569$temp instanceof Corruptable) {
                    Corruptable corruptable = (Corruptable)patt6569$temp;
                    corruptable.onCorrupt(level, blockPos, level.m_8055_(blockPos), (Block)block);
                } else {
                    level.m_46597_(blockPos, block.m_152465_(state));
                    CorruptionCapability.onCorruptionSource(level, blockPos);
                }
                Player patt6977$temp = level.m_45930_((Entity)this, 15.0);
                if (patt6977$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt6977$temp;
                    ModAdvancementCritters.CORRUPTED_BLOCK.m_222618_(serverPlayer);
                }
                state.m_60808_((BlockGetter)level, blockPos).m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    for (int i = 0; i < 2; ++i) {
                        for (Vec3 vec3 : this.generateTwoPoints(level, minX, minY, minZ, maxX, maxY, maxZ)) {
                            this.m_9236_().m_7605_((Entity)this, (byte)4);
                        }
                    }
                });
                level.m_7106_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)4469320).m_252839_(), 1.0f), (double)blockPos.m_123341_() + level.f_46441_.m_188500_(), (double)blockPos.m_123342_() + level.f_46441_.m_188500_(), (double)blockPos.m_123343_() + level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
            });
            return true;
        }
        return false;
    }

    private Vec3[] generateTwoPoints(Level level, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vec3[] points = new Vec3[]{new Vec3((double)level.f_46441_.m_216332_((int)(minX * 10.0), (int)(maxX * 10.0)) / 10.0, maxZ, (double)level.f_46441_.m_216332_((int)(minY * 10.0), (int)(maxY * 10.0)) / 10.0), new Vec3(maxX, (double)level.f_46441_.m_216332_((int)(minZ * 10.0), (int)(maxZ * 10.0)) / 10.0, (double)level.f_46441_.m_216332_((int)(minY * 10.0), (int)(maxY * 10.0)) / 10.0)};
        return points;
    }

    private static boolean checkState(BlockState state) {
        return state.m_60713_((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()) && (Integer)state.m_61143_((Property)ModStateProperties.LAYER) != 8;
    }
}

