/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SaltProjectile
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> CORRUPTED = SynchedEntityData.m_135353_(SaltProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SaltProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SaltProjectile(Level level, LivingEntity pShooter) {
        super((EntityType)ModEntityTypes.SALT_PROJECTILE.get(), pShooter, level);
    }

    public SaltProjectile(Level level) {
        super((EntityType)ModEntityTypes.SALT_PROJECTILE.get(), level);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos pos = result.m_82425_();
        BlockPos posRelative = result.m_82425_().m_121945_(result.m_82434_());
        BlockState state = this.m_9236_().m_8055_(pos);
        BlockState stateRelative = this.m_9236_().m_8055_(posRelative);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.isCorrupted()) {
            if (this.placeBlockSalt(pos, state)) {
                this.m_146870_();
            } else if (this.placeBlockSalt(posRelative, stateRelative)) {
                this.m_146870_();
            }
        } else if (this.placeBlockSour(pos, 0)) {
            this.m_146870_();
        } else if (this.placeBlockSour(posRelative, 0)) {
            this.m_146870_();
        }
    }

    public boolean placeBlockSalt(BlockPos pos, BlockState state) {
        Level level = this.m_9236_();
        if (state.m_247087_()) {
            if (!((Block)ModBlocks.SALTY_CLUMP.get()).m_7898_(state, (LevelReader)level, pos)) {
                return true;
            }
            level.m_7731_(pos, (BlockState)((Block)ModBlocks.SALTY_CLUMP.get()).m_49966_().m_61124_((Property)ModStateProperties.AMOUNT_4, (Comparable)Integer.valueOf(1)), 2);
            return true;
        }
        if (state.m_60713_((Block)ModBlocks.SALTY_CLUMP.get())) {
            int amount = (Integer)state.m_61143_((Property)ModStateProperties.AMOUNT_4);
            if (amount < 4) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ModStateProperties.AMOUNT_4, (Comparable)Integer.valueOf(amount + 1)), 3);
            } else {
                level.m_7731_(pos, (BlockState)((Block)ModBlocks.DRIPSALT.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_155997_, (Comparable)Direction.UP), 3);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockSour(BlockPos pos, int loop) {
        Level level = this.m_9236_();
        BlockState newState = level.m_8055_(pos);
        if (loop > 2) {
            return false;
        }
        if (newState.m_247087_()) {
            if (!((Block)ModBlocks.SOUR_PUDDLE.get()).m_7898_(newState, (LevelReader)level, pos)) {
                return true;
            }
            level.m_7731_(pos, ((Block)ModBlocks.SOUR_PUDDLE.get()).m_49966_(), 3);
            return true;
        }
        if (newState.m_60713_((Block)ModBlocks.SOUR_PUDDLE.get())) {
            return this.placeBlockSour(SaltProjectile.aroundPos(pos, this.f_19796_.m_188503_(7)), loop + 1);
        }
        return false;
    }

    public static BlockPos aroundPos(BlockPos pos, int direction) {
        return switch (direction) {
            case 0 -> pos.m_122012_().m_122024_();
            case 1 -> pos.m_122012_();
            case 2 -> pos.m_122012_().m_122029_();
            case 3 -> pos.m_122029_();
            case 4 -> pos.m_122019_().m_122029_();
            case 5 -> pos.m_122019_();
            case 6 -> pos.m_122019_().m_122024_();
            case 7 -> pos.m_122024_();
            default -> pos;
        };
    }

    protected Item m_7881_() {
        return (Item)ModItems.SALTY_SPICE.get();
    }

    public boolean isCorrupted() {
        return (Boolean)this.f_19804_.m_135370_(CORRUPTED);
    }

    public void setCorrupted(boolean corrupted) {
        this.f_19804_.m_135381_(CORRUPTED, (Object)corrupted);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("corrupted", this.isCorrupted());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCorrupted(tag.m_128471_("corrupted"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CORRUPTED, (Object)false);
    }
}

