/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.abraxator.moresnifferflowers.blockentities.GiantCropBlockEntity;
import net.abraxator.moresnifferflowers.entities.BoblingEntity;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.registries.RegistryObject;

public class BoblingGiantCropGoal
extends Goal {
    private final BoblingEntity bobling;
    private final int searchArea;
    private final double speed;
    private Vec3 wantedPos;
    private int searchCooldown;
    private int randomInterval;
    private long lastFarmSearchTime;

    public BoblingGiantCropGoal(BoblingEntity bobling, int searchArea, double speed) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.bobling = bobling;
        this.searchArea = searchArea;
        this.speed = speed;
        this.randomInterval = BoblingGiantCropGoal.m_186073_((int)10);
        if (this.bobling.getWantedPos() != null && this.bobling.m_9236_().m_8055_(this.bobling.getWantedPos().m_7495_()).m_60713_(Blocks.f_50093_)) {
            this.wantedPos = this.bobling.getWantedPos().m_252807_();
        }
    }

    public boolean m_8036_() {
        return this.checkFarm(this.findFarm());
    }

    private boolean gonnaPlant() {
        return this.wantedPos != null && this.wantedPos.m_82509_((Position)this.bobling.m_20182_(), 1.5);
    }

    private boolean checkFarm(Optional<BlockPos> pos) {
        if (this.randomInterval > 0 && this.bobling.m_217043_().m_188503_(this.randomInterval + (this.bobling.getWantedPos() != null ? 5 : 0)) != 0) {
            long currentTime = this.bobling.m_9236_().m_46467_();
            if (this.searchCooldown <= 0 && (this.lastFarmSearchTime == 0L || currentTime - this.lastFarmSearchTime > 100L)) {
                pos = this.findFarm();
                this.searchCooldown = 100;
                this.lastFarmSearchTime = currentTime;
            }
            pos.ifPresent(blockPos -> {
                this.wantedPos = blockPos.m_252807_();
                this.bobling.setWantedPos(Optional.of(BlockPos.m_274446_((Position)this.wantedPos)));
                this.bobling.m_21573_().m_26519_(this.wantedPos.f_82479_, this.wantedPos.f_82480_, this.wantedPos.f_82481_, this.speed);
            });
        }
        return this.wantedPos != null;
    }

    private Optional<BlockPos> findFarm() {
        Level level = this.bobling.m_9236_();
        AABB entityAABB = new AABB(BlockPos.m_274446_((Position)this.bobling.m_20182_())).m_82377_((double)this.searchArea, 3.0, (double)this.searchArea);
        List<BlockPos> nearbyFarmlandsPos = BlockPos.m_121921_((AABB)entityAABB).filter(blockPos -> {
            BlockState blockState = level.m_8055_(blockPos);
            return blockState.m_60713_(Blocks.f_50093_);
        }).toList();
        if (nearbyFarmlandsPos.isEmpty()) {
            return Optional.empty();
        }
        Optional randomFarmlandPos = nearbyFarmlandsPos.stream().findAny();
        AABB aabb = AABB.m_165882_((Vec3)((BlockPos)randomFarmlandPos.get()).m_252807_(), (double)2.0, (double)0.0, (double)2.0).m_82363_(0.0, 3.0, 0.0);
        boolean flag = BlockPos.m_121921_((AABB)aabb).allMatch(blockPos1 -> {
            if (blockPos1.m_123342_() == ((BlockPos)randomFarmlandPos.get()).m_123342_()) {
                return level.m_8055_(blockPos1).m_60713_(Blocks.f_50093_);
            }
            return level.m_8055_(blockPos1).m_60713_(Blocks.f_50016_);
        });
        return flag ? randomFarmlandPos : Optional.empty();
    }

    public boolean m_8045_() {
        boolean flag = true;
        if (this.bobling.m_9236_().m_46467_() % 50L == 0L) {
            flag = this.checkFarm(Optional.empty());
        }
        return !this.gonnaPlant() && flag;
    }

    public void m_8041_() {
        if (this.gonnaPlant()) {
            RegistryObject giantBlock = (RegistryObject)Util.m_214621_(List.of(ModBlocks.GIANT_CARROT, ModBlocks.GIANT_BEETROOT, ModBlocks.GIANT_NETHERWART, ModBlocks.GIANT_POTATO, ModBlocks.GIANT_WHEAT), (RandomSource)this.bobling.m_217043_());
            AABB aabb = AABB.m_165882_((Vec3)this.wantedPos.m_82520_(0.0, 2.0, 0.0), (double)1.0, (double)1.0, (double)1.0);
            Level level = this.bobling.m_9236_();
            BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
                level.m_46597_(pos, (BlockState)((Block)giantBlock.get()).m_49966_().m_61124_((Property)ModStateProperties.CENTER, (Comparable)Boolean.valueOf(pos.equals((Object)BlockPos.m_274446_((Position)this.wantedPos.m_82520_(0.0, 1.0, 0.0))))));
                BlockEntity patt4862$temp = level.m_7702_(pos);
                if (patt4862$temp instanceof GiantCropBlockEntity) {
                    GiantCropBlockEntity entity = (GiantCropBlockEntity)patt4862$temp;
                    entity.center = this.bobling.getWantedPos().m_7494_();
                    entity.state = 2;
                }
                ScheduledTick tick = new ScheduledTick((Object)level.m_8055_(pos).m_60734_(), pos, level.m_46467_() + 50L, level.m_183596_());
                level.m_183326_().m_183393_(tick);
                this.bobling.m_142687_(Entity.RemovalReason.DISCARDED);
            });
        }
    }

    public void m_8037_() {
        if (this.searchCooldown >= 100) {
            --this.searchCooldown;
        }
    }
}

