/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.components.DyespriaMode;
import net.abraxator.moresnifferflowers.components.EntityDistanceComparator;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class DyespriaItem
extends BlockItem
implements Colorable {
    public DyespriaItem(Item.Properties properties) {
        super((Block)ModBlocks.DYESPRIA_PLANT.get(), properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        ItemStack stack = context.m_43722_();
        Dye dye = Dye.getDyeFromDyespria(stack);
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (DyespriaItem.checkDyedBlock(blockState) || blockState.m_60734_() instanceof Colorable && !dye.isEmpty() || BlockPatternCapability.hasPattern(blockPos, level) && !player.m_6047_()) {
            DyespriaMode dyespriaMode = this.getMode(stack);
            AtomicBoolean canContinueDyeing = new AtomicBoolean(true);
            DyespriaMode.DyespriaSelector dyespriaSelector = new DyespriaMode.DyespriaSelector(blockPos, blockState, this.getMatchTag(blockState), level, context.m_43719_(), player.m_6047_());
            Set<BlockPos> set = dyespriaMode.getSelector().apply(dyespriaSelector);
            set.stream().sorted(new EntityDistanceComparator(blockPos)).takeWhile(t -> canContinueDyeing.get()).forEach(blockPos1 -> {
                BlockState state = level.m_8055_(blockPos1);
                if (!Dye.getDyeFromDyespria(stack).isEmpty()) {
                    this.colorOne(stack, level, (BlockPos)blockPos1, state, context.m_43719_(), player, BlockPatternCapability.hasPattern(blockPos, level));
                } else {
                    canContinueDyeing.set(false);
                }
            });
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return this.handlePlacement(blockPos, level, player, context.m_43724_(), stack);
    }

    public DyespriaMode getMode(ItemStack stack) {
        return DyespriaMode.byIndex(stack.m_41784_().m_128445_("mode"));
    }

    @Nullable
    private TagKey<Block> getMatchTag(BlockState blockState) {
        TagKey<Block> tagKey;
        if (blockState instanceof Colorable) {
            Colorable colorable = (Colorable)blockState;
            tagKey = colorable.matchTag();
        } else {
            tagKey = null;
        }
        return tagKey;
    }

    private InteractionResult handlePlacement(BlockPos blockPos, Level level, Player player, InteractionHand hand, ItemStack stack) {
        ItemStack oldStack = stack.m_41777_();
        BlockPos posForDyespria = blockPos.m_7494_();
        BlockHitResult blockHitResult = new BlockHitResult(posForDyespria.m_7495_().m_252807_(), Direction.UP, posForDyespria.m_7495_(), false);
        UseOnContext useOnCtx = new UseOnContext(level, player, hand, stack, blockHitResult);
        InteractionResult result = super.m_6225_(useOnCtx);
        BlockEntity blockEntity = level.m_7702_(blockPos.m_7494_());
        if (blockEntity instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            entity.dye = Dye.getDyeFromDyespria(oldStack);
            if (DyespriaItem.getDyespriaUses(oldStack) < 4) {
                entity.dye = new Dye(entity.dye.color(), entity.dye.amount() - 1);
            }
            entity.m_6596_();
        }
        return result;
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        BlockState state = super.m_5965_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)ModStateProperties.AGE_3, (Comparable)Integer.valueOf(3));
    }

    public void colorOne(ItemStack stack, Level level, BlockPos blockPos, BlockState blockState, Direction face, Player player, boolean clickedPattern) {
        Dye dye = Dye.getDyeFromDyespria(stack);
        if (!this.canDye(blockState, dye)) {
            return;
        }
        if (BlockPatternCapability.hasPattern(blockPos, level) && !player.m_6047_() && clickedPattern) {
            this.colorPattern(dye, level, blockPos);
            this.finishColoring(dye, level, stack, blockPos, face);
            return;
        }
        Block block = blockState.m_60734_();
        if (block instanceof Colorable) {
            Colorable colorable = (Colorable)block;
            if (colorable.canBeColored(blockState, dye)) {
                colorable.colorBlock(level, blockPos, blockState, dye);
                this.finishColoring(dye, level, stack, blockPos, face);
            }
        } else {
            this.dyeNonColorableBlock(blockState, blockPos, dye.color(), level);
            this.finishColoring(dye, level, stack, blockPos, face);
        }
    }

    public void colorPattern(Dye dye, Level level, BlockPos pos) {
        int patternId = BlockPatternCapability.getPattern(pos, level).patternId();
        int originalColor = BlockPatternCapability.getPattern(pos, level).color();
        int dyeColor = dye.color().m_41070_();
        float[] originalHSB = ModColorHandler.hexToRGBLarge(originalColor);
        float[] dyeHSB = ModColorHandler.hexToRGBLarge(dyeColor);
        int r = Math.round((originalHSB[0] * 5.0f + dyeHSB[0]) / 6.0f);
        int g = Math.round((originalHSB[1] * 5.0f + dyeHSB[1]) / 6.0f);
        int b = Math.round((originalHSB[2] * 5.0f + dyeHSB[2]) / 6.0f);
        int finalColor = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        BlockPatternCapability.recolor(level, pos, finalColor);
    }

    public boolean m_142522_(ItemStack stack) {
        return !Dye.getDyeFromDyespria(stack).isEmpty();
    }

    public int m_142159_(ItemStack stack) {
        int input = DyespriaItem.getDyespriaUses(stack) - 1;
        int maxInput = 4;
        return ModColorHandler.barColorHelper(input, maxInput);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)DyespriaItem.getDyespriaUses(stack) * 13.0f / 4.0f);
    }

    public void finishColoring(Dye dye, Level level, ItemStack dyespria, BlockPos blockPos, Direction face) {
        int dyeCount;
        int uses = DyespriaItem.getDyespriaUses(dyespria) - 1;
        if (uses <= 0) {
            dyeCount = dye.amount() - 1;
            DyespriaItem.setDyespriaUses(dyespria, 4);
        } else {
            dyeCount = dye.amount();
            DyespriaItem.setDyespriaUses(dyespria, uses);
        }
        ItemStack itemStack = Dye.stackFromDye(new Dye(dye.color(), dyeCount));
        Dye.setDyeToDyeHolderStack(dyespria, itemStack, itemStack.m_41613_(), DyespriaItem.getDyespriaUses(dyespria));
        if (level.f_46443_) {
            this.particles(level.m_213780_(), level, dye, blockPos, face);
        }
    }

    public static int getDyespriaUses(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("uses") ? tag.m_128451_("uses") : 4;
    }

    public static void setDyespriaUses(ItemStack stack, int uses) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("uses", uses);
        stack.m_41751_(tag);
    }

    private boolean canDye(BlockState blockState, Dye dye) {
        return blockState.m_61138_(ModStateProperties.COLOR) && !((DyeColor)blockState.m_61143_(ModStateProperties.COLOR)).equals((Object)dye.color()) || !dye.isEmpty();
    }

    public static boolean checkDyedBlock(BlockState blockState) {
        return blockState.m_204336_(ModTags.ModBlockTags.DYED);
    }

    private void dyeNonColorableBlock(BlockState blockState, BlockPos blockPos, DyeColor newColor, Level level) {
        BlockEntity blockEntity;
        if (!DyespriaItem.checkDyedBlock(blockState)) {
            return;
        }
        ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_());
        String modId = location.m_135827_();
        Object blockId = location.m_135815_();
        if (((String)blockId).equals("candle") || ((String)blockId).equals("shulker_box") || ((String)blockId).equals("terracotta")) {
            blockId = "white_" + (String)blockId;
        }
        if (((String)blockId).equals("glass") || ((String)blockId).equals("glass_pane")) {
            blockId = "white_stained_" + (String)blockId;
        }
        String validColorName = "white|light_gray|gray|black|brown|red|orange|yellow|lime|green|cyan|light_blue|blue|purple|magenta|pink";
        String finalBlockName = ((String)blockId).replaceFirst(validColorName, newColor.m_41065_());
        Block finalBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(modId, finalBlockName));
        BlockState finalBlockState = finalBlock.m_49966_();
        BlockEntity originalShulker = level.m_7702_(blockPos);
        CompoundTag shulkerData = null;
        if (originalShulker instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity entity = (ShulkerBoxBlockEntity)originalShulker;
            shulkerData = entity.m_187482_();
        }
        if (finalBlock != Blocks.f_50016_) {
            level.m_46597_(blockPos, DyespriaItem.copyAllBlockStateProperties(blockState, finalBlockState));
        }
        if (shulkerData != null && (blockEntity = level.m_7702_(blockPos)) instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity newShulkerBox = (ShulkerBoxBlockEntity)blockEntity;
            newShulkerBox.m_59693_(shulkerData);
        }
    }

    public static <T extends Comparable<T>> BlockState copyAllBlockStateProperties(BlockState sourceState, BlockState targetState) {
        for (Property property : sourceState.m_61147_()) {
            if (!targetState.m_61138_(property)) continue;
            Comparable value = sourceState.m_61143_(property);
            targetState = (BlockState)targetState.m_61124_(property, value);
        }
        return targetState;
    }

    public boolean m_142305_(ItemStack stack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player player, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(player)) {
            if (pOther.m_41619_()) {
                pAccess.m_142104_(this.remove(stack));
                this.playRemoveOneSound((Entity)player);
            } else {
                ItemStack itemStack = this.add(stack, Dye.getDyeFromDyespria(stack), pOther);
                pAccess.m_142104_(itemStack);
                if (itemStack.m_41619_()) {
                    this.playInsertSound((Entity)player);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dye, int amount) {
        Dye.setDyeToDyeHolderStack(destinationStack, dye, amount);
    }

    private ItemStack remove(ItemStack stack) {
        Dye dye = Dye.getDyeFromDyespria(stack);
        int uses = DyespriaItem.getDyespriaUses(stack);
        if (!dye.isEmpty()) {
            Dye.setDyeColorToStack(stack, DyeColor.WHITE, 0);
            ItemStack returnStack = Dye.stackFromDye(new Dye(dye.color(), dye.amount() - (uses == 4 ? 0 : 1)));
            DyespriaItem.setDyespriaUses(stack, 4);
            return returnStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        Dye dye = Dye.getDyeFromDyespria(stack);
        MutableComponent usage = Component.m_264568_((String)"tooltip.dyespria.usage", (String)"Right click with dye to insert \nRight click caulorflower to repaint \nSneak to apply to the whole column \n").m_130940_(ChatFormatting.GOLD);
        Stream<String> usageComponents = Arrays.stream(usage.getString().split("\n", -1)).filter(s -> !s.isEmpty()).map(String::trim);
        usageComponents.forEach(s -> tooltipComponents.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.GOLD)));
        tooltipComponents.add((Component)Component.m_237119_());
        tooltipComponents.add(DyespriaItem.getCurrentModeComponent(this.getMode(stack)));
        tooltipComponents.add((Component)Component.m_237119_());
        if (!dye.isEmpty()) {
            MutableComponent name = Component.m_237113_((String)(dye.amount() + " - " + WordUtils.capitalizeFully((String)dye.color().m_41065_().toLowerCase().replaceAll("[^a-z_]", "").replaceAll("_", " ")))).m_130948_(Style.f_131099_.m_178520_(Dye.colorForDye(this, dye.color())));
            tooltipComponents.add((Component)name);
        } else {
            tooltipComponents.add((Component)Component.m_264568_((String)"tooltip.dyespria.empty", (String)"Empty").m_130940_(ChatFormatting.GRAY));
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    @Override
    public Map<DyeColor, Integer> colorValues() {
        return (Map)Util.m_137469_((Object)Maps.newLinkedHashMap(), dyeColorHexFormatMap -> {
            dyeColorHexFormatMap.put(DyeColor.WHITE, -1);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_GRAY, -6449253);
            dyeColorHexFormatMap.put(DyeColor.GRAY, -12103854);
            dyeColorHexFormatMap.put(DyeColor.BLACK, -14869215);
            dyeColorHexFormatMap.put(DyeColor.BROWN, -8170446);
            dyeColorHexFormatMap.put(DyeColor.RED, -3254199);
            dyeColorHexFormatMap.put(DyeColor.ORANGE, -485835);
            dyeColorHexFormatMap.put(DyeColor.YELLOW, -4525);
            dyeColorHexFormatMap.put(DyeColor.LIME, -8337633);
            dyeColorHexFormatMap.put(DyeColor.GREEN, -10585066);
            dyeColorHexFormatMap.put(DyeColor.CYAN, -13194868);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_BLUE, -9381404);
            dyeColorHexFormatMap.put(DyeColor.BLUE, -12102740);
            dyeColorHexFormatMap.put(DyeColor.PURPLE, -5152830);
            dyeColorHexFormatMap.put(DyeColor.MAGENTA, -2984263);
            dyeColorHexFormatMap.put(DyeColor.PINK, -479036);
        });
    }

    public static Component getCurrentModeComponent(DyespriaMode dyespriaMode) {
        MutableComponent baseText = Component.m_237115_((String)"message.more_sniffer_flowers.dyespria_mode").m_130946_(": ").m_130940_(ChatFormatting.GOLD);
        MutableComponent modeText = Component.m_237113_((String)dyespriaMode.m_7912_()).m_130940_(dyespriaMode.getTextColor());
        return baseText.m_7220_((Component)modeText);
    }

    public void changeMode(ServerPlayer player, ItemStack stack, int amount) {
        DyespriaMode currentMode = this.getMode(stack);
        DyespriaMode newMode = DyespriaMode.shift(currentMode, amount);
        CompoundTag tag = stack.m_41784_();
        tag.m_128344_("mode", (byte)newMode.ordinal());
        stack.m_41751_(tag);
        player.m_5661_(DyespriaItem.getCurrentModeComponent(DyespriaMode.byIndex(newMode.ordinal())), true);
    }
}

