/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.DyespriaMode;
import net.abraxator.moresnifferflowers.components.EntityDistanceComparator;
import net.abraxator.moresnifferflowers.components.PatternspriaMode;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PatternspriaItem
extends Item {
    private final Map<BlockPos, BlockPatternCapability.PatternData> cached_patterns = new HashMap<BlockPos, BlockPatternCapability.PatternData>();
    public static final int DEFAULT_COLOR = 11113613;

    public PatternspriaItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPatternCapability.PatternData patternData;
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        ItemStack stack = context.m_43722_();
        Direction horizontalDirection = context.m_8125_();
        BlockPattern fromPatternspria = BlockPattern.fromPatternspria(stack);
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_() && BlockPatternCapability.hasPattern(blockPos, level)) {
            if (!stack.m_41784_().m_128441_("color")) {
                stack.m_41784_().m_128405_("color", -1);
            }
            if (stack.m_41784_().m_128451_("color") != BlockPatternCapability.getPattern(blockPos, level).color()) {
                this.copyColor(stack, level, blockPos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (blockState.m_60713_((Block)ModBlocks.PATTERNFLOWER.get()) && fromPatternspria != BlockPattern.EMPTY) {
            if (BlockPattern.fromState(blockState).equals((Object)fromPatternspria)) {
                return InteractionResult.PASS;
            }
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(ModStateProperties.BLOCK_PATTERN, (Comparable)((Object)fromPatternspria))).m_61124_((Property)ModStateProperties.EMPTY, (Comparable)Boolean.valueOf(false)), 3);
            this.finishColoring(fromPatternspria.getItemStack(stack), level, stack, blockPos, context.m_43719_());
            return InteractionResult.SUCCESS;
        }
        if (this.canUse(blockPos, level, stack)) {
            int oldCount = stack.m_41784_().m_128451_("amount");
            AtomicInteger currentCount = new AtomicInteger(oldCount);
            AtomicBoolean canContinueDyeing = new AtomicBoolean(true);
            PatternspriaMode dyespriaMode = this.getMode(stack);
            PatternspriaMode.DyespriaSelector dyespriaSelector = new PatternspriaMode.DyespriaSelector(blockPos, level, context.m_43719_());
            Set<BlockPos> set = dyespriaMode.getSelector().apply(dyespriaSelector);
            set.stream().sorted(new EntityDistanceComparator(blockPos)).takeWhile(t -> canContinueDyeing.get()).forEach(blockPos1 -> {
                BlockState state = level.m_8055_(blockPos1);
                if (this.canUse((BlockPos)blockPos1, level, stack) && fromPatternspria != BlockPattern.EMPTY) {
                    this.patternOne(stack, level, (BlockPos)blockPos1, fromPatternspria, context.m_43719_(), horizontalDirection);
                    currentCount.getAndDecrement();
                } else if (stack.m_41784_().m_128451_("amount") <= 0 || fromPatternspria == BlockPattern.EMPTY) {
                    canContinueDyeing.set(false);
                }
                if (oldCount - currentCount.get() >= 64) {
                    canContinueDyeing.set(false);
                }
            });
            if (!level.f_46443_) {
                BlockPatternCapability.setBulkPatterns(this.cached_patterns, level);
                this.cached_patterns.clear();
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockPattern pattern = fromPatternspria;
        if (BlockPatternCapability.hasPattern(blockPos, level) && pattern != BlockPattern.EMPTY && !(patternData = BlockPatternCapability.getPattern(blockPos, level)).direction().equals((Object)horizontalDirection) && pattern.getId() == patternData.patternId()) {
            BlockPatternCapability.setPattern(blockPos, new BlockPatternCapability.PatternData(patternData.patternId(), patternData.color(), horizontalDirection, patternData.isGlowing()), level);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public PatternspriaMode getMode(ItemStack stack) {
        return PatternspriaMode.byIndex(stack.m_41784_().m_128445_("mode"));
    }

    public boolean patternOne(ItemStack stack, Level level, BlockPos blockPos, BlockPattern pattern, Direction face, Direction horizontalDirection) {
        if (!this.canUse(blockPos, level, stack) && pattern == BlockPattern.EMPTY) {
            return false;
        }
        int color = this.getColor(stack);
        if (BlockPatternCapability.hasPattern(blockPos, level)) {
            color = BlockPatternCapability.getPattern(blockPos, level).color();
        }
        if (!level.f_46443_) {
            this.cached_patterns.put(blockPos.m_7949_(), new BlockPatternCapability.PatternData(pattern.getId(), color, horizontalDirection, false));
        }
        this.finishColoring(pattern.getItemStack(stack), level, stack, blockPos, face);
        return true;
    }

    private boolean canUse(BlockPos pos, Level level, ItemStack patternspria) {
        if (BlockPattern.fromPatternspria(patternspria) == BlockPattern.EMPTY) {
            return false;
        }
        int groundId = -1;
        if (BlockPatternCapability.hasPattern(pos, level)) {
            groundId = BlockPatternCapability.getPattern(pos, level).patternId();
        }
        int inputId = BlockPattern.fromPatternspria(patternspria).getId();
        boolean isSturdy = false;
        for (Direction dir : Direction.values()) {
            if (!level.m_8055_(pos).m_60783_((BlockGetter)level, pos, dir)) continue;
            isSturdy = true;
            break;
        }
        return (!BlockPatternCapability.hasPattern(pos, level) || inputId != groundId) && patternspria.m_41784_().m_128451_("amount") > 0 && isSturdy;
    }

    public void finishColoring(ItemStack blockPattern, Level level, ItemStack patternspria, BlockPos blockPos, Direction face) {
        int uses = PatternspriaItem.getPatternspriaUses(patternspria) - 1;
        BlockPattern pattern = BlockPattern.fromItem(blockPattern.m_41720_());
        if (uses <= 0) {
            blockPattern.m_41774_(1);
            if (blockPattern.m_41619_()) {
                BlockPattern.removePatternFromStack(patternspria);
            } else {
                PatternspriaItem.setPatternspriaUses(patternspria, 4);
            }
        } else {
            PatternspriaItem.setPatternspriaUses(patternspria, uses);
        }
        BlockPattern.setPatternToHolderStack(patternspria, blockPattern, blockPattern.m_41613_(), PatternspriaItem.getPatternspriaUses(patternspria));
        if (level.f_46443_ && pattern != BlockPattern.EMPTY) {
            this.spawnParticles(level.m_213780_(), level, pattern, blockPos, face, patternspria);
        }
    }

    public ItemStack addPattern(ItemStack patternspria, ItemStack itemToInsert) {
        BlockPattern pattern = BlockPattern.fromItem(itemToInsert.m_41720_());
        BlockPattern patternInside = BlockPattern.fromPatternspria(patternspria);
        if (patternInside == BlockPattern.EMPTY) {
            BlockPattern.removePatternFromStack(patternspria);
        }
        if (pattern == BlockPattern.EMPTY) {
            return itemToInsert;
        }
        if (patternInside == BlockPattern.EMPTY || patternspria.m_41784_().m_128451_("amount") <= 0) {
            this.onAddPattern(patternspria, itemToInsert, itemToInsert.m_41613_());
            return ItemStack.f_41583_;
        }
        if (!pattern.isSamePattern(patternspria)) {
            ItemStack returnStack = patternInside.getItemStack(patternspria);
            this.onAddPattern(patternspria, itemToInsert, itemToInsert.m_41613_());
            return returnStack;
        }
        int amountInside = patternspria.m_41784_().m_128451_("amount");
        int freeSpace = 64 - amountInside;
        if (freeSpace <= 0) {
            return itemToInsert;
        }
        int amountToAdd = Math.min(itemToInsert.m_41613_(), freeSpace);
        this.onAddPattern(patternspria, itemToInsert, amountInside + amountToAdd);
        itemToInsert.m_41774_(amountToAdd);
        return itemToInsert;
    }

    public void onAddPattern(ItemStack destinationStack, ItemStack pattern, int amount) {
        destinationStack.m_41784_().m_128473_("color");
        int uses = PatternspriaItem.getPatternspriaUses(destinationStack);
        BlockPattern.setPatternToHolderStack(destinationStack, pattern, amount, uses <= 0 ? 4 : uses);
    }

    private ItemStack removePattern(ItemStack stack) {
        BlockPattern pattern = BlockPattern.fromPatternspria(stack);
        int uses = PatternspriaItem.getPatternspriaUses(stack);
        if (pattern != BlockPattern.EMPTY) {
            ItemStack returnStack = pattern.getItemStack(stack);
            BlockPattern.removePatternFromStack(stack);
            returnStack.m_41774_(uses == 4 ? 0 : 1);
            return returnStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_142305_(ItemStack stack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player player, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(player)) {
            if (pOther.m_41619_()) {
                pAccess.m_142104_(this.removePattern(stack));
                this.playRemoveOneSound((Entity)player);
            } else {
                ItemStack itemStack = this.addPattern(stack, pOther);
                pAccess.m_142104_(itemStack);
                if (itemStack.m_41619_()) {
                    this.playInsertSound((Entity)player);
                }
            }
            return true;
        }
        return false;
    }

    public void copyColor(ItemStack patternspria, Level level, BlockPos blockPos) {
        if (BlockPatternCapability.hasPattern(blockPos, level)) {
            BlockPatternCapability.PatternData patternData = BlockPatternCapability.getPattern(blockPos, level);
            patternspria.m_41784_().m_128405_("color", patternData.color());
        }
    }

    public int getColor(ItemStack patternspria) {
        if (patternspria.m_41784_().m_128441_("color")) {
            return patternspria.m_41784_().m_128451_("color");
        }
        return 11113613;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public int m_142159_(ItemStack stack) {
        int input = PatternspriaItem.getPatternspriaUses(stack) - 1;
        int maxInput = 4;
        return ModColorHandler.barColorHelper(input, maxInput);
    }

    public boolean m_142522_(ItemStack stack) {
        return BlockPattern.fromPatternspria(stack) != BlockPattern.EMPTY;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)PatternspriaItem.getPatternspriaUses(stack) * 13.0f / 4.0f);
    }

    public static int getPatternspriaUses(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("uses")) {
            int uses = tag.m_128451_("uses");
            if (uses > 4 || uses < 0) {
                MoreSnifferFlowers.LOGGER.warn("Invalid uses lastSpeed for patternspria: " + uses);
                tag.m_128405_("uses", 4);
                return 4;
            }
            return uses;
        }
        return 4;
    }

    public static void setPatternspriaUses(ItemStack stack, int uses) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("uses") && tag.m_128451_("uses") < 0 || tag.m_128451_("uses") > 4) {
            MoreSnifferFlowers.LOGGER.warn("Invalid uses lastSpeed for patternspria: " + tag.m_128451_("uses") + "new: " + uses);
            tag.m_128405_("uses", 4);
            return;
        }
        tag.m_128405_("uses", uses);
        stack.m_41751_(tag);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        BlockPattern pattern = BlockPattern.fromPatternspria(stack);
        MutableComponent usage = Component.m_264568_((String)"tooltip.patternspria.usage", (String)"Right click with dye to insert \nRight click caulorflower to repaint \nSneak to apply to the whole column \n").m_130940_(ChatFormatting.GOLD);
        Stream<String> usageComponents = Arrays.stream(usage.getString().split("\n", -1)).filter(s -> !s.isEmpty()).map(String::trim);
        usageComponents.forEach(s -> tooltipComponents.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.GOLD)));
        tooltipComponents.add((Component)Component.m_237119_());
        tooltipComponents.add(DyespriaItem.getCurrentModeComponent(DyespriaMode.byIndex(this.getMode(stack).ordinal())));
        tooltipComponents.add((Component)Component.m_237119_());
        if (pattern != BlockPattern.EMPTY) {
            ItemStack patternStack = pattern.getItemStack(stack);
            MutableComponent name = Component.m_237113_((String)(patternStack.m_41613_() + " - " + WordUtils.capitalizeFully((String)pattern.m_7912_().toLowerCase().replaceAll("[^a-z_]", "").replaceAll("_", " ")))).m_130948_(Style.f_131099_.m_178520_(pattern.getColor()));
            tooltipComponents.add((Component)name);
        } else {
            tooltipComponents.add((Component)Component.m_264568_((String)"tooltip.dyespria.empty", (String)"Empty").m_130940_(ChatFormatting.GRAY));
        }
    }

    public void spawnParticles(RandomSource randomSource, Level level, BlockPattern pattern, BlockPos blockPos, Direction face, ItemStack stack) {
        Vector3f vector3f = blockPos.m_252807_().m_252839_();
        if (face != null) {
            vector3f = vector3f.add((Vector3fc)face.m_253071_().div((Vector3fc)new Vector3f(2.0f, 2.0f, 2.0f)));
        }
        int color = stack.m_41784_().m_128441_("color") ? stack.m_41784_().m_128451_("color") : pattern.getColor();
        for (int i = 0; i <= randomSource.m_216332_(5, 10); ++i) {
            level.m_7106_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)color).m_252839_(), 1.0f), (double)vector3f.x + randomSource.m_188500_() - 0.5, (double)vector3f.y + randomSource.m_188500_() - 0.5, (double)vector3f.z + randomSource.m_188500_() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void changeMode(ServerPlayer player, ItemStack stack, int amount) {
        PatternspriaMode currentMode = this.getMode(stack);
        PatternspriaMode newMode = PatternspriaMode.shift(currentMode, amount);
        stack.m_41784_().m_128344_("mode", (byte)newMode.ordinal());
        player.m_5661_(DyespriaItem.getCurrentModeComponent(DyespriaMode.byIndex(newMode.ordinal())), true);
    }
}

