/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3f;

public record CorruptionParticlePacket(BlockPos pos, boolean isPositive, boolean isFlower) {
    public CorruptionParticlePacket(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.readBoolean(), buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.isPositive);
        buf.writeBoolean(this.isFlower);
    }

    public static void handle(CorruptionParticlePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> CorruptionParticlePacket.handlePacket(packet));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(CorruptionParticlePacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        RandomSource random = level.f_46441_;
        BlockPos pos = packet.pos;
        boolean isPositive = packet.isPositive;
        boolean isFlower = packet.isFlower;
        BlockState state = level.m_8055_(pos);
        Vec3 vec = pos.m_252807_();
        if (isFlower) {
            Vec3 offset = state.m_60824_((BlockGetter)level, pos).m_82549_(vec);
            vec.m_82549_(offset);
            for (int i = 0; i < 10; ++i) {
                double inaccuracy = 0.7;
                double xOff = (double)(random.m_188501_() - 0.5f) * inaccuracy;
                double zOff = (double)(random.m_188501_() - 0.5f) * inaccuracy;
                double yOff = random.m_188501_() / 2.0f;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, offset.f_82479_ + xOff, offset.f_82480_ + yOff, offset.f_82481_ + zOff, 0.0, 0.2, 0.0);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                double xOff = random.m_188501_() - 0.5f;
                double zOff = random.m_188501_() - 0.5f;
                double yOff = random.m_188501_() / 3.0f + 0.5f;
                double slowDown = 3.0;
                SimpleParticleType particle = isPositive ? ParticleTypes.f_123748_ : new DustParticleOptions(new Vector3f(0.41960785f, 0.24313726f, 0.47843137f), random.m_188501_() / 2.0f + 0.5f);
                level.m_7106_((ParticleOptions)particle, vec.f_82479_ + xOff, vec.f_82480_ + yOff, vec.f_82481_ + zOff, xOff / slowDown, 0.2, zOff / slowDown);
            }
        }
    }
}

