/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.client.ClientRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SyncBlockPatternsPacket(CompoundTag tag, ChunkPos pos) {
    public static void encode(SyncBlockPatternsPacket msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.tag);
        buf.m_178341_(msg.pos);
    }

    public static SyncBlockPatternsPacket decode(FriendlyByteBuf buf) {
        return new SyncBlockPatternsPacket(buf.m_130260_(), buf.m_178383_());
    }

    public static void handle(SyncBlockPatternsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> SyncBlockPatternsPacket.handlePacket(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(SyncBlockPatternsPacket msg) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ChunkPos chunkPos = msg.pos;
        LevelChunk chunk = level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        if (chunk != null) {
            chunk.getCapability(CapabilityList.BLOCK_PATTERNS).ifPresent(blockPatternCapability -> blockPatternCapability.load(msg.tag));
            ClientRegistration.getBlockPatternRenderer().markDirty();
        }
    }
}

