/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SyncSlipperyPacket(boolean isFallen, int entityId, int fallenTicks, int maxFallenTicks) {
    public SyncSlipperyPacket(FriendlyByteBuf buf) {
        this(buf.readBoolean(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isFallen);
        buf.writeInt(this.entityId);
        buf.writeInt(this.fallenTicks);
        buf.writeInt(this.maxFallenTicks);
    }

    public static void handle(SyncSlipperyPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SyncSlipperyPacket.handlePacket(packet));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SyncSlipperyPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(packet.entityId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(CapabilityList.SLIPPERY).ifPresent(cap -> {
                cap.isFallen = packet.isFallen;
                cap.fallenTicks = packet.fallenTicks;
                cap.maxFallenTicks = packet.maxFallenTicks;
                if (!cap.isFallen) {
                    cap.getUp(player);
                }
            });
        }
    }
}

