/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.recipes.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.abraxator.moresnifferflowers.recipes.CorruptionRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CorruptionSerializer
implements RecipeSerializer<CorruptionRecipe> {
    public CorruptionRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
        String source = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"source");
        ArrayList<CorruptionRecipe.Entry> list = new ArrayList<CorruptionRecipe.Entry>();
        for (JsonElement corrupted : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"corrupted")) {
            CorruptionRecipe.Entry entry = CorruptionRecipe.Entry.fromJsonElement(corrupted);
            list.add(entry);
        }
        return new CorruptionRecipe(resourceLocation, source, list);
    }

    @Nullable
    public CorruptionRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
        ArrayList<CorruptionRecipe.Entry> list = new ArrayList<CorruptionRecipe.Entry>();
        String source = buf.m_130277_();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            CorruptionRecipe.Entry entry = new CorruptionRecipe.Entry((Block)buf.readRegistryId(), buf.readInt());
            list.add(entry);
        }
        return new CorruptionRecipe(resourceLocation, source, list);
    }

    public void toNetwork(FriendlyByteBuf buf, CorruptionRecipe recipe) {
        buf.m_130070_(recipe.source());
        buf.writeInt(recipe.list().size());
        recipe.list().forEach(entry -> {
            buf.writeRegistryId(ForgeRegistries.BLOCKS, (Object)entry.block());
            buf.writeInt(entry.weight());
        });
    }
}

