/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.vivicus;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class VivicusTrunkPlacer
extends TrunkPlacer {
    public static final Codec<VivicusTrunkPlacer> CODEC = RecordCodecBuilder.create(p_338099_ -> VivicusTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_338099_).apply((Applicative)p_338099_, VivicusTrunkPlacer::new));

    public VivicusTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.VIVICUS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> ret = new ArrayList<FoliagePlacer.FoliageAttachment>();
        LinkedHashMap blocks = new LinkedHashMap();
        int lastLogHeight = pFreeTreeHeight - (int)Mth.m_216283_((RandomSource)random, (float)2.0f, (float)3.0f);
        BlockPos.MutableBlockPos mainTrunk = pos.m_122032_();
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            this.m_226187_(level, blockSetter, random, (BlockPos)mainTrunk, config);
            if (i == 0) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    int j;
                    int outerHeight = random.m_188503_(3);
                    int cornerHeight = outerHeight + (random.m_188503_(2) - 1);
                    int innerHeight = Math.min(outerHeight + random.m_216332_(5, 7), pFreeTreeHeight - 1);
                    if (!(random.m_188500_() <= 0.9)) continue;
                    BlockPos blockPosInner = pos.m_121945_(direction);
                    for (int j2 = 0; j2 < innerHeight; ++j2) {
                        this.m_226187_(level, blockSetter, random, blockPosInner.m_6630_(j2), config);
                    }
                    if (random.m_188500_() <= 0.8) {
                        ret.add(new FoliagePlacer.FoliageAttachment(blockPosInner.m_6630_(innerHeight), 4, false));
                    }
                    if (random.m_188500_() <= 0.9) {
                        BlockPos blockPosCorner = blockPosInner.m_121945_(random.m_188500_() > 0.5 ? direction.m_122427_() : direction.m_122428_());
                        for (j = 0; j < cornerHeight; ++j) {
                            this.m_226187_(level, blockSetter, random, blockPosCorner.m_6630_(j), config);
                        }
                    }
                    if (!(random.m_188500_() <= 0.9)) continue;
                    BlockPos blockPosOuter = blockPosInner.m_121945_(direction);
                    for (j = 0; j < outerHeight; ++j) {
                        this.m_226187_(level, blockSetter, random, blockPosOuter.m_6630_(j), config);
                    }
                }
            }
            mainTrunk.m_122173_(Direction.UP);
        }
        ret.add(new FoliagePlacer.FoliageAttachment(mainTrunk.m_6625_(1), 0, false));
        return ret;
    }

    private void placeStump(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos stumpPos, TreeConfiguration config) {
        if (random.m_188500_() <= 0.3) {
            for (int height = 0; height < random.m_188503_(3); ++height) {
                this.m_226187_(level, blockSetter, random, stumpPos.m_7949_().m_6630_(height), config);
            }
        }
    }

    protected boolean m_213554_(LevelSimulatedReader level, BlockPos pos) {
        return super.m_213554_(level, pos) || level.m_7433_(pos, blockState -> blockState.m_204336_(ModTags.ModBlockTags.VIVICUS_TREE_REPLACABLE));
    }
}

