/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.vivicus;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class VivicusTrunkPlacerUnused
extends TrunkPlacer {
    public static final MapCodec<VivicusTrunkPlacerUnused> CODEC = RecordCodecBuilder.mapCodec(p_259008_ -> VivicusTrunkPlacerUnused.m_70305_((RecordCodecBuilder.Instance)p_259008_).and(p_259008_.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(p_226242_ -> p_226242_.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(p_226240_ -> Float.valueOf(p_226240_.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(p_226238_ -> p_226238_.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(p_226234_ -> p_226234_.canGrowThrough))).apply((Applicative)p_259008_, VivicusTrunkPlacerUnused::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;
    private final IntProvider stumpChance;

    public VivicusTrunkPlacerUnused(int pBaseHeight, int pHeightRandA, int pHeightRandB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
        this.stumpChance = new WeightedListInt(new SimpleWeightedRandomList.Builder().m_146271_((Object)ConstantInt.m_146483_((int)0), 3).m_146271_((Object)ConstantInt.m_146483_((int)1), 5).m_146271_((Object)ConstantInt.m_146483_((int)2), 7).m_146271_((Object)ConstantInt.m_146483_((int)3), 8).m_146271_((Object)ConstantInt.m_146483_((int)4), 4).m_146270_());
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ArrayList directions = new ArrayList(Direction.Plane.HORIZONTAL.m_122557_().toList());
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            int j = pos.m_123342_() + i;
            if (i == 0) {
                int intchance = this.stumpChance.m_214085_(random);
                for (int stump = 0; stump < intchance; ++stump) {
                    Collections.shuffle(directions);
                    Direction stumpDir = (Direction)directions.get(0);
                    this.m_226187_(level, blockSetter, random, pos.m_121945_(stumpDir), config);
                    directions.remove(0);
                }
            }
            if (this.m_226187_(level, blockSetter, random, (BlockPos)blockpos$mutableblockpos.m_122178_(pos.m_123341_(), j, pos.m_123343_()), config) && i < pFreeTreeHeight - 1 && random.m_188501_() < this.placeBranchPerLogProbability) {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
                int k = this.extraBranchLength.m_214085_(random);
                int l = Math.max(0, k - this.extraBranchLength.m_214085_(random) - 1);
                int i1 = this.extraBranchSteps.m_214085_(random);
                this.placeBranch(level, blockSetter, random, pFreeTreeHeight, config, list, blockpos$mutableblockpos, j, direction, l, i1);
            }
            if (i != pFreeTreeHeight - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)blockpos$mutableblockpos.m_122178_(pos.m_123341_(), j + 1, pos.m_123343_()), 0, false));
        }
        return list;
    }

    private void placeBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, TreeConfiguration pTreeConfig, List<FoliagePlacer.FoliageAttachment> pFoliageAttachments, BlockPos.MutableBlockPos pos, int y, Direction pDirection, int pExtraBranchLength, int pExtraBranchSteps) {
        int i = y + pExtraBranchLength;
        int j = pos.m_123341_();
        int k = pos.m_123343_();
        for (int l = pExtraBranchLength; l < pFreeTreeHeight && pExtraBranchSteps > 0; ++l, --pExtraBranchSteps) {
            if (l < 1) continue;
            int i1 = y + l;
            i = i1;
            if (this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122178_(j += pDirection.m_122429_(), i1, k += pDirection.m_122431_()), pTreeConfig)) {
                i = i1 + 1;
            }
            pFoliageAttachments.add(new FoliagePlacer.FoliageAttachment(pos.m_7949_(), 0, false));
        }
        if (i - y > 1) {
            BlockPos blockpos = new BlockPos(j, i, k);
            pFoliageAttachments.add(new FoliagePlacer.FoliageAttachment(blockpos, 0, false));
            pFoliageAttachments.add(new FoliagePlacer.FoliageAttachment(blockpos.m_6625_(2), 0, false));
        }
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.VIVICUS_TRUNK_PLACER.get();
    }

    protected boolean m_213554_(LevelSimulatedReader level, BlockPos pos) {
        return super.m_213554_(level, pos) || level.m_7433_(pos, p_226232_ -> p_226232_.m_204341_(this.canGrowThrough));
    }
}

