/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class AmplifierStoneEvents {
    private static final double RADIUS = 24.0;
    private static final float DAMAGE = 2.0f;
    private static final int BURST_LIFETIME_TICKS = 4;
    private static final double R_START = 0.8;
    private static final double R_SPEED = 1.2;
    private static final int RING_POINTS = 32;
    private static final double JITTER_XZ = 0.05;
    private static final double JITTER_Y = 0.02;
    private static final double BASE_Y_OFFSET = 0.1;
    private static final Map<ServerLevel, List<SmokeBurst>> BURSTS = new WeakHashMap<ServerLevel, List<SmokeBurst>>();

    private static void addBurst(ServerLevel sl, double x, double y, double z) {
        BURSTS.computeIfAbsent(sl, k -> new ArrayList()).add(new SmokeBurst(x, y + 0.1, z, 4));
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem e) {
        Level level = e.getLevel();
        if (level.f_46443_) {
            return;
        }
        Player p = e.getEntity();
        ItemStack used = e.getItemStack();
        if (!(used.m_41720_() instanceof InstrumentItem)) {
            return;
        }
        boolean equipped = CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.AMPLIFIER_STONE.get())).isEmpty()).orElse(false);
        if (!equipped) {
            return;
        }
        if (p.m_36335_().m_41519_(used.m_41720_())) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        sl.m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        AmplifierStoneEvents.addBurst(sl, p.m_20185_(), p.m_20186_(), p.m_20189_());
        AABB area = p.m_20191_().m_82400_(24.0);
        List mobs = sl.m_6443_(LivingEntity.class, area, m -> m.m_6084_() && !m.m_20147_() && m != p);
        for (LivingEntity m2 : mobs) {
            m2.m_6469_(sl.m_269111_().m_269075_(p), 2.0f);
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.level.f_46443_) {
            return;
        }
        ServerLevel sl = (ServerLevel)e.level;
        List<SmokeBurst> list = BURSTS.get(sl);
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<SmokeBurst> it = list.iterator();
        while (it.hasNext()) {
            SmokeBurst b = it.next();
            double r = 0.8 + 1.2 * (double)b.age;
            for (int i = 0; i < 32; ++i) {
                double a = Math.PI * 2 * (double)i / 32.0;
                double px = b.x + Math.cos(a) * r;
                double pz = b.z + Math.sin(a) * r;
                sl.m_8767_((ParticleOptions)ParticleTypes.f_123796_, px, b.y, pz, 1, 0.05, 0.02, 0.05, 0.0);
            }
            ++b.age;
            if (b.age < b.life) continue;
            it.remove();
        }
    }

    private static class SmokeBurst {
        final double x;
        final double y;
        final double z;
        final int life;
        int age = 0;

        SmokeBurst(double x, double y, double z, int life) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.life = life;
        }
    }
}

