/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.NuclearReactorScreenBlock;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.menu.NuclearReactorScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class NuclearReactorScreenBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final String REQUIRED_CODE = "684-253-958";
    private static final int TICKS_PER_DAY = 24000;
    private static final int WARNING_TIME = 1200;
    private long lastCodeEntryTime = -1L;
    private boolean alarmActive = false;
    private int alarmCountdown = 0;
    private boolean reactorShutdown = false;

    public NuclearReactorScreenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NUCLEAR_REACTOR_SCREEN.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NuclearReactorScreenBlockEntity entity) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity.tick(serverLevel, pos, state);
        }
    }

    private void tick(ServerLevel level, BlockPos pos, BlockState state) {
        long currentTime = level.m_46467_();
        if (currentTime % 24000L < 100L && this.shouldRequireCode(currentTime) && !this.alarmActive && !this.reactorShutdown) {
            this.startAlarm(level, pos, state);
        }
        if (this.alarmActive) {
            --this.alarmCountdown;
            if (this.alarmCountdown % 20 == 0) {
                level.m_5594_(null, pos, SoundEvents.f_11699_, SoundSource.BLOCKS, 3.0f, 0.5f);
                level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12167_.m_203334_(), SoundSource.BLOCKS, 2.0f, 0.3f);
                int secondsLeft = this.alarmCountdown / 20;
                level.m_6907_().forEach(player -> {
                    if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 65536.0) {
                        player.m_5661_((Component)Component.m_237113_((String)("\u26a0 REACTOR SAFETY: Enter code in " + secondsLeft + " seconds! \u26a0")).m_130938_(style -> style.m_178520_(0xFF0000).m_131136_(Boolean.valueOf(true))), true);
                    }
                });
            }
            if (this.alarmCountdown <= 0) {
                this.shutdownReactor(level, pos, state);
            }
        }
        this.m_6596_();
    }

    private boolean shouldRequireCode(long currentTime) {
        if (this.lastCodeEntryTime < 0L) {
            return true;
        }
        long timeSinceLastEntry = currentTime - this.lastCodeEntryTime;
        return timeSinceLastEntry >= 24000L;
    }

    private void startAlarm(ServerLevel level, BlockPos pos, BlockState state) {
        this.alarmActive = true;
        this.alarmCountdown = 1200;
        level.m_5594_(null, pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 2.0f, 1.5f);
        this.setScreenState(level, pos, state, NuclearReactorScreenBlock.ScreenState.DANGER);
    }

    private void shutdownReactor(ServerLevel level, BlockPos pos, BlockState state) {
        this.reactorShutdown = true;
        this.alarmActive = false;
        this.setScreenState(level, pos, state, NuclearReactorScreenBlock.ScreenState.DANGER);
        level.m_5594_(null, pos, SoundEvents.f_11738_, SoundSource.BLOCKS, 3.0f, 0.5f);
        this.deactivateNearbyReactor(level, pos);
        level.m_6907_().forEach(player -> {
            if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 65536.0) {
                player.m_5661_((Component)Component.m_237113_((String)"\u26a0 REACTOR EMERGENCY SHUTDOWN - SAFETY CODE NOT ENTERED \u26a0").m_130938_(style -> style.m_178520_(0xFF0000).m_131136_(Boolean.valueOf(true))), false);
            }
        });
    }

    public boolean validateCode(String enteredCode) {
        return REQUIRED_CODE.equals(enteredCode);
    }

    public void onCorrectCodeEntered(ServerLevel level, BlockPos pos, BlockState state) {
        this.lastCodeEntryTime = level.m_46467_();
        this.alarmActive = false;
        this.alarmCountdown = 0;
        this.reactorShutdown = false;
        if (this.isReactorActive(level, pos)) {
            this.setScreenState(level, pos, state, NuclearReactorScreenBlock.ScreenState.ON);
        }
        level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.m_6596_();
    }

    private void setScreenState(ServerLevel level, BlockPos pos, BlockState state, NuclearReactorScreenBlock.ScreenState screenState) {
        if (state.m_61138_(NuclearReactorScreenBlock.STATE)) {
            level.m_7731_(pos, (BlockState)state.m_61124_(NuclearReactorScreenBlock.STATE, (Comparable)((Object)screenState)), 3);
        }
    }

    private void deactivateNearbyReactor(ServerLevel level, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 0, 1))) {
            BlockState checkState = level.m_8055_(checkPos);
            Block block = checkState.m_60734_();
            if (!(block instanceof NuclearControllerBlock)) continue;
            NuclearControllerBlock controllerBlock = (NuclearControllerBlock)block;
            controllerBlock.checkAndFormMultiblock((Level)level, checkPos, checkState);
            break;
        }
    }

    private boolean isReactorActive(ServerLevel level, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 0, 1))) {
            BlockState checkState = level.m_8055_(checkPos);
            if (!(checkState.m_60734_() instanceof NuclearControllerBlock)) continue;
            return (Boolean)checkState.m_61143_((Property)NuclearControllerBlock.ACTIVE);
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lastCodeEntryTime = tag.m_128454_("LastCodeEntry");
        this.alarmActive = tag.m_128471_("AlarmActive");
        this.alarmCountdown = tag.m_128451_("AlarmCountdown");
        this.reactorShutdown = tag.m_128471_("ReactorShutdown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("LastCodeEntry", this.lastCodeEntryTime);
        tag.m_128379_("AlarmActive", this.alarmActive);
        tag.m_128405_("AlarmCountdown", this.alarmCountdown);
        tag.m_128379_("ReactorShutdown", this.reactorShutdown);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.modern_missions.nuclear_reactor_screen");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new NuclearReactorScreenMenu(windowId, playerInventory, this);
    }

    public String getRequiredCode() {
        return REQUIRED_CODE;
    }

    public boolean isAlarmActive() {
        return this.alarmActive;
    }

    public int getAlarmCountdown() {
        return this.alarmCountdown;
    }

    public long getLastCodeEntryTime() {
        return this.lastCodeEntryTime;
    }

    public boolean isReactorShutdown() {
        return this.reactorShutdown;
    }
}

