/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.PoweredFurnaceBlock;
import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.menu.PoweredFurnaceMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoweredFurnaceBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int INPUT_SLOT = 0;
    private static final int FUEL_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int ENERGY_CAPACITY = 10000;
    private static final int MAX_PROGRESS = 67;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            PoweredFurnaceBlockEntity.this.m_6596_();
            if (!((PoweredFurnaceBlockEntity)PoweredFurnaceBlockEntity.this).f_58857_.f_46443_) {
                PoweredFurnaceBlockEntity.this.f_58857_.m_7260_(PoweredFurnaceBlockEntity.this.m_58899_(), PoweredFurnaceBlockEntity.this.m_58900_(), PoweredFurnaceBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> PoweredFurnaceBlockEntity.this.canSmelt(stack);
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> PoweredFurnaceBlockEntity.this.progress;
                case 1 -> PoweredFurnaceBlockEntity.this.maxProgress;
                case 2 -> {
                    if (PoweredFurnaceBlockEntity.this.isPoweredByReactor) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> 0;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    PoweredFurnaceBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    PoweredFurnaceBlockEntity.this.maxProgress = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private int progress = 0;
    private int maxProgress = 67;
    private BlockPos linkedReactorPos = null;
    private boolean isPoweredByReactor = false;

    public PoweredFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.POWERED_FURNACE.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.modern_missions.powered_furnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new PoweredFurnaceMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("powered_furnace.progress", this.progress);
        if (this.linkedReactorPos != null) {
            nbt.m_128405_("ReactorX", this.linkedReactorPos.m_123341_());
            nbt.m_128405_("ReactorY", this.linkedReactorPos.m_123342_());
            nbt.m_128405_("ReactorZ", this.linkedReactorPos.m_123343_());
        }
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("powered_furnace.progress");
        if (nbt.m_128441_("ReactorX") && nbt.m_128441_("ReactorY") && nbt.m_128441_("ReactorZ")) {
            this.linkedReactorPos = new BlockPos(nbt.m_128451_("ReactorX"), nbt.m_128451_("ReactorY"), nbt.m_128451_("ReactorZ"));
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PoweredFurnaceBlockEntity entity) {
        entity.updateReactorLink(level);
        boolean isProcessing = false;
        if (entity.hasRecipe() && entity.isPoweredByReactor) {
            ++entity.progress;
            isProcessing = true;
            entity.m_6596_();
            if (entity.progress >= entity.maxProgress) {
                entity.craftItem();
                entity.resetProgress();
            }
        } else {
            entity.resetProgress();
        }
        if ((Boolean)state.m_61143_((Property)PoweredFurnaceBlock.LIT) != isProcessing) {
            state = (BlockState)state.m_61124_((Property)PoweredFurnaceBlock.LIT, (Comparable)Boolean.valueOf(isProcessing));
            level.m_7731_(pos, state, 3);
            PoweredFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack result = this.getSmeltingResult(input);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        if (!result.m_41619_()) {
            if (output.m_41619_()) {
                this.itemHandler.setStackInSlot(2, result.m_41777_());
            } else if (output.m_150930_(result.m_41720_())) {
                output.m_41769_(result.m_41613_());
            }
            input.m_41774_(1);
        }
    }

    private boolean hasRecipe() {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack result = this.getSmeltingResult(input);
        if (result.m_41619_()) {
            return false;
        }
        ItemStack output = this.itemHandler.getStackInSlot(2);
        return output.m_41619_() || output.m_150930_(result.m_41720_()) && output.m_41613_() + result.m_41613_() <= output.m_41741_();
    }

    private ItemStack getSmeltingResult(ItemStack input) {
        if (input.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_);
        return recipe.map(smeltingRecipe -> smeltingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_()).orElse(ItemStack.f_41583_);
    }

    private boolean canSmelt(ItemStack stack) {
        return !this.getSmeltingResult(stack).m_41619_();
    }

    public int getEnergyStored() {
        return this.isPoweredByReactor ? 10000 : 0;
    }

    public int getMaxEnergy() {
        return 10000;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void linkToReactor(BlockPos reactorPos) {
        this.linkedReactorPos = reactorPos;
        this.m_6596_();
    }

    public void unlinkReactor() {
        this.linkedReactorPos = null;
        this.isPoweredByReactor = false;
        this.m_6596_();
    }

    private void updateReactorLink(Level level) {
        if (this.linkedReactorPos == null) {
            this.isPoweredByReactor = false;
            return;
        }
        double distance = this.f_58858_.m_123331_((Vec3i)this.linkedReactorPos);
        if (distance > 10000.0) {
            this.unlinkReactor();
            return;
        }
        BlockEntity blockEntity = level.m_7702_(this.linkedReactorPos);
        if (blockEntity instanceof NuclearControllerBlockEntity) {
            BlockState reactorState = level.m_8055_(this.linkedReactorPos);
            this.isPoweredByReactor = reactorState.m_61138_((Property)NuclearControllerBlock.ACTIVE) ? (Boolean)reactorState.m_61143_((Property)NuclearControllerBlock.ACTIVE) : false;
        } else {
            this.unlinkReactor();
        }
    }

    public boolean isPoweredByReactor() {
        return this.isPoweredByReactor;
    }

    public BlockPos getLinkedReactorPos() {
        return this.linkedReactorPos;
    }
}

