/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModItems;
import com.modernmissions.menu.ReactorFuelPortMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorFuelPortBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            ReactorFuelPortBlockEntity.this.m_6596_();
            if (!((ReactorFuelPortBlockEntity)ReactorFuelPortBlockEntity.this).f_58857_.f_46443_) {
                ReactorFuelPortBlockEntity.this.f_58857_.m_7260_(ReactorFuelPortBlockEntity.this.m_58899_(), ReactorFuelPortBlockEntity.this.m_58900_(), ReactorFuelPortBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_150930_((Item)ModItems.URANIUM_FUEL_CELL.get());
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private int burnTime = 0;

    public ReactorFuelPortBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REACTOR_FUEL_PORT.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.modern_missions.reactor_fuel_port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ReactorFuelPortMenu(id, inventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("BurnTime", this.burnTime);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.burnTime = nbt.m_128451_("BurnTime");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ReactorFuelPortBlockEntity entity) {
        boolean changed = false;
        if (entity.burnTime > 0) {
            --entity.burnTime;
            changed = true;
        }
        if (entity.burnTime == 0) {
            for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
                ItemStack stack = entity.itemHandler.getStackInSlot(i);
                if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.URANIUM_FUEL_CELL.get())) continue;
                stack.m_41774_(1);
                entity.burnTime = (Integer)CommonConfig.REACTOR_FUEL_CONSUMPTION_RATE.get();
                changed = true;
                break;
            }
        }
        if (changed) {
            ReactorFuelPortBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getMaxBurnTime() {
        return (Integer)CommonConfig.REACTOR_FUEL_CONSUMPTION_RATE.get();
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

