/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.block.RefineryBlock;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModItems;
import com.modernmissions.menu.RefineryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefineryBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            RefineryBlockEntity.this.m_6596_();
            if (!((RefineryBlockEntity)RefineryBlockEntity.this).f_58857_.f_46443_) {
                RefineryBlockEntity.this.f_58857_.m_7260_(RefineryBlockEntity.this.m_58899_(), RefineryBlockEntity.this.m_58900_(), RefineryBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> RefineryBlockEntity.this.isValidInput(stack);
                case 1 -> {
                    if (stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_ || stack.m_41720_() == Items.f_42200_ || stack.m_41720_() == Items.f_42448_) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RefineryBlockEntity.this.progress;
                case 1 -> RefineryBlockEntity.this.maxProgress;
                case 2 -> RefineryBlockEntity.this.fuelTime;
                case 3 -> RefineryBlockEntity.this.maxFuelTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RefineryBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RefineryBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    RefineryBlockEntity.this.fuelTime = value;
                    break;
                }
                case 3: {
                    RefineryBlockEntity.this.maxFuelTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private int progress = 0;
    private int maxProgress = 200;
    private int fuelTime = 0;
    private int maxFuelTime = 0;

    public RefineryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REFINERY.get(), pos, state);
    }

    private boolean isValidInput(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.OIL_BUCKET.get()) || stack.m_150930_((Item)ModItems.RAW_URANIUM.get()) || stack.m_150930_(Items.f_42416_) || stack.m_150930_(Items.f_41913_);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.modern_missions.refinery");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new RefineryMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("refinery.progress", this.progress);
        nbt.m_128405_("refinery.fuelTime", this.fuelTime);
        nbt.m_128405_("refinery.maxFuelTime", this.maxFuelTime);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("refinery.progress");
        this.fuelTime = nbt.m_128451_("refinery.fuelTime");
        this.maxFuelTime = nbt.m_128451_("refinery.maxFuelTime");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RefineryBlockEntity entity) {
        boolean isLit;
        boolean wasLit = (Boolean)state.m_61143_((Property)RefineryBlock.LIT);
        boolean changed = false;
        if (entity.fuelTime > 0) {
            --entity.fuelTime;
            changed = true;
        }
        ItemStack inputStack = entity.itemHandler.getStackInSlot(0);
        ItemStack fuelStack = entity.itemHandler.getStackInSlot(1);
        if (!inputStack.m_41619_() && entity.hasRecipe()) {
            if (entity.fuelTime == 0 && !fuelStack.m_41619_()) {
                entity.maxFuelTime = entity.getFuelTime(fuelStack);
                if (entity.maxFuelTime > 0) {
                    entity.fuelTime = entity.maxFuelTime;
                    if (fuelStack.m_41720_() == Items.f_42448_) {
                        entity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)Items.f_42446_));
                    } else {
                        fuelStack.m_41774_(1);
                    }
                    changed = true;
                }
            }
            if (entity.fuelTime > 0 && entity.canCraft()) {
                ++entity.progress;
                if (entity.progress >= entity.maxProgress) {
                    entity.craftItem();
                    entity.progress = 0;
                }
                changed = true;
            } else if (entity.progress > 0) {
                entity.progress = Math.max(entity.progress - 2, 0);
                changed = true;
            }
        } else if (entity.progress > 0) {
            entity.progress = 0;
            changed = true;
        }
        boolean bl = isLit = entity.fuelTime > 0;
        if (wasLit != isLit) {
            state = (BlockState)state.m_61124_((Property)RefineryBlock.LIT, (Comparable)Boolean.valueOf(isLit));
            level.m_7731_(pos, state, 3);
            changed = true;
        }
        if (changed) {
            RefineryBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private int getFuelTime(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42413_) {
            return 1600;
        }
        if (stack.m_41720_() == Items.f_42414_) {
            return 1600;
        }
        if (stack.m_41720_() == Items.f_42200_) {
            return 16000;
        }
        if (stack.m_41720_() == Items.f_42448_) {
            return 20000;
        }
        return 0;
    }

    private boolean hasRecipe() {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        return !input.m_41619_() && this.isValidInput(input);
    }

    private boolean canCraft() {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        ItemStack result = this.getResultFor(input);
        if (result.m_41619_()) {
            return false;
        }
        if (output.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)output, (ItemStack)result)) {
            return false;
        }
        return output.m_41613_() + result.m_41613_() <= output.m_41741_();
    }

    private void craftItem() {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        ItemStack result = this.getResultFor(input);
        if (!result.m_41619_()) {
            if (output.m_41619_()) {
                this.itemHandler.setStackInSlot(2, result.m_41777_());
            } else if (ItemStack.m_150942_((ItemStack)output, (ItemStack)result)) {
                output.m_41769_(result.m_41613_());
            }
            input.m_41774_(1);
        }
    }

    private ItemStack getResultFor(ItemStack input) {
        if (input.m_41720_() == ModItems.OIL_BUCKET.get()) {
            return new ItemStack((ItemLike)ModItems.REFINED_OIL_BUCKET.get());
        }
        if (input.m_41720_() == ModItems.RAW_URANIUM.get()) {
            return new ItemStack((ItemLike)ModItems.REFINED_URANIUM.get());
        }
        if (input.m_41720_() == Items.f_42416_) {
            return new ItemStack((ItemLike)ModItems.STEEL_INGOT.get());
        }
        if (input.m_41720_() == Items.f_41913_) {
            return new ItemStack((ItemLike)ModItems.REFINED_STEEL_BLOCK.get());
        }
        return ItemStack.f_41583_;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

