/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.event;

import com.modernmissions.client.orbital.MinimapTileCache;
import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="modern_missions", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class SatelliteMapUpdateHandler {
    private static MinimapTileCache tileCache;
    private static int tickCounter;
    private static int primeCounter;
    private static int lastPlayerChunkX;
    private static int lastPlayerChunkZ;
    private static boolean hasInitialPrimed;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)CommonConfig.ENABLE_BACKGROUND_MAP_GENERATION.get()).booleanValue()) {
            if (tileCache != null) {
                tileCache = null;
                hasInitialPrimed = false;
            }
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        boolean hasTransmitter = false;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != ModItems.SATELLITE_TRANSMITTER.get()) continue;
            hasTransmitter = true;
            break;
        }
        if (!hasTransmitter) {
            if (tileCache != null) {
                tileCache = null;
            }
            return;
        }
        if (tileCache == null) {
            tileCache = new MinimapTileCache(mc);
            hasInitialPrimed = false;
            primeCounter = 0;
        }
        int currentChunkX = player.m_146903_() >> 4;
        int currentChunkZ = player.m_146907_() >> 4;
        boolean chunkChanged = currentChunkX != lastPlayerChunkX || currentChunkZ != lastPlayerChunkZ;
        ++primeCounter;
        int updateInterval = (Integer)CommonConfig.MAP_UPDATE_INTERVAL.get();
        int primeInterval = updateInterval * 4;
        if (++tickCounter >= updateInterval) {
            tickCounter = 0;
            if (chunkChanged) {
                lastPlayerChunkX = currentChunkX;
                lastPlayerChunkZ = currentChunkZ;
                int invalidateRadius = (Integer)CommonConfig.MAP_INVALIDATE_RADIUS.get();
                if (invalidateRadius < 1) {
                    invalidateRadius = 1;
                }
                tileCache.invalidateFogTilesAround(currentChunkX, currentChunkZ, invalidateRadius);
            }
            tileCache.tick();
        }
        if (!hasInitialPrimed || primeCounter >= primeInterval && chunkChanged) {
            primeCounter = 0;
            hasInitialPrimed = true;
            tileCache.prime(currentChunkX, currentChunkZ);
        }
    }

    static {
        tickCounter = 0;
        primeCounter = 0;
        lastPlayerChunkX = Integer.MIN_VALUE;
        lastPlayerChunkZ = Integer.MIN_VALUE;
        hasInitialPrimed = false;
    }
}

