/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.overlay;

import com.modernmissions.item.NuclearTimerRemoteItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class NuclearTimerOverlay {
    private static final ResourceLocation TIMER_BACKGROUND = new ResourceLocation("modern_missions", "textures/gui/timer_overlay.png");
    private static int lastAlertSound = 0;
    private static boolean wasInAlert = false;

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        boolean shouldAlert;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack timerRemote = NuclearTimerOverlay.findTimerRemote((Player)player);
        if (timerRemote.m_41619_()) {
            return;
        }
        int timeRemaining = NuclearTimerRemoteItem.getTimeUntilCode(player.m_9236_(), timerRemote);
        if (timeRemaining < 0) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int x = screenWidth - 120;
        int y = 10;
        graphics.m_280509_(x - 2, y - 2, x + 102, y + 22, -1442840576);
        graphics.m_280509_(x, y, x + 100, y + 20, -13421773);
        int seconds = timeRemaining / 20;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        minutes %= 60;
        seconds %= 60;
        int color = 65280;
        boolean bl = shouldAlert = timeRemaining <= 1200;
        if (shouldAlert) {
            color = 0xFF0000;
            if (mc.f_91073_.m_46467_() / 10L % 2L == 0L) {
                color = 0xFFFF00;
            }
            if (!wasInAlert) {
                player.m_5496_((SoundEvent)SoundEvents.f_12210_.m_203334_(), 1.0f, 1.0f);
                wasInAlert = true;
                lastAlertSound = 0;
            } else if (lastAlertSound++ >= 20) {
                player.m_5496_((SoundEvent)SoundEvents.f_12210_.m_203334_(), 0.5f, 1.5f);
                lastAlertSound = 0;
            }
        } else {
            wasInAlert = false;
            if (timeRemaining <= 2400) {
                color = 0xFFAA00;
            } else if (timeRemaining <= 6000) {
                color = 0xFFFF00;
            }
        }
        String timeText = hours > 0 ? String.format("%d:%02d:%02d", hours, minutes, seconds) : String.format("%d:%02d", minutes, seconds);
        graphics.m_280056_(mc.f_91062_, "REACTOR TIMER", x + 5, y + 2, 0xFFFFFF, false);
        graphics.m_280137_(mc.f_91062_, timeText, x + 50, y + 11, color);
        if (shouldAlert) {
            MutableComponent warning = Component.m_237113_((String)"\u26a0 ENTER CODE NOW! \u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            graphics.m_280653_(mc.f_91062_, (Component)warning, screenWidth / 2, y + 25, -65536);
        }
    }

    private static ItemStack findTimerRemote(Player player) {
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof NuclearTimerRemoteItem) {
            return mainHand;
        }
        ItemStack offHand = player.m_21206_();
        if (offHand.m_41720_() instanceof NuclearTimerRemoteItem) {
            return offHand;
        }
        return ItemStack.f_41583_;
    }
}

