/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.renderer;

import com.modernmissions.block.HighlyExplosiveTntBlock;
import com.modernmissions.block.entity.HighlyExplosiveTntBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class HighlyExplosiveTntBlockRenderer
implements BlockEntityRenderer<HighlyExplosiveTntBlockEntity> {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("modern_missions", "block/highly_explosive_tnt_front_facing_overlay");
    private final BlockRenderDispatcher blockRenderer;

    public HighlyExplosiveTntBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(HighlyExplosiveTntBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)HighlyExplosiveTntBlock.FACING);
        poseStack.m_85836_();
        this.blockRenderer.m_110912_(state, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(OVERLAY_TEXTURE);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110463_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float offset = 0.001f;
        switch (facing) {
            case NORTH: {
                this.renderOverlayNorth(matrix, consumer, sprite, packedLight, offset);
                break;
            }
            case SOUTH: {
                this.renderOverlaySouth(matrix, consumer, sprite, packedLight, offset);
                break;
            }
            case EAST: {
                this.renderOverlayEast(matrix, consumer, sprite, packedLight, offset);
                break;
            }
            case WEST: {
                this.renderOverlayWest(matrix, consumer, sprite, packedLight, offset);
            }
        }
        poseStack.m_85849_();
    }

    private void renderOverlayNorth(Matrix4f matrix, VertexConsumer consumer, TextureAtlasSprite sprite, int packedLight, float offset) {
        float z = 0.0f - offset;
        consumer.m_252986_(matrix, 0.0f, 0.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
    }

    private void renderOverlaySouth(Matrix4f matrix, VertexConsumer consumer, TextureAtlasSprite sprite, int packedLight, float offset) {
        float z = 1.0f + offset;
        consumer.m_252986_(matrix, 0.0f, 0.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, z).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void renderOverlayEast(Matrix4f matrix, VertexConsumer consumer, TextureAtlasSprite sprite, int packedLight, float offset) {
        float x = 1.0f + offset;
        consumer.m_252986_(matrix, x, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x, 1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x, 0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private void renderOverlayWest(Matrix4f matrix, VertexConsumer consumer, TextureAtlasSprite sprite, int packedLight, float offset) {
        float x = 0.0f - offset;
        consumer.m_252986_(matrix, x, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x, 0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x, 1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
    }
}

