/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.renderer;

import com.modernmissions.block.entity.LaunchPadBlockEntity;
import com.modernmissions.client.model.ChemicalGasBombModel;
import com.modernmissions.client.model.LaunchPadBlockModel;
import com.modernmissions.client.model.NuclearMissileModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class LaunchPadBlockRenderer
extends GeoBlockRenderer<LaunchPadBlockEntity> {
    private final NuclearMissileModel<LaunchPadBlockEntity> missileModel = new NuclearMissileModel();
    private final ChemicalGasBombModel<LaunchPadBlockEntity> chemicalBombModel = new ChemicalGasBombModel();

    public LaunchPadBlockRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new LaunchPadBlockModel());
    }

    public void actuallyRender(PoseStack poseStack, LaunchPadBlockEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable != null && animatable.hasMissile()) {
            poseStack.m_85836_();
            poseStack.m_85837_(-0.5, 0.125, -0.5);
            boolean isChemical = "chemical".equals(animatable.getMissileType());
            if (isChemical) {
                BakedGeoModel bombGeoModel = this.chemicalBombModel.getBakedModel(this.chemicalBombModel.getModelResource(animatable));
                RenderType bombRenderType = RenderType.m_110458_((ResourceLocation)this.chemicalBombModel.getTextureResource(animatable));
                VertexConsumer bombBuffer = bufferSource.m_6299_(bombRenderType);
                super.actuallyRender(poseStack, (BlockEntity)animatable, bombGeoModel, bombRenderType, bufferSource, bombBuffer, false, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                BakedGeoModel missileGeoModel = this.missileModel.getBakedModel(this.missileModel.getModelResource(animatable));
                RenderType missileRenderType = RenderType.m_110458_((ResourceLocation)this.missileModel.getTextureResource(animatable));
                VertexConsumer missileBuffer = bufferSource.m_6299_(missileRenderType);
                super.actuallyRender(poseStack, (BlockEntity)animatable, missileGeoModel, missileRenderType, bufferSource, missileBuffer, false, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            poseStack.m_85849_();
        }
    }
}

