/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.screen;

import com.modernmissions.menu.LaunchControllerMenu;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.C2SMissileControlPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class LaunchControllerScreen
extends AbstractContainerScreen<LaunchControllerMenu> {
    private static final ResourceLocation NUMBERS_TEXTURE = new ResourceLocation("modern_missions", "textures/block/launch_controller_numbers.png");
    private EditBox xCoordField;
    private EditBox zCoordField;
    private EditBox launchCodeField;
    private Button launchButton;
    private Button[] keypadButtons = new Button[12];
    private String statusText = "SYSTEM READY";
    private int statusColor = 65280;
    private long lastStatusUpdate = 0L;

    public LaunchControllerScreen(LaunchControllerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 200;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.xCoordField = new EditBox(this.f_96547_, x + 90, y + 40, 50, 12, (Component)Component.m_237113_((String)"X"));
        this.xCoordField.m_94199_(6);
        this.xCoordField.m_94144_(String.valueOf(((LaunchControllerMenu)this.f_97732_).getTargetX()));
        this.xCoordField.m_94202_(65280);
        this.m_142416_((GuiEventListener)this.xCoordField);
        this.zCoordField = new EditBox(this.f_96547_, x + 155, y + 40, 50, 12, (Component)Component.m_237113_((String)"Z"));
        this.zCoordField.m_94199_(6);
        this.zCoordField.m_94144_(String.valueOf(((LaunchControllerMenu)this.f_97732_).getTargetZ()));
        this.zCoordField.m_94202_(65280);
        this.m_142416_((GuiEventListener)this.zCoordField);
        this.launchCodeField = new EditBox(this.f_96547_, x + 90, y + 60, 110, 12, (Component)Component.m_237113_((String)"Code")){

            public boolean m_5534_(char character, int modifiers) {
                if (Character.isDigit(character)) {
                    return super.m_5534_(character, modifiers);
                }
                return false;
            }
        };
        this.launchCodeField.m_94199_(10);
        this.launchCodeField.m_94202_(0xFFFF00);
        this.launchCodeField.m_93692_(true);
        this.launchCodeField.m_94151_(text -> {
            if (((LaunchControllerMenu)this.f_97732_).getBlockEntity() != null) {
                try {
                    int targetX = Integer.parseInt(this.xCoordField.m_94155_());
                    int targetZ = Integer.parseInt(this.zCoordField.m_94155_());
                    ModNetworking.CHANNEL.sendToServer((Object)new C2SMissileControlPacket(((LaunchControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), targetX, targetZ, (String)text, false));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.m_142416_((GuiEventListener)this.launchCodeField);
        this.createKeypad(x + 50, y + 85);
        this.launchButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"LAUNCH"), button -> this.attemptLaunch()).m_252794_(x + 155, y + 160).m_253046_(70, 20).m_253136_());
        this.updateButtonStates();
    }

    private void createKeypad(int startX, int startY) {
        int buttonSize = 22;
        int spacing = 2;
        for (int i = 0; i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            int num = i + 1;
            this.keypadButtons[i] = (Button)this.m_142416_((GuiEventListener)new KeypadButton(startX + col * (buttonSize + spacing), startY + row * (buttonSize + spacing), buttonSize, buttonSize, (Component)Component.m_237113_((String)String.valueOf(num)), button -> this.appendToActiveField(String.valueOf(num))));
        }
        this.keypadButtons[9] = (Button)this.m_142416_((GuiEventListener)new KeypadButton(startX + (buttonSize + spacing), startY + 3 * (buttonSize + spacing), buttonSize, buttonSize, (Component)Component.m_237113_((String)"0"), button -> this.appendToActiveField("0")));
        this.keypadButtons[10] = (Button)this.m_142416_((GuiEventListener)new KeypadButton(startX, startY + 3 * (buttonSize + spacing), buttonSize, buttonSize, (Component)Component.m_237113_((String)"CLR"), button -> this.clearActiveField()));
        this.keypadButtons[11] = (Button)this.m_142416_((GuiEventListener)new KeypadButton(startX + 2 * (buttonSize + spacing), startY + 3 * (buttonSize + spacing), buttonSize, buttonSize, (Component)Component.m_237113_((String)"DEL"), button -> this.backspaceActiveField()));
    }

    private void appendToActiveField(String text) {
        EditBox activeField = this.getActiveField();
        if (activeField != null) {
            activeField.m_94164_(text);
            this.updateStatus("INPUT: " + text, 65280);
        }
    }

    private void clearActiveField() {
        EditBox activeField = this.getActiveField();
        if (activeField != null) {
            activeField.m_94144_("");
            this.updateStatus("CLEARED", 0xFFFF00);
        }
    }

    private void backspaceActiveField() {
        String current;
        EditBox activeField = this.getActiveField();
        if (activeField != null && !(current = activeField.m_94155_()).isEmpty()) {
            activeField.m_94144_(current.substring(0, current.length() - 1));
            this.updateStatus("DELETED", 0xFFFF00);
        }
    }

    private EditBox getActiveField() {
        if (this.xCoordField.m_93696_()) {
            return this.xCoordField;
        }
        if (this.zCoordField.m_93696_()) {
            return this.zCoordField;
        }
        if (this.launchCodeField.m_93696_()) {
            return this.launchCodeField;
        }
        this.launchCodeField.m_93692_(true);
        return this.launchCodeField;
    }

    private void attemptLaunch() {
        try {
            int x = Integer.parseInt(this.xCoordField.m_94155_());
            int z = Integer.parseInt(this.zCoordField.m_94155_());
            String code = this.launchCodeField.m_94155_();
            ModNetworking.CHANNEL.sendToServer((Object)new C2SMissileControlPacket(((LaunchControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), x, z, code, true));
            this.updateStatus("LAUNCH INITIATED", 0xFF0000);
        }
        catch (NumberFormatException e) {
            this.updateStatus("ERROR: INVALID COORDINATES", 0xFF0000);
        }
    }

    private void updateStatus(String text, int color) {
        this.statusText = text;
        this.statusColor = color;
        this.lastStatusUpdate = System.currentTimeMillis();
    }

    private void updateButtonStates() {
        if (this.launchButton != null) {
            boolean canLaunch;
            this.launchButton.f_93623_ = canLaunch = ((LaunchControllerMenu)this.f_97732_).getCooldownTicks() <= 0;
            if (((LaunchControllerMenu)this.f_97732_).getCooldownTicks() > 0) {
                this.launchButton.m_93666_((Component)Component.m_237113_((String)("COOLDOWN: " + ((LaunchControllerMenu)this.f_97732_).getCooldownTicks() / 20 + "s")));
            } else if (((LaunchControllerMenu)this.f_97732_).isArmed()) {
                this.launchButton.m_93666_((Component)Component.m_237113_((String)"LAUNCH").m_130938_(style -> style.m_178520_(0xFF0000)));
            } else {
                this.launchButton.m_93666_((Component)Component.m_237113_((String)"LAUNCH").m_130938_(style -> style.m_178520_(0x888888)));
            }
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtonStates();
        if (System.currentTimeMillis() - this.lastStatusUpdate > 3000L) {
            this.statusText = "SYSTEM READY";
            this.statusColor = 65280;
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -16777216);
        this.renderFrame(graphics, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.renderControlPanel(graphics);
    }

    private void renderFrame(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280637_(x, y, width, height, -16711936);
        graphics.m_280637_(x + 1, y + 1, width - 2, height - 2, -16742400);
        int cornerSize = 10;
        graphics.m_280509_(x, y, x + cornerSize, y + 2, -16711936);
        graphics.m_280509_(x, y, x + 2, y + cornerSize, -16711936);
        graphics.m_280509_(x + width - cornerSize, y, x + width, y + 2, -16711936);
        graphics.m_280509_(x + width - 2, y, x + width, y + cornerSize, -16711936);
        graphics.m_280509_(x, y + height - 2, x + cornerSize, y + height, -16711936);
        graphics.m_280509_(x, y + height - cornerSize, x + 2, y + height, -16711936);
        graphics.m_280509_(x + width - cornerSize, y + height - 2, x + width, y + height, -16711936);
        graphics.m_280509_(x + width - 2, y + height - cornerSize, x + width, y + height, -16711936);
    }

    private void renderControlPanel(GuiGraphics graphics) {
        graphics.m_280509_(this.f_97735_ + 10, this.f_97736_ + 10, this.f_97735_ + this.f_97726_ - 10, this.f_97736_ + 25, -16772864);
        graphics.m_280637_(this.f_97735_ + 10, this.f_97736_ + 10, this.f_97726_ - 20, 15, -16711936);
        graphics.m_280509_(this.f_97735_ + 10, this.f_97736_ + 35, this.f_97735_ + this.f_97726_ - 10, this.f_97736_ + 80, -16775168);
        graphics.m_280637_(this.f_97735_ + 10, this.f_97736_ + 35, this.f_97726_ - 20, 45, -16742400);
        graphics.m_280509_(this.f_97735_ + 45, this.f_97736_ + 82, this.f_97735_ + 125, this.f_97736_ + 180, -16775936);
        graphics.m_280637_(this.f_97735_ + 45, this.f_97736_ + 82, 80, 98, -16742400);
        graphics.m_280509_(this.f_97735_ + 135, this.f_97736_ + 85, this.f_97735_ + this.f_97726_ - 10, this.f_97736_ + 155, -16775168);
        graphics.m_280637_(this.f_97735_ + 135, this.f_97736_ + 85, this.f_97726_ - 145, 70, -16742400);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        long time;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, "NUCLEAR MISSILE CONTROLLER", this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 13, 65280);
        graphics.m_280056_(this.f_96547_, "TARGET:", this.f_97735_ + 15, this.f_97736_ + 41, 65280, false);
        graphics.m_280056_(this.f_96547_, "X:", this.f_97735_ + 75, this.f_97736_ + 41, 65280, false);
        graphics.m_280056_(this.f_96547_, "Z:", this.f_97735_ + 143, this.f_97736_ + 41, 65280, false);
        graphics.m_280056_(this.f_96547_, "AUTH CODE:", this.f_97735_ + 15, this.f_97736_ + 61, 0xFFFF00, false);
        if (this.statusText != null && !this.statusText.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusText, this.f_97735_ + 185, this.f_97736_ + 95, this.statusColor);
        }
        String armedStatus = ((LaunchControllerMenu)this.f_97732_).isArmed() ? "ARMED" : "DISARMED";
        int armedColor = ((LaunchControllerMenu)this.f_97732_).isArmed() ? 65280 : 0xFF0000;
        graphics.m_280137_(this.f_96547_, armedStatus, this.f_97735_ + 185, this.f_97736_ + 110, armedColor);
        if (((LaunchControllerMenu)this.f_97732_).getCooldownTicks() > 0) {
            String cooldown = "COOLDOWN: " + ((LaunchControllerMenu)this.f_97732_).getCooldownTicks() / 20 + "s";
            graphics.m_280137_(this.f_96547_, cooldown, this.f_97735_ + 185, this.f_97736_ + 125, 0xFFFF00);
        }
        if (((LaunchControllerMenu)this.f_97732_).isArmed() && (time = System.currentTimeMillis() / 500L) % 2L == 0L) {
            graphics.m_280137_(this.f_96547_, "! DANGER !", this.f_97735_ + 185, this.f_97736_ + 140, 0xFF0000);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.xCoordField.m_93692_(false);
        this.zCoordField.m_93692_(false);
        this.launchCodeField.m_93692_(false);
        boolean result = super.m_6375_(mouseX, mouseY, button);
        if (!(this.xCoordField.m_93696_() || this.zCoordField.m_93696_() || this.launchCodeField.m_93696_())) {
            this.launchCodeField.m_93692_(true);
        }
        return result;
    }

    private class KeypadButton
    extends Button {
        public KeypadButton(int x, int y, int width, int height, Component text, Button.OnPress onPress) {
            super(x, y, width, height, text, onPress, f_252438_);
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int bgColor = this.m_274382_() ? -16764160 : -16772864;
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, bgColor);
            int borderColor = this.m_274382_() ? -16711936 : -16742400;
            graphics.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, borderColor);
            int textColor = this.f_93623_ ? 65280 : 0x666666;
            graphics.m_280653_(LaunchControllerScreen.this.f_96547_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor);
        }
    }
}

