/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.screen;

import com.modernmissions.init.ModItems;
import com.modernmissions.menu.ReactorControllerMenu;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.C2SToggleReactorPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ReactorControllerScreen
extends AbstractContainerScreen<ReactorControllerMenu> {
    private static final int PANEL_OUTLINE = -11513776;
    private static final int PANEL_FILL = -15329770;
    private static final int PANEL_ACCENT = -14671840;
    private static final int SLOT_OUTLINE = -10592674;
    private static final int SLOT_FILL = -14474461;
    private static final int SLOT_INNER = -15658735;
    private static final int PLAYER_INV_Y = 95;
    private static final int HOTBAR_Y = 153;
    private Button toggleButton;

    public ReactorControllerScreen(ReactorControllerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 185;
        this.f_97731_ = 83;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 60;
        int buttonHeight = 20;
        int buttonX = this.f_97735_ + (this.f_97726_ - buttonWidth) / 2;
        int buttonY = this.f_97736_ + 82;
        this.toggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(((ReactorControllerMenu)this.f_97732_).isActive() ? "SHUTDOWN" : "START")), button -> {
            boolean currentState = ((ReactorControllerMenu)this.f_97732_).isActive();
            ModNetworking.sendToServer(new C2SToggleReactorPacket(((ReactorControllerMenu)this.f_97732_).getBlockEntity().m_58899_(), !currentState));
        }).m_252794_(buttonX, buttonY).m_253046_(buttonWidth, buttonHeight).m_253136_());
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.toggleButton != null) {
            this.toggleButton.m_93666_((Component)Component.m_237113_((String)(((ReactorControllerMenu)this.f_97732_).isActive() ? "SHUTDOWN" : "START")));
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        this.drawRootPanel(graphics, left, top);
        this.drawStatusPanel(graphics, left, top);
        this.drawInventoryPanel(graphics, left, top);
        this.renderMeters(graphics, left, top);
        this.renderStatusIndicator(graphics, left, top);
    }

    private void renderMeters(GuiGraphics graphics, int left, int top) {
        int meterHeight = 35;
        int meterWidth = 16;
        int meterTop = top + 20;
        this.drawVerticalBar(graphics, left + 20, meterTop, meterHeight, meterWidth, ((ReactorControllerMenu)this.f_97732_).getFuelCount(), ((ReactorControllerMenu)this.f_97732_).getMaxFuel(), -11612312);
        this.drawVerticalBar(graphics, left + 65, meterTop, meterHeight, meterWidth, ((ReactorControllerMenu)this.f_97732_).getCoolantBlocks(), ((ReactorControllerMenu)this.f_97732_).getMaxCoolantBlocks(), -7876885);
        this.drawVerticalBar(graphics, left + 110, meterTop, meterHeight, meterWidth, ((ReactorControllerMenu)this.f_97732_).getLubricantLevel(), ((ReactorControllerMenu)this.f_97732_).getMaxLubricantLevel(), -991158);
        this.renderControlRodSlot(graphics, left, top);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.modern_missions.reactor_controller.fuel"), left + 8, top + 60, 0xEAEAEA, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.modern_missions.reactor_controller.coolant"), left + 52, top + 60, 0xEAEAEA, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.modern_missions.reactor_controller.lubricant"), left + 98, top + 60, 0xEAEAEA, false);
        graphics.m_280056_(this.f_96547_, ((ReactorControllerMenu)this.f_97732_).getFuelCount() + "/" + ((ReactorControllerMenu)this.f_97732_).getMaxFuel(), left + 12, top + 70, this.valueColor(((ReactorControllerMenu)this.f_97732_).getFuelCount(), ((ReactorControllerMenu)this.f_97732_).getMaxFuel()), false);
        graphics.m_280056_(this.f_96547_, ((ReactorControllerMenu)this.f_97732_).getCoolantBlocks() + "/" + ((ReactorControllerMenu)this.f_97732_).getMaxCoolantBlocks(), left + 66, top + 70, this.valueColor(((ReactorControllerMenu)this.f_97732_).getCoolantBlocks(), ((ReactorControllerMenu)this.f_97732_).getMaxCoolantBlocks()), false);
        graphics.m_280056_(this.f_96547_, ((ReactorControllerMenu)this.f_97732_).getLubricantLevel() + "/" + ((ReactorControllerMenu)this.f_97732_).getMaxLubricantLevel(), left + 112, top + 70, this.valueColor(((ReactorControllerMenu)this.f_97732_).getLubricantLevel(), ((ReactorControllerMenu)this.f_97732_).getMaxLubricantLevel()), false);
    }

    private void renderControlRodSlot(GuiGraphics graphics, int left, int top) {
        int slotX = left + this.f_97726_ - 26;
        int slotY = top + 18;
        this.drawSlot(graphics, slotX, slotY);
        int count = ((ReactorControllerMenu)this.f_97732_).getControlRodCount();
        if (count > 0) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.REACTOR_CONTROL_ROD_BUNDLE.get(), count);
            graphics.m_280480_(stack, slotX, slotY);
            int progressPct = ((ReactorControllerMenu)this.f_97732_).getControlRodProgressPct();
            int depletedPct = 100 - progressPct;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            this.drawDurabilityBar(graphics, slotX, slotY, progressPct, ((ReactorControllerMenu)this.f_97732_).isActive());
            graphics.m_280168_().m_85849_();
            if (count > 1) {
                String countStr = String.valueOf(count);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                graphics.m_280056_(this.f_96547_, countStr, slotX + 19 - 2 - this.f_96547_.m_92895_(countStr), slotY + 9, 0xFFFFFF, true);
                graphics.m_280168_().m_85849_();
            }
        } else {
            int innerLeft = slotX + 1;
            int innerTop = slotY + 1;
            int innerRight = slotX + 15;
            int innerBottom = slotY + 15;
            graphics.m_280509_(innerLeft, innerTop, innerRight, innerBottom, 0x77000000);
        }
    }

    private void drawDurabilityBar(GuiGraphics graphics, int slotX, int slotY, int remainingPercent, boolean active) {
        int x = slotX + 2;
        int y = slotY + 13;
        int width = 13;
        int filled = Mth.m_14045_((int)((int)Math.round((double)width * ((double)remainingPercent / 100.0))), (int)0, (int)width);
        graphics.m_280509_(x, y, x + width, y + 2, -16777216);
        float hue = (float)remainingPercent / 100.0f / 3.0f;
        int color = 0xFF000000 | Mth.m_14169_((float)hue, (float)1.0f, (float)(active ? 1.0f : 0.5f));
        graphics.m_280509_(x, y, x + filled, y + 1, color);
        graphics.m_280509_(x, y + 1, x + filled, y + 2, color);
    }

    private void drawVerticalBar(GuiGraphics graphics, int x, int y, int height, int width, int value, int maxValue, int fillColor) {
        graphics.m_280509_(x, y, x + width, y + height, -14671840);
        graphics.m_280509_(x + 1, y + 1, x + width - 1, y + height - 1, -15329770);
        if (maxValue <= 0 || value <= 0) {
            return;
        }
        value = Math.min(value, maxValue);
        int filled = (int)Math.ceil((double)value / (double)maxValue * (double)(height - 2));
        graphics.m_280509_(x + 1, y + height - filled, x + width - 1, y + height - 1, fillColor);
    }

    private void drawRootPanel(GuiGraphics graphics, int left, int top) {
        this.fillPanel(graphics, left, top, this.f_97726_, this.f_97727_);
    }

    private void drawStatusPanel(GuiGraphics graphics, int left, int top) {
        this.fillPanel(graphics, left + 8, top + 15, this.f_97726_ - 16, 75);
        graphics.m_280509_(left + 8, top + 15, left + this.f_97726_ - 8, top + 17, -11513776);
    }

    private void drawInventoryPanel(GuiGraphics graphics, int left, int top) {
        this.fillPanel(graphics, left + 8, top + 95 - 6, this.f_97726_ - 16, 90);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.drawSlot(graphics, left + 8 + col * 18, top + 95 + row * 18);
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.drawSlot(graphics, left + 8 + col * 18, top + 153);
        }
    }

    private void fillPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, -11513776);
        graphics.m_280509_(x + 1, y + 1, x + width - 1, y + height - 1, -14671840);
        graphics.m_280509_(x + 2, y + 2, x + width - 2, y + height - 2, -15329770);
    }

    private void drawSlot(GuiGraphics graphics, int x, int y) {
        graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -10592674);
        graphics.m_280509_(x, y, x + 16, y + 16, -14474461);
        graphics.m_280509_(x + 1, y + 1, x + 15, y + 15, -15658735);
    }

    private int valueColor(int current, int max) {
        if (max <= 0) {
            return 0xC8C8C8;
        }
        if (current <= 0) {
            return 0xFF5A5A;
        }
        double ratio = (double)current / (double)max;
        if (ratio < 0.35) {
            return 14730328;
        }
        return 0xC8C8C8;
    }

    private void renderStatusIndicator(GuiGraphics graphics, int left, int top) {
        int circleX = left + this.f_97726_ - 18;
        int circleY = top + 6;
        int circleSize = 8;
        int outerColor = ((ReactorControllerMenu)this.f_97732_).isActive() ? -14001622 : -10868182;
        graphics.m_280509_(circleX - 1, circleY - 1, circleX + circleSize + 1, circleY + circleSize + 1, outerColor);
        int innerColor = ((ReactorControllerMenu)this.f_97732_).isActive() ? -11612312 : -42406;
        graphics.m_280509_(circleX, circleY, circleX + circleSize, circleY + circleSize, innerColor);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0xF0F0F0, false);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int circleX = left + this.f_97726_ - 18;
        int circleY = top + 6;
        int circleSize = 8;
        if (mouseX >= circleX && mouseX <= circleX + circleSize && mouseY >= circleY && mouseY <= circleY + circleSize) {
            MutableComponent statusText = Component.m_237115_((String)(((ReactorControllerMenu)this.f_97732_).isActive() ? "gui.modern_missions.reactor_controller.active" : "gui.modern_missions.reactor_controller.inactive"));
            graphics.m_280557_(this.f_96547_, (Component)statusText, mouseX, mouseY);
        }
        int slotX = left + this.f_97726_ - 26;
        int slotY = top + 18;
        int slotSize = 16;
        if (mouseX >= slotX && mouseX <= slotX + slotSize && mouseY >= slotY && mouseY <= slotY + slotSize) {
            int count = ((ReactorControllerMenu)this.f_97732_).getControlRodCount();
            if (count > 0) {
                int remaining = Math.max(0, Math.min(100, ((ReactorControllerMenu)this.f_97732_).getControlRodProgressPct()));
                if (((ReactorControllerMenu)this.f_97732_).isActive()) {
                    MutableComponent rodText = Component.m_237113_((String)("Control Rod Bundles: " + count + " \u2014 Remaining: " + remaining + "%"));
                    graphics.m_280557_(this.f_96547_, (Component)rodText, mouseX, mouseY);
                } else {
                    MutableComponent standbyText = Component.m_237113_((String)("Control Rod Bundles: " + count + " \u2014 Standby (Remaining: " + remaining + "%)"));
                    graphics.m_280557_(this.f_96547_, (Component)standbyText, mouseX, mouseY);
                }
            } else {
                MutableComponent emptyText = Component.m_237113_((String)"No Control Rod Bundle");
                graphics.m_280557_(this.f_96547_, (Component)emptyText, mouseX, mouseY);
            }
        }
    }
}

