/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CINEMATIC_TELEPORT;
    public static final ForgeConfigSpec.IntValue MAX_RADIUS;
    public static final ForgeConfigSpec.IntValue PLAYER_COOLDOWN_TICKS;
    public static final ForgeConfigSpec.BooleanValue NON_DESTRUCTIVE_BLASTS;
    public static final ForgeConfigSpec.DoubleValue ORBITAL_STRIKE_BASE_POWER;
    public static final ForgeConfigSpec.DoubleValue ORBITAL_STRIKE_POWER_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue BARRAGE_POWER_MULTIPLIER;
    public static final ForgeConfigSpec.IntValue URANIUM_GROWTH_RATE;
    public static final ForgeConfigSpec.IntValue OIL_SOURCE_GROWTH_RATE;
    public static final ForgeConfigSpec.IntValue PURIFIED_WATER_GROWTH_RATE;
    public static final ForgeConfigSpec.IntValue AMETHYST_SOURCE_GROWTH_CHANCE;
    public static final ForgeConfigSpec.IntValue POTATO_CONVERSION_INTERVAL_TICKS;
    public static final ForgeConfigSpec.DoubleValue POTATO_CONVERSION_CHANCE;
    public static final ForgeConfigSpec.IntValue POTATO_CONVERSION_RADIUS;
    public static final ForgeConfigSpec.IntValue POTATO_HARVEST_RADIUS;
    public static final ForgeConfigSpec.DoubleValue POTATO_HARVEST_POISON_CHANCE;
    public static final ForgeConfigSpec.DoubleValue FURNACE_COOK_TIME_MULTIPLIER;
    public static final ForgeConfigSpec.BooleanValue ENABLE_BACKGROUND_MAP_GENERATION;
    public static final ForgeConfigSpec.IntValue MAP_UPDATE_INTERVAL;
    public static final ForgeConfigSpec.IntValue MAP_PRIME_TIME_BUDGET_MS;
    public static final ForgeConfigSpec.IntValue MAP_PRIME_SCAN_RADIUS;
    public static final ForgeConfigSpec.IntValue MAP_INVALIDATE_RADIUS;
    public static final ForgeConfigSpec.IntValue REACTOR_FUEL_CONSUMPTION_RATE;
    public static final ForgeConfigSpec.IntValue REACTOR_LUBRICANT_CONSUMPTION_RATE;
    public static final ForgeConfigSpec.IntValue REACTOR_COOLANT_CONSUMPTION_RATE;
    public static final ForgeConfigSpec.IntValue REACTOR_CONTROL_ROD_CONSUMPTION_RATE;
    public static final ForgeConfigSpec.DoubleValue SAND_SALTPETER_CHANCE;
    public static final ForgeConfigSpec.DoubleValue SAND_SULFUR_CHANCE;
    public static final ForgeConfigSpec.DoubleValue GRAVEL_SULFUR_CHANCE;

    static {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.push("orbital");
        ENABLE_CINEMATIC_TELEPORT = b.comment("If true, requester is moved to a top-down spectator view during countdown and restored after impact.").define("enableCinematicTeleport", true);
        MAX_RADIUS = b.comment("Maximum allowed strike radius in blocks").defineInRange("maxRadius", 64, 2, 256);
        PLAYER_COOLDOWN_TICKS = b.comment("Player cooldown after authorizing a strike (in ticks)").defineInRange("playerCooldownTicks", 100, 0, 1200);
        NON_DESTRUCTIVE_BLASTS = b.comment("If true, explosions will not damage blocks (best for cinematic use)").define("nonDestructiveBlasts", true);
        ORBITAL_STRIKE_BASE_POWER = b.comment("Base explosion power for orbital strike main impact (vanilla TNT = 4.0)").defineInRange("orbitalStrikeBasePower", 16.0, 1.0, 100.0);
        ORBITAL_STRIKE_POWER_MULTIPLIER = b.comment("Multiplier for strike radius to calculate additional explosion power").defineInRange("orbitalStrikePowerMultiplier", 0.75, 0.1, 5.0);
        BARRAGE_POWER_MULTIPLIER = b.comment("Power multiplier for secondary barrage explosions relative to main strike").defineInRange("barragePowerMultiplier", 0.4, 0.1, 1.0);
        b.pop();
        b.push("resources");
        b.comment("Resource block growth rates (in ticks). Lower values = faster growth, higher values = slower growth");
        URANIUM_GROWTH_RATE = b.comment("Average ticks between uranium ore growth stages (0->1->2->3). Default 900 = 45 seconds (25% faster than 1200)").defineInRange("uraniumGrowthRate", 900, 20, 12000);
        OIL_SOURCE_GROWTH_RATE = b.comment("Average ticks for oil source blocks to refill. Default 600 = 30 seconds").defineInRange("oilSourceGrowthRate", 600, 20, 12000);
        PURIFIED_WATER_GROWTH_RATE = b.comment("Average ticks for purified water source blocks to refill. Default 600 = 30 seconds (matched to oil)").defineInRange("purifiedWaterGrowthRate", 600, 20, 12000);
        AMETHYST_SOURCE_GROWTH_CHANCE = b.comment("Inverse chance for amethyst growth per random tick (higher = slower). Default 80").defineInRange("amethystSourceGrowthChance", 80, 10, 200);
        b.pop();
        b.push("reactor");
        b.comment("Nuclear reactor consumption rates (in ticks between consumption). Lower values = faster consumption");
        REACTOR_FUEL_CONSUMPTION_RATE = b.comment("Ticks between uranium fuel cell consumption. Default 3750 = ~3 minutes (64 cells last 10 MC days)").defineInRange("fuelConsumptionRate", 3750, 100, 72000);
        REACTOR_LUBRICANT_CONSUMPTION_RATE = b.comment("Ticks between lubricant consumption. Default 24000 = 20 minutes (10 levels last 10 MC days)").defineInRange("lubricantConsumptionRate", 24000, 20, 48000);
        REACTOR_COOLANT_CONSUMPTION_RATE = b.comment("Ticks between coolant (purified water) consumption. Default 9600 = 8 minutes (25 blocks last 10 MC days)").defineInRange("coolantConsumptionRate", 9600, 20, 24000);
        REACTOR_CONTROL_ROD_CONSUMPTION_RATE = b.comment("Ticks between control rod bundle consumption. Default 144000 = 6 Minecraft days (2 hours real time)").defineInRange("controlRodConsumptionRate", 144000, 100, 288000);
        b.pop();
        b.push("loot");
        b.comment("Drop chances for materials from blocks (0.0 = never, 1.0 = always)");
        SAND_SALTPETER_CHANCE = b.comment("Chance for sand to drop saltpeter. Default 0.03 = 3%").defineInRange("sandSaltpeterChance", 0.03, 0.0, 1.0);
        SAND_SULFUR_CHANCE = b.comment("Chance for sand to drop sulfur. Default 0.02 = 2%").defineInRange("sandSulfurChance", 0.02, 0.0, 1.0);
        GRAVEL_SULFUR_CHANCE = b.comment("Chance for gravel to drop sulfur. Default 0.03 = 3%").defineInRange("gravelSulfurChance", 0.03, 0.0, 1.0);
        b.pop();
        b.push("gameplay");
        b.comment("Potato conversion near uranium settings");
        POTATO_CONVERSION_INTERVAL_TICKS = b.comment("Ticks between conversion checks. Lower = more frequent checks. Default 40 (~2s)").defineInRange("potatoConversionIntervalTicks", 40, 1, 1200);
        POTATO_CONVERSION_CHANCE = b.comment("Chance (0.0-1.0) per check to convert dropped potatoes. Set to 0 to disable. Default 0.0").defineInRange("potatoConversionChance", 0.0, 0.0, 1.0);
        POTATO_CONVERSION_RADIUS = b.comment("Radius in blocks to detect uranium. Default 3").defineInRange("potatoConversionRadius", 3, 1, 16);
        POTATO_HARVEST_RADIUS = b.comment("Radius in blocks to check for uranium affecting potato harvests. Default 5").defineInRange("potatoHarvestRadius", 5, 1, 32);
        POTATO_HARVEST_POISON_CHANCE = b.comment("Chance (0.0-1.0) that potatoes harvested near uranium drop as poisonous potatoes. Default 0.8").defineInRange("potatoHarvestPoisonChance", 0.8, 0.0, 1.0);
        FURNACE_COOK_TIME_MULTIPLIER = b.comment("Multiplier applied to vanilla Furnace and Blast Furnace cook times. Minimum 1.0. Default 3.0").defineInRange("furnaceCookTimeMultiplier", 3.0, 1.0, 10.0);
        b.pop();
        b.push("satellite");
        b.comment("Satellite transmitter and map generation settings");
        ENABLE_BACKGROUND_MAP_GENERATION = b.comment("Enable background map tile generation when holding satellite transmitter. Set to false to prevent hitching in Replay Mod.").define("enableBackgroundMapGeneration", true);
        MAP_UPDATE_INTERVAL = b.comment("Ticks between map tile updates (20 = 1 second). Higher values reduce lag but slower map updates.").defineInRange("mapUpdateInterval", 100, 20, 600);
        MAP_PRIME_TIME_BUDGET_MS = b.comment("Time budget per prime() call in milliseconds (generate as many tiles as fit in this budget).").defineInRange("mapPrimeTimeBudgetMs", 2, 1, 10);
        MAP_PRIME_SCAN_RADIUS = b.comment("Scan radius in chunks around the player when priming tiles. Lower values reduce work per call.").defineInRange("mapPrimeScanRadius", 3, 1, 8);
        MAP_INVALIDATE_RADIUS = b.comment("Radius in chunks for invalidating fog tiles when moving chunks.").defineInRange("mapInvalidateRadius", 4, 1, 12);
        b.pop();
        SPEC = b.build();
    }
}

