/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.entity;

import com.modernmissions.init.ModEntities;
import com.modernmissions.orbital.OrbitalStrikeManager;
import com.modernmissions.orbital.StrikeType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SatelliteEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> TARGET_X = SynchedEntityData.m_135353_(SatelliteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_Z = SynchedEntityData.m_135353_(SatelliteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STRIKE_RADIUS = SynchedEntityData.m_135353_(SatelliteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(SatelliteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int PHASE_DESCENDING = 0;
    private static final int PHASE_HOVERING = 1;
    private static final int PHASE_STRIKING = 2;
    private static final int PHASE_DEPARTING = 3;
    private int phaseTicks = 0;
    private Player requestingPlayer;
    private double hoverHeight = 80.0;
    private static final double CANNON_OFFSET_X = 0.0;
    private static final double CANNON_OFFSET_Z = 6.0;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.satellite.idle");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenLoop("animation.satellite.shoot");

    public SatelliteEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.m_20331_(true);
    }

    public SatelliteEntity(Level level, int targetX, int targetZ, int radius, Player player) {
        this((EntityType)ModEntities.SATELLITE.get(), level);
        this.requestingPlayer = player;
        this.f_19804_.m_135381_(TARGET_X, (Object)targetX);
        this.f_19804_.m_135381_(TARGET_Z, (Object)targetZ);
        this.f_19804_.m_135381_(STRIKE_RADIUS, (Object)radius);
        this.f_19804_.m_135381_(PHASE, (Object)0);
        double targetGroundHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, targetX, targetZ);
        double startY = targetGroundHeight + this.hoverHeight + 20.0;
        this.m_6034_((double)targetX + 0.5, startY, (double)targetZ + 0.5);
        System.out.println("Satellite spawned at " + this.m_20182_() + " targeting (" + targetX + ", " + targetZ + ")");
        System.out.println("Ground height: " + targetGroundHeight + ", Hover target: " + (targetGroundHeight + this.hoverHeight));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_X, (Object)0);
        this.f_19804_.m_135372_(TARGET_Z, (Object)0);
        this.f_19804_.m_135372_(STRIKE_RADIUS, (Object)12);
        this.f_19804_.m_135372_(PHASE, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.serverTick();
        } else {
            int currentPhase = (Integer)this.f_19804_.m_135370_(PHASE);
            if (currentPhase != 2 && this.f_19796_.m_188503_(5) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() - 0.5, this.m_20189_(), 0.0, -0.05, 0.0);
            }
        }
        ++this.phaseTicks;
    }

    private void serverTick() {
        int currentPhase = (Integer)this.f_19804_.m_135370_(PHASE);
        int targetX = (Integer)this.f_19804_.m_135370_(TARGET_X);
        int targetZ = (Integer)this.f_19804_.m_135370_(TARGET_Z);
        switch (currentPhase) {
            case 0: {
                this.handleDescending(targetX, targetZ);
                break;
            }
            case 1: {
                this.handleHovering();
                break;
            }
            case 2: {
                this.handleStriking(targetX, targetZ);
                break;
            }
            case 3: {
                this.handleDeparting();
            }
        }
    }

    private void handleDescending(int targetX, int targetZ) {
        double groundHeight = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, targetX, targetZ);
        double targetY = groundHeight + this.hoverHeight;
        Vec3 targetPos = new Vec3((double)targetX + 0.5, targetY, (double)targetZ + 0.5);
        Vec3 currentPos = this.m_20182_();
        Vec3 direction = targetPos.m_82546_(currentPos).m_82541_();
        double speed = 0.3;
        Vec3 newPos = currentPos.m_82549_(direction.m_82490_(speed));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(direction.m_82490_(speed));
        }
        if (this.phaseTicks % 20 == 0) {
            System.out.println("Satellite descending: " + currentPos + " -> " + targetPos + " (distance: " + currentPos.m_82554_(targetPos) + ")");
        }
        if (currentPos.m_82554_(targetPos) < 2.0) {
            this.f_19804_.m_135381_(PHASE, (Object)1);
            this.phaseTicks = 0;
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11739_, SoundSource.HOSTILE, 2.0f, 0.8f);
            System.out.println("Satellite reached hover position");
        }
    }

    private void handleHovering() {
        if (this.phaseTicks >= 20) {
            this.f_19804_.m_135381_(PHASE, (Object)2);
            this.phaseTicks = 0;
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11767_, SoundSource.HOSTILE, 3.0f, 0.5f);
            System.out.println("Satellite beginning strike sequence");
        }
    }

    private void handleStriking(int targetX, int targetZ) {
        if (this.phaseTicks == 25) {
            int radius = (Integer)this.f_19804_.m_135370_(STRIKE_RADIUS);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                level = this.requestingPlayer;
                if (level instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)level;
                    OrbitalStrikeManager.requestStrike(serverLevel, targetX, targetZ, radius, StrikeType.CINEMATIC_BOMBARDMENT, serverPlayer);
                }
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11892_, SoundSource.HOSTILE, 4.0f, 0.3f);
            System.out.println("Satellite launched orbital strike at (" + targetX + ", " + targetZ + ")");
        }
        if (this.phaseTicks >= 150) {
            this.f_19804_.m_135381_(PHASE, (Object)3);
            this.phaseTicks = 0;
        }
    }

    private void handleDeparting() {
        Vec3 currentPos = this.m_20182_();
        this.m_6034_(currentPos.f_82479_, currentPos.f_82480_ + 1.0, currentPos.f_82481_);
        if (this.phaseTicks >= 60) {
            this.m_146870_();
            System.out.println("Satellite departed");
        }
    }

    public int getCurrentPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    protected void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(TARGET_X, (Object)tag.m_128451_("TargetX"));
        this.f_19804_.m_135381_(TARGET_Z, (Object)tag.m_128451_("TargetZ"));
        this.f_19804_.m_135381_(STRIKE_RADIUS, (Object)tag.m_128451_("StrikeRadius"));
        this.f_19804_.m_135381_(PHASE, (Object)tag.m_128451_("Phase"));
        this.phaseTicks = tag.m_128451_("PhaseTicks");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("TargetX", ((Integer)this.f_19804_.m_135370_(TARGET_X)).intValue());
        tag.m_128405_("TargetZ", ((Integer)this.f_19804_.m_135370_(TARGET_Z)).intValue());
        tag.m_128405_("StrikeRadius", ((Integer)this.f_19804_.m_135370_(STRIKE_RADIUS)).intValue());
        tag.m_128405_("Phase", ((Integer)this.f_19804_.m_135370_(PHASE)).intValue());
        tag.m_128405_("PhaseTicks", this.phaseTicks);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<SatelliteEntity> animationState) {
        int phase = this.getCurrentPhase();
        AnimationController controller = animationState.getController();
        AnimationProcessor.QueuedAnimation currentAnim = controller.getCurrentAnimation();
        if (phase == 2) {
            if (currentAnim == null || controller.getCurrentRawAnimation() != SHOOT) {
                controller.setAnimation(SHOOT);
            }
        } else if (currentAnim == null || controller.getCurrentRawAnimation() != IDLE) {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }
}

