/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.init;

import com.modernmissions.init.ModItems;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"modern_missions");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"modern_missions");
    public static final DeferredRegister<Block> FLUID_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"modern_missions");
    public static final RegistryObject<FluidType> OIL_TYPE = FLUID_TYPES.register("oil", () -> new FluidType(FluidType.Properties.create().canExtinguish(false).canPushEntity(true).supportsBoating(true).canHydrate(false).density(900).viscosity(1800).temperature(300).lightLevel(0).fallDistanceModifier(0.8f).motionScale(0.005).descriptionId("fluid.modern_missions.oil")){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private final ResourceLocation STILL = new ResourceLocation("minecraft", "block/water_still");
                private final ResourceLocation FLOW = new ResourceLocation("minecraft", "block/water_flow");
                private final ResourceLocation OVERLAY = new ResourceLocation("minecraft", "block/water_overlay");

                public ResourceLocation getStillTexture() {
                    return this.STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return this.FLOW;
                }

                public ResourceLocation getOverlayTexture() {
                    return this.OVERLAY;
                }

                public int getTintColor() {
                    return -16119286;
                }
            });
        }
    });
    public static final RegistryObject<ForgeFlowingFluid.Source> OIL_SOURCE = FLUIDS.register("oil", () -> new ForgeFlowingFluid.Source(ModFluids.properties()));
    public static final RegistryObject<ForgeFlowingFluid.Flowing> OIL_FLOWING = FLUIDS.register("flowing_oil", () -> new ForgeFlowingFluid.Flowing(ModFluids.properties()));
    public static final RegistryObject<LiquidBlock> OIL_BLOCK = FLUID_BLOCKS.register("oil", () -> new LiquidBlock(OIL_SOURCE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_280170_()));
    public static final RegistryObject<FluidType> PURIFIED_WATER_TYPE = FLUID_TYPES.register("purified_water", () -> new FluidType(FluidType.Properties.create().canExtinguish(true).canPushEntity(true).supportsBoating(true).canHydrate(true).density(1000).viscosity(1000).temperature(300).lightLevel(0).fallDistanceModifier(1.0f).motionScale(0.007).descriptionId("fluid.modern_missions.purified_water")){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private final ResourceLocation STILL = new ResourceLocation("minecraft", "block/water_still");
                private final ResourceLocation FLOW = new ResourceLocation("minecraft", "block/water_flow");
                private final ResourceLocation OVERLAY = new ResourceLocation("minecraft", "block/water_overlay");

                public ResourceLocation getStillTexture() {
                    return this.STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return this.FLOW;
                }

                public ResourceLocation getOverlayTexture() {
                    return this.OVERLAY;
                }

                public int getTintColor() {
                    return -7876885;
                }
            });
        }
    });
    public static final RegistryObject<ForgeFlowingFluid.Source> PURIFIED_WATER_SOURCE = FLUIDS.register("purified_water", () -> new ForgeFlowingFluid.Source(ModFluids.purifiedWaterProperties()));
    public static final RegistryObject<ForgeFlowingFluid.Flowing> PURIFIED_WATER_FLOWING = FLUIDS.register("flowing_purified_water", () -> new ForgeFlowingFluid.Flowing(ModFluids.purifiedWaterProperties()));
    public static final RegistryObject<LiquidBlock> PURIFIED_WATER_BLOCK = FLUID_BLOCKS.register("purified_water", () -> new LiquidBlock(PURIFIED_WATER_SOURCE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_280170_()));

    private static ForgeFlowingFluid.Properties properties() {
        return new ForgeFlowingFluid.Properties(OIL_TYPE, OIL_SOURCE, OIL_FLOWING).slopeFindDistance(2).levelDecreasePerBlock(2).block(OIL_BLOCK).bucket(ModItems.OIL_BUCKET);
    }

    private static ForgeFlowingFluid.Properties purifiedWaterProperties() {
        return new ForgeFlowingFluid.Properties(PURIFIED_WATER_TYPE, PURIFIED_WATER_SOURCE, PURIFIED_WATER_FLOWING).slopeFindDistance(2).levelDecreasePerBlock(2).block(PURIFIED_WATER_BLOCK).bucket(ModItems.PURIFIED_WATER_BUCKET);
    }

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
        FLUIDS.register(eventBus);
        FLUID_BLOCKS.register(eventBus);
    }
}

