/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.item;

import com.modernmissions.block.LaunchPadBlock;
import com.modernmissions.block.OilSourceBlock;
import com.modernmissions.block.PurifiedWaterSourceBlock;
import com.modernmissions.block.entity.LaunchPadBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class AdminDebugStickItem
extends Item {
    public AdminDebugStickItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos checkPos = pos;
        BlockState blockState = level.m_8055_(pos);
        if (!blockState.m_60819_().m_76178_() || blockState.m_60734_() instanceof LiquidBlock) {
            checkPos = pos;
        } else {
            BlockPos abovePos = pos.m_7494_();
            BlockState aboveState = level.m_8055_(abovePos);
            if (aboveState.m_60734_() instanceof LiquidBlock || !aboveState.m_60819_().m_76178_()) {
                checkPos = abovePos;
                blockState = aboveState;
            }
        }
        if (blockState.m_60734_() instanceof LiquidBlock) {
            if (!level.f_46443_) {
                this.checkLiquidBlock(level, checkPos, player, blockState);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        FluidState fluidState = blockState.m_60819_();
        if (!fluidState.m_76178_()) {
            if (!level.f_46443_) {
                this.checkFluidState(level, checkPos, player, fluidState);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos center = this.findLaunchPadCenter(level, pos);
        if (center != null && (blockEntity = level.m_7702_(center)) instanceof LaunchPadBlockEntity) {
            LaunchPadBlockEntity launchPad = (LaunchPadBlockEntity)blockEntity;
            if (launchPad.hasMissile()) {
                int targetZ;
                int distance = 100;
                double angle = Math.random() * Math.PI * 2.0;
                int targetX = (int)((double)center.m_123341_() + Math.cos(angle) * (double)distance);
                boolean launched = launchPad.forceInstantLaunch(targetX, targetZ = (int)((double)center.m_123343_() + Math.sin(angle) * (double)distance));
                if (launched) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u2713 Missile launched instantly to (" + targetX + ", " + targetZ + ")!")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), true);
                    level.m_5594_(null, center, SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"\u2717 Launch failed").m_130940_(ChatFormatting.RED), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"No missile on this launch pad").m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.m_5661_((Component)Component.m_237113_((String)("Block: " + blockState.m_60734_().m_7705_())).m_130940_(ChatFormatting.GRAY), true);
        return InteractionResult.PASS;
    }

    private void checkLiquidBlock(Level level, BlockPos pos, Player player, BlockState blockState) {
        String blockName = blockState.m_60734_().m_7705_();
        FluidState fluidState = blockState.m_60819_();
        player.m_5661_((Component)Component.m_237113_((String)"=== Liquid Block Debug Info ===").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        player.m_5661_((Component)Component.m_237113_((String)"Block: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)blockName).m_130940_(ChatFormatting.WHITE)), false);
        player.m_5661_((Component)Component.m_237113_((String)"Position: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.WHITE)), false);
        if (!fluidState.m_76178_()) {
            boolean isSource = fluidState.m_76170_();
            int fluidLevel = fluidState.m_76186_();
            String fluidName = fluidState.m_76152_().getFluidType().getDescriptionId();
            player.m_5661_((Component)Component.m_237113_((String)"Fluid: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)fluidName).m_130940_(ChatFormatting.WHITE)), false);
            player.m_5661_((Component)Component.m_237113_((String)"Is Source Block: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(isSource ? "YES" : "NO")).m_130944_(new ChatFormatting[]{isSource ? ChatFormatting.GREEN : ChatFormatting.RED, ChatFormatting.BOLD})), false);
            player.m_5661_((Component)Component.m_237113_((String)"Fluid Level: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(fluidLevel + "/8")).m_130940_(ChatFormatting.WHITE)), false);
            if (blockState.m_60734_() instanceof OilSourceBlock) {
                player.m_5661_((Component)Component.m_237113_((String)"Special: ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"Oil Source Generator Block").m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC})), false);
            } else if (blockState.m_60734_() instanceof PurifiedWaterSourceBlock) {
                player.m_5661_((Component)Component.m_237113_((String)"Special: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"Purified Water Source Generator Block").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})), false);
            }
        }
        level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.PLAYERS, 0.5f, 1.5f);
    }

    private void checkFluidState(Level level, BlockPos pos, Player player, FluidState fluidState) {
        boolean isSource = fluidState.m_76170_();
        int fluidLevel = fluidState.m_76186_();
        String fluidName = fluidState.m_76152_().getFluidType().getDescriptionId();
        player.m_5661_((Component)Component.m_237113_((String)"=== Fluid State Debug Info ===").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}), false);
        player.m_5661_((Component)Component.m_237113_((String)"Position: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.WHITE)), false);
        player.m_5661_((Component)Component.m_237113_((String)"Fluid: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)fluidName).m_130940_(ChatFormatting.WHITE)), false);
        player.m_5661_((Component)Component.m_237113_((String)"Is Source: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(isSource ? "YES" : "NO")).m_130944_(new ChatFormatting[]{isSource ? ChatFormatting.GREEN : ChatFormatting.RED, ChatFormatting.BOLD})), false);
        player.m_5661_((Component)Component.m_237113_((String)"Level: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(fluidLevel + "/8")).m_130940_(ChatFormatting.WHITE)), false);
        level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.PLAYERS, 0.5f, 1.5f);
    }

    private BlockPos findLaunchPadCenter(Level level, BlockPos pos) {
        for (int dx = -2; dx <= 0; ++dx) {
            for (int dz = -2; dz <= 0; ++dz) {
                BlockPos corner = pos.m_7918_(dx, 0, dz);
                if (!this.isComplete3x3LaunchPad(level, corner)) continue;
                return corner.m_7918_(1, 0, 1);
            }
        }
        return null;
    }

    private boolean isComplete3x3LaunchPad(Level level, BlockPos corner) {
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                BlockPos checkPos = corner.m_7918_(x, 0, z);
                if (level.m_8055_(checkPos).m_60734_() instanceof LaunchPadBlock) continue;
                return false;
            }
        }
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"Admin Debug Tool").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237113_((String)"Functions:").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237113_((String)"  \u2022 Check liquid source blocks").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237113_((String)"  \u2022 Instant missile launch").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237113_((String)"Right-click any block to debug").m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

