/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.mixin;

import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Unique
    private int modernMissions$uraniumTickCounter = 0;
    @Unique
    private boolean modernMissions$desynced = false;

    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setItem(ItemStack var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        ItemStack stack;
        ItemEntity self = (ItemEntity)this;
        Level level = self.m_9236_();
        if (!level.f_46443_ && self.m_6084_() && (stack = this.getItem()).m_41720_() == Items.f_42620_ && stack.m_41613_() > 0) {
            int interval = (Integer)CommonConfig.POTATO_CONVERSION_INTERVAL_TICKS.get();
            if (interval < 1) {
                interval = 1;
            }
            if (!this.modernMissions$desynced) {
                this.modernMissions$uraniumTickCounter = level.m_213780_().m_188503_(interval);
                this.modernMissions$desynced = true;
            }
            ++this.modernMissions$uraniumTickCounter;
            if (this.modernMissions$uraniumTickCounter >= interval) {
                this.modernMissions$uraniumTickCounter = 0;
                double chance = (Double)CommonConfig.POTATO_CONVERSION_CHANCE.get();
                if (chance <= 0.0) {
                    return;
                }
                RandomSource rng = level.m_213780_();
                if (rng.m_188500_() >= chance) {
                    return;
                }
                if (this.modernMissions$isNearUraniumBlock(self)) {
                    int potatoCount = stack.m_41613_();
                    int convertCount = Math.min(potatoCount, rng.m_188503_(3) + 1);
                    stack.m_41774_(convertCount);
                    ItemStack poisonousPotatoes = new ItemStack((ItemLike)Items.f_42675_, convertCount);
                    if (stack.m_41619_()) {
                        this.setItem(poisonousPotatoes);
                    } else {
                        ItemEntity poisonousEntity = new ItemEntity(level, self.m_20185_(), self.m_20186_(), self.m_20189_(), poisonousPotatoes);
                        poisonousEntity.m_32060_();
                        poisonousEntity.m_20334_(rng.m_188583_() * 0.05, 0.1, rng.m_188583_() * 0.05);
                        level.m_7967_((Entity)poisonousEntity);
                    }
                }
            }
        }
    }

    @Unique
    private boolean modernMissions$isNearUraniumBlock(ItemEntity itemEntity) {
        Level level = itemEntity.m_9236_();
        BlockPos itemPos = itemEntity.m_20183_();
        int radius = (Integer)CommonConfig.POTATO_CONVERSION_RADIUS.get();
        if (radius < 1) {
            radius = 1;
        }
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double distanceSq;
                    BlockPos checkPos = itemPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    if (!state.m_60713_((Block)ModBlocks.URANIUM_BLOCK.get()) && !state.m_60713_((Block)ModBlocks.URANIUM_ORE.get()) && !state.m_60713_((Block)ModBlocks.URANIUM_SOURCE.get()) || !((distanceSq = itemEntity.m_20275_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 0.5, (double)checkPos.m_123343_() + 0.5)) <= (double)r2)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

