/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.block.entity.LaunchControllerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class C2SMissileAuthPacket {
    private final BlockPos pos;
    private final String passcode;
    private final boolean isSetup;

    public C2SMissileAuthPacket(BlockPos pos, String passcode, boolean isSetup) {
        this.pos = pos;
        this.passcode = passcode;
        this.isSetup = isSetup;
    }

    public C2SMissileAuthPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.passcode = buf.m_130277_();
        this.isSetup = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.passcode);
        buf.writeBoolean(this.isSetup);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!level.m_46749_(this.pos)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (!(blockEntity instanceof LaunchControllerBlockEntity)) {
                return;
            }
            LaunchControllerBlockEntity controller = (LaunchControllerBlockEntity)blockEntity;
            if (this.isSetup) {
                if (!controller.hasPasscode()) {
                    controller.setPasscode(this.passcode);
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)controller, (BlockPos)this.pos);
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Passcode already set!").m_130938_(style -> style.m_178520_(0xFF0000)));
                }
            } else {
                if (controller.isLockedOut()) {
                    long remainingTime = controller.getRemainingLockoutTime() / 20L;
                    player.m_213846_((Component)Component.m_237113_((String)("System locked. Try again in " + remainingTime + " seconds.")).m_130938_(style -> style.m_178520_(0xFF0000)));
                    return;
                }
                if (controller.verifyPasscode(this.passcode)) {
                    player.m_213846_((Component)Component.m_237113_((String)"Authentication successful!").m_130938_(style -> style.m_178520_(65280)));
                    controller.setAuthenticated(true);
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)controller, (BlockPos)this.pos);
                } else {
                    String message;
                    int failedAttempts = controller.getFailedAttempts();
                    if (controller.isLockedOut()) {
                        long remainingTime = controller.getRemainingLockoutTime() / 20L;
                        message = "Too many failed attempts. Locked for " + remainingTime + " seconds.";
                    } else {
                        message = "Invalid passcode. Attempts: " + failedAttempts + "/3";
                    }
                    player.m_213846_((Component)Component.m_237113_((String)message).m_130938_(style -> style.m_178520_(0xFF0000)));
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

