/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.config.CommonConfig;
import com.modernmissions.entity.SatelliteEntity;
import com.modernmissions.init.ModItems;
import com.modernmissions.orbital.StrikeType;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class C2SOrbitalStrikeRequestPacket {
    public final int x;
    public final int z;
    public final int radius;
    public final StrikeType type;

    public C2SOrbitalStrikeRequestPacket(int x, int z, int radius, StrikeType type) {
        this.x = x;
        this.z = z;
        this.radius = radius;
        this.type = type == null ? StrikeType.CINEMATIC_BOMBARDMENT : type;
    }

    public static void encode(C2SOrbitalStrikeRequestPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.x);
        buf.writeInt(msg.z);
        buf.writeInt(msg.radius);
        buf.m_130130_(msg.type.ordinal());
    }

    public static C2SOrbitalStrikeRequestPacket decode(FriendlyByteBuf buf) {
        int x = buf.readInt();
        int z = buf.readInt();
        int r = buf.readInt();
        int ord = buf.m_130242_();
        StrikeType type = StrikeType.values()[Math.max(0, Math.min(StrikeType.values().length - 1, ord))];
        return new C2SOrbitalStrikeRequestPacket(x, z, r, type);
    }

    public static void handle(C2SOrbitalStrikeRequestPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            boolean hasSignalMatrix = false;
            int signalMatrixSlot = -1;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.SIGNAL_MATRIX.get())) continue;
                hasSignalMatrix = true;
                signalMatrixSlot = i;
                break;
            }
            if (!player.m_7500_() && !hasSignalMatrix) {
                player.m_5661_((Component)Component.m_237113_((String)"Signal Matrix required for orbital strike!").m_130940_(ChatFormatting.RED), true);
                return;
            }
            int clampedRadius = Math.max(4, Math.min((Integer)CommonConfig.MAX_RADIUS.get(), pkt.radius));
            ServerLevel level = player.m_284548_();
            if (level.m_46472_() != Level.f_46428_) {
                player.m_5661_((Component)Component.m_237113_((String)"Orbital strike unavailable in this dimension."), false);
                return;
            }
            Item transmitter = (Item)ModItems.SATELLITE_TRANSMITTER.get();
            if (player.m_36335_().m_41519_(transmitter)) {
                player.m_5661_((Component)Component.m_237113_((String)"Transmitter cooling down..."), true);
                return;
            }
            if (!player.m_7500_() && signalMatrixSlot != -1) {
                ItemStack stack = player.m_150109_().m_8020_(signalMatrixSlot);
                stack.m_41774_(1);
                player.m_150109_().m_6596_();
            }
            SatelliteEntity satellite = new SatelliteEntity((Level)level, pkt.x, pkt.z, clampedRadius, (Player)player);
            level.m_7967_((Entity)satellite);
            player.m_36335_().m_41524_(transmitter, ((Integer)CommonConfig.PLAYER_COOLDOWN_TICKS.get()).intValue());
            player.m_5661_((Component)Component.m_237113_((String)"Orbital bombardment confirmed. Impact in T-7 seconds."), true);
            if (!player.m_7500_()) {
                player.m_5661_((Component)Component.m_237113_((String)"Signal Matrix consumed.").m_130940_(ChatFormatting.GRAY), false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

