/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.network.packet;

import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SToggleReactorPacket {
    private final BlockPos pos;
    private final boolean turnOn;

    public C2SToggleReactorPacket(BlockPos pos, boolean turnOn) {
        this.pos = pos;
        this.turnOn = turnOn;
    }

    public static void encode(C2SToggleReactorPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeBoolean(msg.turnOn);
    }

    public static C2SToggleReactorPacket decode(FriendlyByteBuf buf) {
        return new C2SToggleReactorPacket(buf.m_130135_(), buf.readBoolean());
    }

    public static void handle(C2SToggleReactorPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity be;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (be = player.m_9236_().m_7702_(msg.pos)) instanceof NuclearControllerBlockEntity) {
                NuclearControllerBlockEntity controller = (NuclearControllerBlockEntity)be;
                if (msg.turnOn) {
                    controller.attemptReactorStart((Player)player);
                } else {
                    controller.shutdownReactor((Player)player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

