/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.orbital;

import com.modernmissions.config.CommonConfig;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.S2CCameraShakePacket;
import com.modernmissions.orbital.StrikeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="modern_missions")
public class OrbitalStrikeManager {
    private static final List<PendingStrike> PENDING = new ArrayList<PendingStrike>();
    private static final int COUNTDOWN_TICKS = 40;
    private static final int BARRAGE_STAGES = 3;

    public static void requestStrike(ServerLevel level, int x, int z, int radius, StrikeType type, ServerPlayer requester) {
        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        BlockPos targetPos = new BlockPos(x, y, z);
        PendingStrike strike = new PendingStrike((ResourceKey<Level>)level.m_46472_(), targetPos, Math.max(4, Math.min(16, radius)), requester);
        PENDING.add(strike);
        level.m_6263_(null, (double)x, (double)y, (double)z, SoundEvents.f_11736_, SoundSource.MASTER, 2.0f, 0.5f);
        level.m_6263_(null, (double)x, (double)y, (double)z, SoundEvents.f_11739_, SoundSource.MASTER, 1.5f, 1.2f);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || PENDING.isEmpty()) {
            return;
        }
        MinecraftServer server = event.getServer();
        Iterator<PendingStrike> it = PENDING.iterator();
        while (it.hasNext()) {
            PendingStrike strike = it.next();
            ServerLevel level = server.m_129880_(strike.dimension);
            if (level == null) {
                it.remove();
                continue;
            }
            --strike.ticks;
            if (strike.ticks > 0) {
                OrbitalStrikeManager.renderPreStrikeEffects(level, strike);
            }
            if (strike.ticks == 0) {
                OrbitalStrikeManager.executeMainStrike(level, strike, server);
            }
            if (strike.ticks < 0 && strike.ticks > -30) {
                int stage = Math.abs(strike.ticks / 10);
                if (strike.ticks % 10 == 0 && stage > 0) {
                    OrbitalStrikeManager.executeBarrageWave(level, strike, stage);
                }
            }
            if (strike.ticks > -50) continue;
            it.remove();
        }
    }

    private static void renderPreStrikeEffects(ServerLevel level, PendingStrike strike) {
        BlockPos pos = strike.pos;
        if (strike.ticks <= 20 && strike.ticks % 4 == 0) {
            float pitch = 2.0f - (float)strike.ticks / 20.0f;
            level.m_5594_(null, pos, SoundEvents.f_11886_, SoundSource.MASTER, 3.0f * (1.0f - (float)strike.ticks / 20.0f), pitch);
        }
        if (strike.ticks <= 10 && strike.ticks % 2 == 0) {
            double yStart = pos.m_123342_() + 50 + strike.ticks * 5;
            double yEnd = pos.m_123342_() + 10 + strike.ticks * 3;
            for (double y = yStart; y > yEnd; y -= 2.0) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5, y, (double)pos.m_123343_() + 0.5, 2, 0.05, 0.0, 0.05, 0.01);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, y + 1.0, (double)pos.m_123343_() + 0.5, 1, 0.1, 0.0, 0.1, 0.02);
            }
        }
        if (strike.ticks <= 5) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, (double)strike.radius * 0.2, 0.1, (double)strike.radius * 0.2, 0.01);
        }
    }

    private static void executeMainStrike(ServerLevel level, PendingStrike strike, MinecraftServer server) {
        int i;
        BlockPos pos = strike.pos;
        ServerPlayer source = strike.requesterId != null ? server.m_6846_().m_11259_(strike.requesterId) : null;
        float shakeIntensity = 8.0f + (float)strike.radius * 0.5f;
        float shakeDistance = 150.0f + (float)strike.radius * 10.0f;
        int shakeDuration = 40;
        S2CCameraShakePacket shakePacket = new S2CCameraShakePacket(pos, shakeIntensity, shakeDistance, shakeDuration);
        ModNetworking.sendCameraShakeToNearbyPlayers(shakePacket, level, pos, shakeDistance);
        float impactPower = (float)((Double)CommonConfig.ORBITAL_STRIKE_BASE_POWER.get() + (double)strike.radius * (Double)CommonConfig.ORBITAL_STRIKE_POWER_MULTIPLIER.get());
        impactPower = Math.min(impactPower, 50.0f);
        Level.ExplosionInteraction interaction = Level.ExplosionInteraction.BLOCK;
        level.m_255391_((Entity)source, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, impactPower, true, interaction);
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.MASTER, 5.0f, 0.3f);
        level.m_5594_(null, pos, SoundEvents.f_11668_, SoundSource.MASTER, 4.0f, 0.5f);
        for (i = 0; i < 400; ++i) {
            double ox = (level.f_46441_.m_188500_() - 0.5) * (double)strike.radius * 2.0;
            double oy = level.f_46441_.m_188500_() * (double)strike.radius * 3.0;
            double oz = (level.f_46441_.m_188500_() - 0.5) * (double)strike.radius * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123778_, (double)pos.m_123341_() + 0.5 + ox, (double)(pos.m_123342_() + 1) + oy, (double)pos.m_123343_() + 0.5 + oz, 1, 0.1, 0.2, 0.1, 0.02);
            if (i % 2 == 0) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5 + ox, (double)pos.m_123342_() + oy, (double)pos.m_123343_() + 0.5 + oz, 1, 0.2, 0.1, 0.2, 0.01);
            }
            if (i % 3 != 0) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123783_, (double)pos.m_123341_() + 0.5 + ox * 1.5, (double)pos.m_123342_() + oy * 0.5, (double)pos.m_123343_() + 0.5 + oz * 1.5, 1, 0.3, 0.1, 0.3, 0.05);
        }
        for (i = 0; i < 50; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double distance = (double)strike.radius * (0.5 + level.f_46441_.m_188500_());
            double height = level.f_46441_.m_188500_() * 10.0;
            double rx = Math.cos(angle) * distance;
            double rz = Math.sin(angle) * distance;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + 0.5 + rx, (double)pos.m_123342_() + height, (double)pos.m_123343_() + 0.5 + rz, 1, 0.2, 0.3, 0.2, 0.1);
        }
        for (int ring = 1; ring <= 3; ++ring) {
            double ringRadius = strike.radius * ring;
            int particlesInRing = 20 * ring;
            double angleStep = Math.PI * 2 / (double)particlesInRing;
            for (int i2 = 0; i2 < particlesInRing; ++i2) {
                double angle = angleStep * (double)i2;
                double rx = Math.cos(angle) * ringRadius;
                double rz = Math.sin(angle) * ringRadius;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5 + rx, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + rz, 1, 0.0, 0.1, 0.0, 0.02);
            }
        }
    }

    private static void executeBarrageWave(ServerLevel level, PendingStrike strike, int waveNumber) {
        ServerPlayer source = strike.requesterId != null ? level.m_7654_().m_6846_().m_11259_(strike.requesterId) : null;
        int debrisImpacts = Math.min(2, waveNumber);
        for (int i = 0; i < debrisImpacts; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double distance = (double)strike.radius * (0.5 + level.f_46441_.m_188500_() * (double)waveNumber * 0.3);
            int dx = (int)(Math.cos(angle) * distance);
            int dz = (int)(Math.sin(angle) * distance);
            BlockPos impactPos = strike.pos.m_7918_(dx, 0, dz);
            int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, impactPos.m_123341_(), impactPos.m_123343_());
            impactPos = new BlockPos(impactPos.m_123341_(), y, impactPos.m_123343_());
            float shakeIntensity = 3.0f + (float)strike.radius * 0.2f;
            float shakeDistance = 100.0f + (float)strike.radius * 5.0f;
            int shakeDuration = 15;
            S2CCameraShakePacket shakePacket = new S2CCameraShakePacket(impactPos, shakeIntensity, shakeDistance, shakeDuration);
            ModNetworking.sendCameraShakeToNearbyPlayers(shakePacket, level, impactPos, shakeDistance);
            float mainPower = (float)((Double)CommonConfig.ORBITAL_STRIKE_BASE_POWER.get() + (double)strike.radius * (Double)CommonConfig.ORBITAL_STRIKE_POWER_MULTIPLIER.get());
            float power = mainPower * ((Double)CommonConfig.BARRAGE_POWER_MULTIPLIER.get()).floatValue();
            power = Math.min(power, 20.0f);
            Level.ExplosionInteraction interaction = Level.ExplosionInteraction.BLOCK;
            level.m_255391_((Entity)source, (double)impactPos.m_123341_() + 0.5, (double)impactPos.m_123342_() + 0.5, (double)impactPos.m_123343_() + 0.5, power, true, interaction);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)impactPos.m_123341_() + 0.5, (double)impactPos.m_123342_() + 0.5, (double)impactPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            for (int j = 0; j < 15; ++j) {
                double oy = level.f_46441_.m_188500_() * 3.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)impactPos.m_123341_() + 0.5, (double)impactPos.m_123342_() + oy, (double)impactPos.m_123343_() + 0.5, 1, 0.3, 0.1, 0.3, 0.01);
            }
        }
        level.m_5594_(null, strike.pos, SoundEvents.f_11930_, SoundSource.MASTER, 3.0f, 0.6f);
    }

    private static class PendingStrike {
        final ResourceKey<Level> dimension;
        final BlockPos pos;
        final int radius;
        final UUID requesterId;
        int ticks;

        PendingStrike(ResourceKey<Level> dimension, BlockPos pos, int radius, ServerPlayer requester) {
            this.dimension = dimension;
            this.pos = pos;
            this.radius = radius;
            this.requesterId = requester != null ? requester.m_20148_() : null;
            this.ticks = 40;
        }
    }
}

