/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.util;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.NuclearReactorScreenBlock;
import com.modernmissions.block.ReactorCoolantPortBlock;
import com.modernmissions.block.ReactorFuelPortBlock;
import com.modernmissions.block.ReactorMonitorBlock;
import com.modernmissions.init.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ReactorMultiblock {
    public static boolean isFormed(Level level, BlockPos controllerPos, Direction controllerFacing) {
        return ReactorMultiblock.isFormedWithDebug(level, controllerPos, controllerFacing, null);
    }

    public static boolean isFormedWithDebug(Level level, BlockPos controllerPos, Direction controllerFacing, Player player) {
        BlockPos[] backCasings;
        BlockPos[] middleCasings;
        BlockPos[] frontCasings;
        Direction right = controllerFacing.m_122427_();
        Direction left = controllerFacing.m_122428_();
        Direction back = controllerFacing.m_122424_();
        Direction front = controllerFacing;
        boolean debug = player != null;
        BlockPos monitorPos = controllerPos.m_121945_(right);
        if (!ReactorMultiblock.checkBlock(level, monitorPos, (Block)ModBlocks.REACTOR_MONITOR.get())) {
            if (debug) {
                BlockState actualBlock = level.m_8055_(monitorPos);
                player.m_213846_((Component)Component.m_237113_((String)("Expected Reactor Monitor at " + ReactorMultiblock.formatPos(monitorPos) + " but found: " + actualBlock.m_60734_())).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        BlockPos screenPos = controllerPos.m_121945_(left);
        if (!ReactorMultiblock.checkBlock(level, screenPos, (Block)ModBlocks.NUCLEAR_REACTOR_SCREEN.get())) {
            if (debug) {
                BlockState actualBlock = level.m_8055_(screenPos);
                player.m_213846_((Component)Component.m_237113_((String)("Expected Nuclear Reactor Screen at " + ReactorMultiblock.formatPos(screenPos) + " but found: " + actualBlock.m_60734_())).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        BlockPos lubTankPos = controllerPos.m_7494_();
        if (!ReactorMultiblock.checkBlock(level, lubTankPos, (Block)ModBlocks.REACTOR_LUBRICANT_TANK.get())) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Lubricant Tank at " + ReactorMultiblock.formatPos(lubTankPos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        for (BlockPos pos : frontCasings = new BlockPos[]{controllerPos.m_7495_(), controllerPos.m_7494_().m_121945_(left), controllerPos.m_7494_().m_121945_(right), controllerPos.m_7495_().m_121945_(left), controllerPos.m_7495_().m_121945_(right)}) {
            if (ReactorMultiblock.checkBlock(level, pos, (Block)ModBlocks.REACTOR_CASING.get())) continue;
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Casing at " + ReactorMultiblock.formatPos(pos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        BlockPos middleCenter = controllerPos.m_121945_(back);
        BlockPos fuelPos = middleCenter.m_7494_();
        if (!ReactorMultiblock.checkBlock(level, fuelPos, (Block)ModBlocks.REACTOR_FUEL_PORT.get())) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Fuel Port at " + ReactorMultiblock.formatPos(fuelPos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (!ReactorMultiblock.checkFuelPortFacing(level, fuelPos, Direction.UP)) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Fuel Port must face UP at " + ReactorMultiblock.formatPos(fuelPos))).m_130940_(ChatFormatting.YELLOW));
            }
            return false;
        }
        BlockPos coolantPos = middleCenter.m_7495_();
        if (!ReactorMultiblock.checkBlock(level, coolantPos, (Block)ModBlocks.REACTOR_COOLANT_PORT.get())) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Coolant Port at " + ReactorMultiblock.formatPos(coolantPos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (!ReactorMultiblock.checkCoolantPortFacing(level, coolantPos, Direction.DOWN)) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Coolant Port must face DOWN at " + ReactorMultiblock.formatPos(coolantPos))).m_130940_(ChatFormatting.YELLOW));
            }
            return false;
        }
        if (!ReactorMultiblock.checkBlock(level, middleCenter, (Block)ModBlocks.REACTOR_CASING.get())) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Casing at " + ReactorMultiblock.formatPos(middleCenter))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        BlockPos leftMiddlePos = middleCenter.m_121945_(left);
        if (!ReactorMultiblock.checkBlockOrAlternative(level, leftMiddlePos, (Block)ModBlocks.REACTOR_CASING.get(), (Block)ModBlocks.REACTOR_CONTROL_ROD_PORT.get())) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Casing or Control Rod Port at " + ReactorMultiblock.formatPos(leftMiddlePos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        BlockPos rightMiddlePos = middleCenter.m_121945_(right);
        if (!ReactorMultiblock.checkBlockOrAlternative(level, rightMiddlePos, (Block)ModBlocks.REACTOR_CASING.get(), (Block)ModBlocks.REACTOR_CONTROL_ROD_PORT.get())) {
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Casing or Control Rod Port at " + ReactorMultiblock.formatPos(rightMiddlePos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        for (BlockPos pos : middleCasings = new BlockPos[]{middleCenter.m_7494_().m_121945_(left), middleCenter.m_7494_().m_121945_(right), middleCenter.m_7495_().m_121945_(left), middleCenter.m_7495_().m_121945_(right)}) {
            if (ReactorMultiblock.checkBlock(level, pos, (Block)ModBlocks.REACTOR_CASING.get())) continue;
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Casing at " + ReactorMultiblock.formatPos(pos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        BlockPos backCenter = controllerPos.m_5484_(back, 2);
        for (BlockPos pos : backCasings = new BlockPos[]{backCenter, backCenter.m_121945_(left), backCenter.m_121945_(right), backCenter.m_7494_(), backCenter.m_7494_().m_121945_(left), backCenter.m_7494_().m_121945_(right), backCenter.m_7495_(), backCenter.m_7495_().m_121945_(left), backCenter.m_7495_().m_121945_(right)}) {
            if (ReactorMultiblock.checkBlock(level, pos, (Block)ModBlocks.REACTOR_CASING.get())) continue;
            if (debug) {
                player.m_213846_((Component)Component.m_237113_((String)("Missing Casing at " + ReactorMultiblock.formatPos(pos))).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (debug) {
            player.m_213846_((Component)Component.m_237113_((String)"Reactor structure is valid!").m_130940_(ChatFormatting.GREEN));
        }
        return true;
    }

    private static String formatPos(BlockPos pos) {
        return "(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")";
    }

    private static boolean checkBlock(Level level, BlockPos pos, Block expectedBlock) {
        BlockState state = level.m_8055_(pos);
        return state.m_60713_(expectedBlock);
    }

    private static boolean checkBlockOrAlternative(Level level, BlockPos pos, Block primary, Block alternative) {
        BlockState state = level.m_8055_(pos);
        return state.m_60713_(primary) || state.m_60713_(alternative);
    }

    private static boolean checkFuelPortFacing(Level level, BlockPos pos, Direction expectedFacing) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_((Block)ModBlocks.REACTOR_FUEL_PORT.get())) {
            return false;
        }
        if (state.m_61138_((Property)ReactorFuelPortBlock.FACING)) {
            return state.m_61143_((Property)ReactorFuelPortBlock.FACING) == expectedFacing;
        }
        return false;
    }

    private static boolean checkCoolantPortFacing(Level level, BlockPos pos, Direction expectedFacing) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_((Block)ModBlocks.REACTOR_COOLANT_PORT.get())) {
            return false;
        }
        if (state.m_61138_((Property)ReactorCoolantPortBlock.FACING)) {
            return state.m_61143_((Property)ReactorCoolantPortBlock.FACING) == expectedFacing;
        }
        return false;
    }

    public static void activate(Level level, BlockPos controllerPos, Direction controllerFacing) {
        BlockPos coolantPos;
        BlockState coolantState;
        BlockPos monitorPos;
        BlockState monitorState;
        BlockState controllerState = level.m_8055_(controllerPos);
        if (controllerState.m_61138_((Property)NuclearControllerBlock.ACTIVE)) {
            level.m_7731_(controllerPos, (BlockState)controllerState.m_61124_((Property)NuclearControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        }
        level.m_5594_(null, controllerPos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.5f, 0.8f);
        level.m_5594_(null, controllerPos, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 0.7f);
        level.m_5594_(null, controllerPos, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.2f, 1.0f);
        Direction left = controllerFacing.m_122428_();
        Direction right = controllerFacing.m_122427_();
        Direction back = controllerFacing.m_122424_();
        BlockPos screenPos = controllerPos.m_121945_(left);
        BlockState screenState = level.m_8055_(screenPos);
        if (screenState.m_60713_((Block)ModBlocks.NUCLEAR_REACTOR_SCREEN.get()) && screenState.m_61138_(NuclearReactorScreenBlock.STATE)) {
            level.m_7731_(screenPos, (BlockState)screenState.m_61124_(NuclearReactorScreenBlock.STATE, (Comparable)((Object)NuclearReactorScreenBlock.ScreenState.ON)), 3);
        }
        if ((monitorState = level.m_8055_(monitorPos = controllerPos.m_121945_(right))).m_60713_((Block)ModBlocks.REACTOR_MONITOR.get()) && monitorState.m_61138_((Property)ReactorMonitorBlock.MONITOR_STATE)) {
            level.m_7731_(monitorPos, (BlockState)monitorState.m_61124_((Property)ReactorMonitorBlock.MONITOR_STATE, (Comparable)Integer.valueOf(1)), 3);
        }
        if ((coolantState = level.m_8055_(coolantPos = controllerPos.m_121945_(back).m_7495_())).m_60713_((Block)ModBlocks.REACTOR_COOLANT_PORT.get()) && coolantState.m_61138_((Property)ReactorCoolantPortBlock.POWERED)) {
            level.m_7731_(coolantPos, (BlockState)coolantState.m_61124_((Property)ReactorCoolantPortBlock.POWERED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public static void deactivate(Level level, BlockPos controllerPos, Direction controllerFacing) {
        BlockPos coolantPos;
        BlockState coolantState;
        BlockPos monitorPos;
        BlockState monitorState;
        BlockState controllerState = level.m_8055_(controllerPos);
        if (controllerState.m_61138_((Property)NuclearControllerBlock.ACTIVE)) {
            level.m_7731_(controllerPos, (BlockState)controllerState.m_61124_((Property)NuclearControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        }
        level.m_5594_(null, controllerPos, SoundEvents.f_11738_, SoundSource.BLOCKS, 1.2f, 0.9f);
        Direction left = controllerFacing.m_122428_();
        Direction right = controllerFacing.m_122427_();
        Direction back = controllerFacing.m_122424_();
        BlockPos screenPos = controllerPos.m_121945_(left);
        BlockState screenState = level.m_8055_(screenPos);
        if (screenState.m_60713_((Block)ModBlocks.NUCLEAR_REACTOR_SCREEN.get()) && screenState.m_61138_(NuclearReactorScreenBlock.STATE)) {
            level.m_7731_(screenPos, (BlockState)screenState.m_61124_(NuclearReactorScreenBlock.STATE, (Comparable)((Object)NuclearReactorScreenBlock.ScreenState.OFF)), 3);
        }
        if ((monitorState = level.m_8055_(monitorPos = controllerPos.m_121945_(right))).m_60713_((Block)ModBlocks.REACTOR_MONITOR.get()) && monitorState.m_61138_((Property)ReactorMonitorBlock.MONITOR_STATE)) {
            level.m_7731_(monitorPos, (BlockState)monitorState.m_61124_((Property)ReactorMonitorBlock.MONITOR_STATE, (Comparable)Integer.valueOf(3)), 3);
        }
        if ((coolantState = level.m_8055_(coolantPos = controllerPos.m_121945_(back).m_7495_())).m_60713_((Block)ModBlocks.REACTOR_COOLANT_PORT.get()) && coolantState.m_61138_((Property)ReactorCoolantPortBlock.POWERED)) {
            level.m_7731_(coolantPos, (BlockState)coolantState.m_61124_((Property)ReactorCoolantPortBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

