/*
 * Decompiled with CFR 0.152.
 */
package io.github.densamisten.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FireworkCommand {
    public FireworkCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"firework").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> FireworkCommand.execute((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), 1, 0xFFFFFF, 1, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"shape", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).then(Commands.m_82129_((String)"colors", (ArgumentType)IntegerArgumentType.integer((int)0, (int)0xFFFFFF)).then(Commands.m_82129_((String)"flight", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(context -> FireworkCommand.execute((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), IntegerArgumentType.getInteger((CommandContext)context, (String)"shape"), IntegerArgumentType.getInteger((CommandContext)context, (String)"colors"), IntegerArgumentType.getInteger((CommandContext)context, (String)"flight"))))))))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"shape", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).then(Commands.m_82129_((String)"colors", (ArgumentType)IntegerArgumentType.integer((int)0, (int)0xFFFFFF)).then(Commands.m_82129_((String)"flight", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(context -> FireworkCommand.executeFromEntities((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), IntegerArgumentType.getInteger((CommandContext)context, (String)"shape"), IntegerArgumentType.getInteger((CommandContext)context, (String)"colors"), IntegerArgumentType.getInteger((CommandContext)context, (String)"flight"))))))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, BlockPos pos, int count, int shape, int colors, int flight) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        for (int i = 0; i < count; ++i) {
            double offsetX = (new Random().nextDouble() - 0.5) * 5.0;
            double offsetY = (new Random().nextDouble() - 0.5) * 5.0;
            double offsetZ = (new Random().nextDouble() - 0.5) * 5.0;
            ItemStack fireworkStar = FireworkCommand.createFireworkStar(shape, colors, flight);
            FireworkRocketEntity firework = new FireworkRocketEntity((Level)level, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.5 + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, fireworkStar);
            firework.m_20256_(firework.m_20184_().m_82520_(0.0, 0.05, 0.0));
            level.m_7967_((Entity)firework);
        }
        return 1;
    }

    private static int executeFromEntities(CommandContext<CommandSourceStack> context, Iterable<? extends Entity> targets, int count, int shape, int colors, int flight) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        for (Entity entity : targets) {
            for (int i = 0; i < count; ++i) {
                double offsetX = (new Random().nextDouble() - 0.5) * 5.0;
                double offsetY = (new Random().nextDouble() - 0.5) * 5.0;
                double offsetZ = (new Random().nextDouble() - 0.5) * 5.0;
                ItemStack fireworkStar = FireworkCommand.createFireworkStar(shape, colors, flight);
                FireworkRocketEntity firework = new FireworkRocketEntity((Level)level, entity.m_20185_() + 0.5 + offsetX, entity.m_20186_() + (double)entity.m_20206_() + 0.5 + offsetY, entity.m_20189_() + 0.5 + offsetZ, fireworkStar);
                level.m_7967_((Entity)firework);
            }
        }
        return 1;
    }

    private static ItemStack createFireworkStar(int shape, int colors, int flight) {
        ItemStack fireworkStar = new ItemStack((ItemLike)Items.f_42688_.m_5456_());
        CompoundTag fireworksNBT = new CompoundTag();
        ListTag explosionsList = new ListTag();
        CompoundTag explosionTag = FireworkCommand.getCompoundTag(shape);
        explosionTag.m_128385_("Colors", new int[]{colors});
        explosionTag.m_128385_("FadeColors", new int[]{0xFFFFFF});
        explosionsList.add((Object)explosionTag);
        fireworksNBT.m_128365_("Explosions", (Tag)explosionsList);
        fireworkStar.m_41700_("Fireworks", (Tag)fireworksNBT);
        CompoundTag fireworkItemNBT = fireworkStar.m_41698_("Fireworks");
        fireworkItemNBT.m_128405_("Flight", flight);
        return fireworkStar;
    }

    @NotNull
    private static CompoundTag getCompoundTag(int shape) {
        CompoundTag explosionTag = new CompoundTag();
        switch (shape) {
            case 1: {
                explosionTag.m_128405_("Type", 1);
                break;
            }
            case 2: {
                explosionTag.m_128405_("Type", 2);
                break;
            }
            default: {
                explosionTag.m_128405_("Type", 0);
            }
        }
        explosionTag.m_128379_("Flicker", true);
        explosionTag.m_128379_("Trail", true);
        return explosionTag;
    }
}

