/*
 * Decompiled with CFR 0.152.
 */
package net.daobin.daoeller;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.daobin.daoeller.init.DaoellerModBlocks;
import net.daobin.daoeller.init.DaoellerModEntities;
import net.daobin.daoeller.init.DaoellerModItems;
import net.daobin.daoeller.init.DaoellerModMobEffects;
import net.daobin.daoeller.init.DaoellerModParticleTypes;
import net.daobin.daoeller.init.DaoellerModPotions;
import net.daobin.daoeller.init.DaoellerModSounds;
import net.daobin.daoeller.init.DaoellerModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="daoeller")
public class DaoellerMod {
    public static final Logger LOGGER = LogManager.getLogger(DaoellerMod.class);
    public static final String MODID = "daoeller";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("daoeller", "daoeller"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public DaoellerMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DaoellerModSounds.REGISTRY.register(bus);
        DaoellerModBlocks.REGISTRY.register(bus);
        DaoellerModItems.REGISTRY.register(bus);
        DaoellerModEntities.REGISTRY.register(bus);
        DaoellerModTabs.REGISTRY.register(bus);
        DaoellerModMobEffects.REGISTRY.register(bus);
        DaoellerModPotions.REGISTRY.register(bus);
        DaoellerModParticleTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

