/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.wanmine.wab.block.entity.SuspiciousIceEntity;

public class SuspiciousIce
extends BrushableBlock {
    public static final MapCodec<BrushableBlock> CODEC = SuspiciousIce.simpleCodec(SuspiciousIce::new);

    public SuspiciousIce(BlockBehaviour.Properties properties) {
        super(Blocks.PACKED_ICE, SoundEvents.GLASS_HIT, SoundEvents.GLASS_BREAK, properties);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SuspiciousIceEntity) {
            SuspiciousIceEntity entity = (SuspiciousIceEntity)blockEntity;
            entity.checkReset();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SuspiciousIceEntity(pos, state);
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity entity) {
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource source) {
    }

    public MapCodec<BrushableBlock> codec() {
        return CODEC;
    }
}

