/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabServerConfig;
import net.wanmine.wab.entity.goals.crusher.CrusherIdleGoal;
import net.wanmine.wab.entity.goals.crusher.CrusherMeleeAttackGoal;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Crusher
extends Animal
implements GeoEntity,
NeutralMob {
    public static final String ID = "crusher";
    public static final String SPAWN_EGG_ID = "crusher_spawn_egg";
    public static final EntityDataAccessor<Boolean> IS_IDLE2 = SynchedEntityData.defineId(Crusher.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> STATE_ATTACK = SynchedEntityData.defineId(Crusher.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> HIT_SPIKE = SynchedEntityData.defineId(Crusher.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Long> LAST_DROP_SPIKE = SynchedEntityData.defineId(Crusher.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final RawAnimation IDLE2 = RawAnimation.begin().thenPlay("misc.idle2");
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int ticksLeft = -20;
    private final HashMap<LivingEntity, Integer> hasDamage = new HashMap();

    public Crusher(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)WabServerConfig.CRUSHER_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)WabServerConfig.CRUSHER_DAMAGE.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)WabServerConfig.CRUSHER_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)WabServerConfig.CRUSHER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.setHealth(((Double)WabServerConfig.CRUSHER_HEALTH.get()).floatValue());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.7).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR_TOUGHNESS, 4.0).add(Attributes.ARMOR, 20.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_IDLE2, (Object)false);
        builder.define(STATE_ATTACK, (Object)0);
        builder.define(HIT_SPIKE, (Object)-1);
        builder.define(LAST_DROP_SPIKE, (Object)-1L);
    }

    public static boolean canSpawn(EntityType<? extends Crusher> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Crusher.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.HANGING_ROOTS);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CrusherMeleeAttackGoal(this, 0.6, false));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.4));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.4, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.HANGING_ROOTS}), false));
        this.goalSelector.addGoal(4, (Goal)new CrusherIdleGoal(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)WabEntities.CRUSHER.get()).create((Level)level);
    }

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.getItem() == WabItems.CHISEL.get() && this.level().getGameTime() - 6000L > (Long)this.entityData.get(LAST_DROP_SPIKE)) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            itemstack.hurtAndBreak(1, (LivingEntity)pPlayer, pHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            ItemStack spike = new ItemStack((ItemLike)WabBlocks.CRUSHER_SPIKE.get());
            ItemEntity itementity = new ItemEntity(this.level(), this.position().x(), this.position().y() + 1.0, this.position().z(), spike);
            itementity.setDefaultPickUpDelay();
            this.level().addFreshEntity((Entity)itementity);
            this.setHitSpike(pPlayer);
            this.entityData.set(LAST_DROP_SPIKE, (Object)this.level().getGameTime());
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.CRUSHER_EGG.get())).asItem());
        ItemEntity itementity = new ItemEntity((Level)level, this.position().x(), this.position().y(), this.position().z(), itemstack);
        itementity.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        level.addFreshEntity((Entity)itementity);
    }

    protected float getKnockback(Entity attacker, DamageSource damageSource) {
        return (float)((double)super.getKnockback(attacker, damageSource) + (this.getStateAttack() == StateAttack.ATTACK_KNOCKBACK ? 1.0 : 0.0));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.is(DamageTypeTags.IS_PROJECTILE)) {
            return false;
        }
        Entity entity = pSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.hurt(entity2.damageSources().mobAttack(entity2), 5.0f);
        }
        return super.hurt(pSource, pAmount);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            if (this.isIdle2()) {
                this.setDeltaMovement(0.0, 0.0, 0.0);
            }
            this.ticksLeft = Math.max(this.ticksLeft - 1, -20);
            if (this.ticksLeft > 0 && this.isAlive()) {
                LivingEntity target = this.getTarget();
                StateAttack state = this.getStateAttack();
                if (state == StateAttack.ATTACK_AREA && state.isHitTick(state.getDuration() - (this.ticksLeft + 1))) {
                    try {
                        for (LivingEntity l : this.hasDamage.keySet()) {
                            int tick = this.hasDamage.get(l);
                            if (tick > 0) {
                                this.hasDamage.put(l, this.hasDamage.get(l) - 1);
                                continue;
                            }
                            this.hasDamage.remove(l);
                        }
                        for (LivingEntity target2 : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.5, 2.0, 0.5))) {
                            if (target2 instanceof Crusher || this.hasDamage.containsKey(target2)) continue;
                            this.swing(InteractionHand.MAIN_HAND);
                            this.doHurtTarget((Entity)target2);
                            this.hasDamage.put(target2, 15);
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                } else if (target != null && target.isAlive() && this.isWithinMeleeAttackRange(target) && state.isHitTick(state.getDuration() - (this.ticksLeft + 1)) && !this.hasDamage.containsKey(target)) {
                    this.swing(InteractionHand.MAIN_HAND);
                    this.doHurtTarget((Entity)target);
                    this.hasDamage.put(target, Integer.MAX_VALUE);
                }
            } else if (this.ticksLeft == 0) {
                this.hasDamage.clear();
                this.setStateAttack(StateAttack.NONE);
                Player player = this.hitSpike();
                this.setHitSpike(null);
                if (player != null && !player.isCreative() && !player.isSpectator()) {
                    this.setTarget((LivingEntity)player);
                }
            } else if (this.hitSpike() != null) {
                this.setStateAttack(StateAttack.ATTACK_AREA);
                this.ticksLeft = StateAttack.ATTACK_AREA.getDuration();
            }
        }
    }

    public void setHitSpike(Player player) {
        this.entityData.set(HIT_SPIKE, (Object)(player == null ? -1 : player.getId()));
    }

    public Player hitSpike() {
        int id = (Integer)this.entityData.get(HIT_SPIKE);
        return id == -1 ? null : (Player)this.level().getEntity(((Integer)this.entityData.get(HIT_SPIKE)).intValue());
    }

    public void setIdle2(boolean hitSpike) {
        this.entityData.set(IS_IDLE2, (Object)hitSpike);
    }

    public boolean isIdle2() {
        return (Boolean)this.entityData.get(IS_IDLE2);
    }

    public StateAttack getStateAttack() {
        StateAttack[] states = StateAttack.values();
        return states[Mth.clamp((int)((Integer)this.entityData.get(STATE_ATTACK)), (int)0, (int)(states.length - 1))];
    }

    public void setStateAttack(StateAttack state) {
        this.entityData.set(STATE_ATTACK, (Object)state.ordinal());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(Crusher.baby(this));
        controller.add(Crusher.idle(this));
        controller.add(Crusher.attack(this));
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.isBaby()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.CONTINUE;
        });
    }

    private static AnimationController<Crusher> idle(Crusher crusher) {
        return new AnimationController((GeoAnimatable)crusher, "idle", 1, state -> {
            if (crusher.isIdle2()) {
                return state.setAndContinue(IDLE2);
            }
            return state.setAndContinue(crusher.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
        });
    }

    private static AnimationController<Crusher> attack(Crusher crusher) {
        return new AnimationController((GeoAnimatable)crusher, "attack", 1, state -> {
            if (crusher.getStateAttack() != StateAttack.NONE) {
                return state.setAndContinue(crusher.getStateAttack().getAnimation());
            }
            state.getController().forceAnimationReset();
            return PlayState.CONTINUE;
        });
    }

    public boolean isMoving() {
        return this.getDeltaMovement().x != 0.0 || this.getDeltaMovement().z != 0.0;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.CRUSHER_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)WabSounds.CRUSHER_IDLE.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int p_21673_) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_21672_) {
    }

    public void startPersistentAngerTimer() {
    }

    public static enum StateAttack {
        NONE(null, 0, 0, 0),
        ATTACK(RawAnimation.begin().thenPlay("attack.attack"), 16, 9, 11),
        ATTACK_KNOCKBACK(RawAnimation.begin().thenPlay("attack.attack knockback"), 18, 10, 13),
        ATTACK_AREA(RawAnimation.begin().thenPlay("attack.attack area"), 73, 6, 65);

        private final RawAnimation animation;
        private final int duration;
        private final int hitTickStart;
        private final int hitTickStop;

        private StateAttack(RawAnimation animation, int duration, int hitTickStart, int hitTickStop) {
            this.animation = animation;
            this.duration = duration;
            this.hitTickStart = hitTickStart;
            this.hitTickStop = hitTickStop;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public int getDuration() {
            return this.duration;
        }

        public boolean isHitTick(int tick) {
            return tick >= this.hitTickStart && tick <= this.hitTickStop;
        }
    }
}

