/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabServerConfig;
import net.wanmine.wab.entity.Toxlacanth;
import net.wanmine.wab.entity.goals.soarer.SoarerMeleeAttackGoal;
import net.wanmine.wab.entity.inventory.SoarerInventoryMenu;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.soarer.SoarerHead;
import net.wanmine.wab.entity.part.soarer.SoarerNeck;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.network.client.InitSoarerPacket;
import net.wanmine.wab.network.server.SoarerJumpPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Soarer
extends TamableAnimal
implements Saddleable,
PlayerRideableJumping,
HasCustomInventoryScreen,
ContainerListener,
MenuProvider,
FlyingAnimal,
NeutralMob,
GeoEntity {
    public static final String ID = "soarer";
    public static final String SPAWN_EGG_ID = "soarer_spawn_egg";
    public static final int MAX_FLAPS = 15;
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Soarer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.defineId(Soarer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.defineId(Soarer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack.attack");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected SimpleContainer inventory;
    private final WabEntityPart<Soarer>[] subEntities;
    private final SoarerNeck neck = new SoarerNeck(this);
    private final SoarerHead head = new SoarerHead(this);
    private int flaps = 15;
    private int tickLeft = 0;
    public int attackTick = -10;
    private int flapTick = 0;
    private double powerFlap = 0.0;

    public Soarer(EntityType<Soarer> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.neck, this.head};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
        this.createInventory();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)WabServerConfig.SOARER_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)WabServerConfig.SOARER_DAMAGE.get()).doubleValue());
        this.setHealth(((Double)WabServerConfig.SOARER_HEALTH.get()).floatValue());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.11).add(Attributes.FLYING_SPEED, 0.6).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.ATTACK_KNOCKBACK, 0.6);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
        builder.define(IS_ATTACKING, (Object)false);
        builder.define(IS_SADDLED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("flaps", this.flaps);
        if (!this.inventory.getItem(0).isEmpty()) {
            pCompound.put("SaddleItem", this.inventory.getItem(0).save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        ItemStack itemstack;
        super.readAdditionalSaveData(pCompound);
        this.flaps = pCompound.getInt("flaps");
        if (pCompound.contains("SaddleItem", 10) && (itemstack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)pCompound.getCompound("SaddleItem")).orElse(ItemStack.EMPTY)).is(Items.SADDLE)) {
            this.inventory.setItem(0, itemstack);
        }
        this.updateContainerEquipment();
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new InitSoarerPacket(this.getId(), this.getFlaps()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SoarerMeleeAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WabItems.TOXLACANTH.get()}), false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Toxlacanth.class, false, false));
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)WabEntities.SOARER.get()).create((Level)level);
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.SOARER_EGG.get())).asItem());
        ItemEntity itementity = new ItemEntity((Level)level, this.position().x(), this.position().y(), this.position().z(), itemstack);
        itementity.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        level.addFreshEntity((Entity)itementity);
    }

    public boolean isFood(ItemStack stack) {
        return stack.getItem() == WabItems.TOXLACANTH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Soarer.state(this), Soarer.attack(this), Soarer.baby(this)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.isBaby()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Soarer> attack(Soarer entity) {
        return new AnimationController((GeoAnimatable)entity, "attack", 1, state -> {
            if (entity.isAttacking()) {
                return state.setAndContinue(ATTACK);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Soarer> state(Soarer soarer) {
        return new AnimationController((GeoAnimatable)soarer, "state", 1, state -> {
            if (soarer.tickLeft <= 0) {
                if (soarer.flapTick > 0) {
                    soarer.setState(State.FLAP);
                } else if (soarer.isFlying()) {
                    if (soarer.isSprinting()) {
                        soarer.setState(State.DIVE);
                    } else {
                        soarer.setState(State.GLIDE);
                    }
                } else {
                    if (soarer.isAttacking()) {
                        state.getController().forceAnimationReset();
                        return PlayState.STOP;
                    }
                    if (soarer.isMoving()) {
                        soarer.setState(State.WALK);
                    } else {
                        soarer.setState(State.IDLE);
                    }
                }
            }
            return state.setAndContinue(soarer.getState().getAnimation());
        });
    }

    public int getFlaps() {
        return this.flaps;
    }

    public void setFlaps(int flaps) {
        this.flaps = Math.min(15, Math.max(0, flaps));
    }

    public void addFlaps(int flaps) {
        this.setFlaps(this.getFlaps() + flaps);
    }

    public void setAttacking(boolean isAttacking) {
        this.entityData.set(IS_ATTACKING, (Object)isAttacking);
        if (isAttacking) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.SOARER_ATTACK.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(IS_ATTACKING);
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.clamp((int)((Integer)this.entityData.get(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        State oldState = this.getState();
        if (state.isFly() && !oldState.isFly()) {
            state = State.START_FLYING;
        } else if (!state.isFly() && oldState.isFly()) {
            state = State.STOP_FLYING;
        } else if (state == State.DIVE && (oldState == State.GLIDE || oldState == State.FLAP)) {
            state = State.GLIDE_TO_DIVE;
        } else if ((state == State.GLIDE || state == State.FLAP) && oldState == State.DIVE) {
            state = State.DIVE_TO_GLIDE;
        }
        this.tickLeft = state.getDuration();
        this.entityData.set(STATE, (Object)state.ordinal());
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Vec3 currentMotion;
            if (this.getState() == State.FLAP && this.tickLeft == State.FLAP.getDuration() - 8) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.SOARER_FLAP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            } else if (this.getState() == State.START_FLYING && this.tickLeft == State.START_FLYING.getDuration() - 25) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.SOARER_FLAP_START.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            } else if (this.getState() == State.STOP_FLYING && this.tickLeft == State.STOP_FLYING.getDuration()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.SOARER_LANDING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
            this.tickLeft = Math.max(this.tickLeft - 1, 0);
            this.flapTick = Math.max(this.flapTick - 1, 0);
            if (this.flapTick == 16) {
                currentMotion = this.getDeltaMovement();
                this.setDeltaMovement(currentMotion.x, this.powerFlap, currentMotion.z);
            }
            if (this.isInWater()) {
                currentMotion = this.getDeltaMovement();
                this.setDeltaMovement(currentMotion.x, -0.4, currentMotion.z);
            }
            currentMotion = this.getDeltaMovement();
            if (currentMotion.y < 0.0 && this.isFlying()) {
                this.setDeltaMovement(currentMotion.x, currentMotion.y * (this.isSprinting() ? 0.9 : 0.5), currentMotion.z);
            }
        } else {
            this.attackTick = Math.max(this.attackTick - 1, -10);
            LivingEntity target = this.getTarget();
            if (this.attackTick == 12 && target != null && target.isAlive() && this.isAlive()) {
                if (this.isWithinMeleeAttackRange(target)) {
                    this.swing(InteractionHand.MAIN_HAND);
                    this.doHurtTarget((Entity)target);
                }
            } else if (this.attackTick == 0) {
                this.setAttacking(false);
            }
        }
        if (!this.isFlying() && this.level().getGameTime() % 160L == 0L) {
            this.addFlaps(1);
        }
    }

    public void aiStep() {
        super.aiStep();
        for (WabEntityPart<Soarer> part : this.subEntities) {
            part.update();
        }
    }

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (this.isFood(itemstack)) {
            if (!this.isTame() && !this.isBaby()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                if (!this.level().isClientSide) {
                    if (this.random.nextInt(2) == 0) {
                        this.tame(pPlayer);
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.getFlaps() < 15) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.addFlaps(10);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.heal(6.0f);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.isBaby()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.ageUp(Soarer.getSpeedUpSecondsWhenFeeding((int)(-this.getAge())), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        } else {
            if (itemstack.getItem() == Items.PUFFERFISH && !this.isBaby() && !this.isInLove()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.setInLove(pPlayer);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (itemstack.getItem() == Items.SADDLE && !this.isSaddled() && this.isSaddleable()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.equipSaddle(itemstack.copy(), SoundSource.PLAYERS);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (pPlayer.isSecondaryUseActive()) {
            this.openCustomInventoryScreen(pPlayer);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.canAddPassenger((Entity)pPlayer)) {
            if (!this.level().isClientSide) {
                pPlayer.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void openCustomInventoryScreen(Player player) {
        if (!this.level().isClientSide && (!this.isVehicle() || this.hasPassenger((Entity)player)) && this.isTame()) {
            player.openMenu((MenuProvider)this, buf -> buf.writeInt(this.getId()));
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new SoarerInventoryMenu(i, inventory, this);
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (simplecontainer != null) {
            simplecontainer.removeListener((ContainerListener)this);
            int i = Math.min(simplecontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
        this.updateContainerEquipment();
    }

    public SlotAccess getSlot(final int pSlot) {
        int i = pSlot - 400;
        if (i == 0) {
            return new SlotAccess(){

                public ItemStack get() {
                    return Soarer.this.inventory.getItem(pSlot);
                }

                public boolean set(ItemStack itemStack) {
                    if (itemStack.isEmpty() || itemStack.is(Items.SADDLE)) {
                        Soarer.this.inventory.setItem(pSlot, itemStack);
                        Soarer.this.updateContainerEquipment();
                        return true;
                    }
                    return false;
                }
            };
        }
        int j = pSlot - 500 + 1;
        return j > 0 && j < this.inventory.getContainerSize() ? SlotAccess.forContainer((Container)this.inventory, (int)j) : super.getSlot(pSlot);
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        if (!this.isBaby()) {
            super.setTarget(pTarget);
        }
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        return this.distanceToSqr((Entity)entity) < 8.0;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.spawnAtLocation(itemstack);
            }
        }
    }

    public boolean isFlying() {
        return !this.onGround() && this.height() > 4.0;
    }

    public double height() {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.getBlockX(), this.getBlockY(), this.getBlockZ());
        Level level = this.level();
        while (blockPos.getY() > level.getMinBuildHeight() && level.getBlockState((BlockPos)blockPos).isAir()) {
            blockPos.move(0, -1, 0);
        }
        return this.getY() - (double)blockPos.getY();
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        Vec2 vec2 = new Vec2(player.getXRot() * 0.5f, player.getYRot());
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    protected Vec3 getRiddenInput(Player player, Vec3 vec3) {
        if (this.isFlying()) {
            return new Vec3(0.0, 0.0, 1.0);
        }
        if (this.flapTick <= 0) {
            return new Vec3(0.0, 0.0, (double)Math.max(player.zza, 0.0f));
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    protected boolean canAddPassenger(Entity pPassenger) {
        if (pPassenger instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)pPassenger;
            return !this.isBaby() && this.getPassengers().isEmpty() && this.isOwnedBy(passenger);
        }
        return false;
    }

    public LivingEntity getControllingPassenger() {
        return this.getFirstPassenger() == this.getOwner() && this.isSaddled() ? this.getOwner() : null;
    }

    protected void positionRider(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = new Vec3(0.0, 1.3, 0.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        moveFunction.accept(entity, this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
        this.clampRotation(entity);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dim, float p_299886_) {
        return new Vec3(0.0, 1.3, 0.0);
    }

    public void onPassengerTurned(Entity pEntityToUpdate) {
        if (this.getControllingPassenger() != pEntityToUpdate) {
            this.clampRotation(pEntityToUpdate);
        }
    }

    private void clampRotation(Entity pEntity) {
        pEntity.setYBodyRot(this.getYRot());
        float f = pEntity.getYRot();
        float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
        float f2 = Mth.clamp((float)f1, (float)-160.0f, (float)160.0f);
        pEntity.yRotO += f2 - f1;
        float f3 = f + f2 - f1;
        pEntity.setYRot(f3);
        pEntity.setYHeadRot(f3);
    }

    public boolean onClimbable() {
        return false;
    }

    public boolean isImmobile() {
        return super.isImmobile() || this.getControllingPassenger() != null;
    }

    protected float getRiddenSpeed(Player player) {
        if (!this.isFlying()) {
            return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.6f;
        }
        return (float)this.getAttributeValue(Attributes.FLYING_SPEED) + (this.isSprinting() ? 0.4f : 0.0f);
    }

    public boolean isPushable() {
        return !this.isVehicle();
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity pLivingEntity) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() != Direction.Axis.Y) {
            int[][] aint = DismountHelper.offsetsForDirection((Direction)direction);
            BlockPos blockpos = this.blockPosition();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (Pose pose : pLivingEntity.getDismountPoses()) {
                AABB aabb = pLivingEntity.getLocalBoundsForPose(pose);
                for (int[] aint1 : aint) {
                    blockpos$mutableblockpos.set(blockpos.getX() + aint1[0], blockpos.getY(), blockpos.getZ() + aint1[1]);
                    double d0 = this.level().getBlockFloorHeight((BlockPos)blockpos$mutableblockpos);
                    if (!DismountHelper.isBlockFloorValid((double)d0)) continue;
                    Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)blockpos$mutableblockpos, (double)d0);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)pLivingEntity, (AABB)aabb.move(vec3))) continue;
                    pLivingEntity.setPose(pose);
                    return vec3;
                }
            }
        }
        return super.getDismountLocationForPassenger(pLivingEntity);
    }

    protected void updateContainerEquipment() {
        if (!this.level().isClientSide) {
            this.setSaddled(!this.inventory.getItem(0).isEmpty());
        }
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby() && this.isTame();
    }

    public void equipSaddle(ItemStack itemStack, @Nullable SoundSource soundSource) {
        this.inventory.setItem(0, itemStack);
        this.updateContainerEquipment();
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(IS_SADDLED);
    }

    public void setSaddled(boolean isSaddled) {
        this.entityData.set(IS_SADDLED, (Object)isSaddled);
    }

    public boolean canMate(@NotNull Animal pOtherAnimal) {
        if (pOtherAnimal != this && pOtherAnimal instanceof Soarer) {
            Soarer soarer = (Soarer)pOtherAnimal;
            return this.canParent() && soarer.canParent();
        }
        return false;
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && !this.isBaby() && this.isInLove();
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void containerChanged(Container container) {
        boolean flag = this.isSaddled();
        this.updateContainerEquipment();
        if (this.tickCount > 20 && !flag && this.isSaddled()) {
            this.playSound(this.getSaddleSoundEvent(), 0.5f, 1.0f);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void onPlayerJump(int power) {
        if (this.isFlying()) {
            this.powerFlap = 1.5 + Math.pow(this.powerFlap, 2.0) / 1500.0;
            this.flapTick = State.FLAP.getDuration() + (this.getState() == State.DIVE ? State.DIVE_TO_GLIDE.getDuration() : 0);
        } else {
            this.powerFlap = 2.0 + Math.pow(this.powerFlap, 2.0) / 1000.0;
            this.flapTick = State.START_FLYING.getDuration() + 6;
            this.setState(State.START_FLYING);
        }
        this.addFlaps(-1);
        PacketDistributor.sendToServer((CustomPacketPayload)new SoarerJumpPacket(this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    public boolean canSprint() {
        return this.flapTick <= 0 && this.isFlying();
    }

    public boolean isSprinting() {
        return super.isSprinting() || this.getOwner() != null && this.isVehicle() && this.getOwner().isSprinting() && this.canSprint();
    }

    public boolean isMoving() {
        return this.getDeltaMovement().x != 0.0 || this.getDeltaMovement().z != 0.0;
    }

    public boolean canJump() {
        return this.isSaddled() && this.getFlaps() > 0 && !this.isInWater() && !this.isInPowderSnow && !this.isInLava();
    }

    public void handleStartJump(int i) {
    }

    public void handleStopJump() {
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int i) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
    }

    public void startPersistentAngerTimer() {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isFlying()) {
            return this.getState() == State.GLIDE ? (SoundEvent)WabSounds.SOARER_GLIDE.get() : null;
        }
        return (SoundEvent)WabSounds.SOARER_IDLE.get();
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.ground_idle"), false),
        WALK(RawAnimation.begin().thenPlay("move.walk"), false),
        START_FLYING(RawAnimation.begin().thenPlay("move.start_flying"), true, 40),
        GLIDE(RawAnimation.begin().thenPlay("move.glide"), true),
        GLIDE_TO_DIVE(RawAnimation.begin().thenPlay("move.glide_dive_trasition"), true, 18),
        DIVE_TO_GLIDE(RawAnimation.begin().thenPlay("move.dive_glide_transition"), true, 18),
        DIVE(RawAnimation.begin().thenPlay("move.dive"), true),
        FLAP(RawAnimation.begin().thenPlay("move.wing_flap"), true, 28),
        STOP_FLYING(RawAnimation.begin().thenPlay("move.landing"), false, 30);

        private final RawAnimation animation;
        private final boolean isFly;
        private final int duration;

        private State(RawAnimation animation, boolean isFly) {
            this.animation = animation;
            this.isFly = isFly;
            this.duration = 0;
        }

        private State(RawAnimation animation, boolean isFly, int duration) {
            this.animation = animation;
            this.isFly = isFly;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public boolean isFly() {
            return this.isFly;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

