/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabServerConfig;
import net.wanmine.wab.entity.goals.surfer.SurferCheckRelaxingGoal;
import net.wanmine.wab.entity.goals.surfer.SurferPanicGoal;
import net.wanmine.wab.entity.goals.surfer.SurferRandomStrollGoal;
import net.wanmine.wab.entity.goals.surfer.SurferTemptGoal;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.surfer.SurferHead;
import net.wanmine.wab.entity.part.surfer.SurferNeck;
import net.wanmine.wab.event.setup.CommonSetup;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.data.WabTriggers;
import net.wanmine.wab.init.data.trigger.SurferColorTrigger;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.network.client.InitSurferPacket;
import net.wanmine.wab.network.server.SurferJumpPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Surfer
extends AbstractHorse
implements GeoEntity {
    public static final String ID = "surfer";
    public static final String SPAWN_EGG_ID = "surfer_spawn_egg";
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("552E1865-8B10-40B8-8F9D-CF9B4767A895");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Surfer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_ARMOR = SynchedEntityData.defineId(Surfer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_RELAXING = SynchedEntityData.defineId(Surfer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CAN_BE_TAMED = SynchedEntityData.defineId(Surfer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_RUNNING = SynchedEntityData.defineId(Surfer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_JUMPING = SynchedEntityData.defineId(Surfer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> CORAL_COLOR = SynchedEntityData.defineId(Surfer.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int COLOR_START_TO_CHANGE = 32;
    public static final int COLOR_CHANGE = 64;
    public static final float COLOR_CHANGE_PROBABILITY = 0.03f;
    public static final int MIN_RELAXING_TIME = -12000;
    public static final int FRIENDLY_TIME_AFTER_RELAX = -600;
    public static final int OXYGEN_SUPPLY = 1200;
    private String coralColor = "base";
    private int coralEatenCount = 0;
    private String coralColorEating = "base";
    private int relaxedTime = 0;
    private Vec3 approachingPlayerPos = null;
    private boolean approachingPlayer = false;
    private boolean isLandingJump = false;
    private int abortJumpIn = -1;
    private int oxygen = 3600;
    private Vec3 jumpVec = null;
    private final WabEntityPart<Surfer>[] subEntities;
    private final SurferNeck neck = new SurferNeck(this);
    private final SurferHead head = new SurferHead(this);
    private final WabEntityPart<Surfer> tail = new WabEntityPart<Surfer>(this, 1.0f, 0.5f, 1.0f, 0.1f, 180.0f);
    private int tickLeft = 0;

    public Surfer(EntityType<? extends AbstractHorse> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.neck, this.head, this.tail};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 8, 1.0f, 1.0f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)WabServerConfig.SURFER_HEALTH.get()).doubleValue());
        this.setHealth(((Double)WabServerConfig.SURFER_HEALTH.get()).floatValue());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public static boolean checkSpawn(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return CommonSetup.checkAncientAnimalSpawnRules(pAnimal, pLevel, pSpawnType, pPos, pRandom) || pLevel.getFluidState(pPos.below()).is(FluidTags.WATER);
    }

    public boolean checkSpawnObstruction(LevelReader levelReader) {
        return levelReader.isUnobstructed((Entity)this);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.7).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.JUMP_STRENGTH, 0.6).add(Attributes.MOVEMENT_SPEED, 0.1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
        builder.define(HAS_ARMOR, (Object)false);
        builder.define(IS_RELAXING, (Object)false);
        builder.define(CAN_BE_TAMED, (Object)false);
        builder.define(IS_RUNNING, (Object)false);
        builder.define(IS_JUMPING, (Object)false);
        builder.define(CORAL_COLOR, (Object)"base");
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (!this.inventory.getItem(1).isEmpty()) {
            pCompound.put("ArmorItem", this.inventory.getItem(1).save((HolderLookup.Provider)this.registryAccess()));
        }
        pCompound.putString("coralColor", this.coralColor);
        pCompound.putInt("coralEatenCount", this.coralEatenCount);
        pCompound.putString("coralColorEating", this.coralColorEating);
        pCompound.putInt("relaxedTime", this.relaxedTime);
        pCompound.putInt("oxygen", this.oxygen);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        ItemStack itemstack;
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("ArmorItem", 10) && !(itemstack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)pCompound.getCompound("ArmorItem")).orElse(ItemStack.EMPTY)).isEmpty() && this.isBodyArmorItem(itemstack)) {
            this.inventory.setItem(1, itemstack);
        }
        this.coralColor = pCompound.contains("coralColor") ? pCompound.getString("coralColor") : "base";
        this.coralEatenCount = pCompound.getInt("coralEatenCount");
        this.coralColorEating = pCompound.contains("coralColorEating") ? pCompound.getString("coralColorEating") : "base";
        this.relaxedTime = pCompound.getInt("relaxedTime");
        this.oxygen = pCompound.contains("oxygen") ? pCompound.getInt("oxygen") : 3600;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.entityData.set(IS_RELAXING, (Object)(this.relaxedTime > 0 ? 1 : 0));
        this.entityData.set(CAN_BE_TAMED, (Object)(!this.isTamed() && this.relaxedTime > -600 && this.relaxedTime < -State.RELAX_TO_IDLE.duration && !this.approachingPlayer ? 1 : 0));
        this.entityData.set(HAS_ARMOR, (Object)this.isWearingBodyArmor());
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new InitSurferPacket(this.getId(), this.coralColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.SEA_PICKLE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SurferPanicGoal(this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new BreedGoal((Animal)this, 1.0)));
        this.goalSelector.addGoal(3, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SEA_PICKLE}), false)));
        this.goalSelector.addGoal(4, (Goal)new SurferTemptGoal(this, 1.0, Ingredient.of(WabTags.Items.SURFER_FOOD), false));
        this.goalSelector.addGoal(5, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new FollowParentGoal((Animal)this, 1.0)));
        this.goalSelector.addGoal(6, (Goal)new SurferRandomStrollGoal(this, 1.0, 30));
        this.goalSelector.addGoal(7, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f)));
        this.goalSelector.addGoal(8, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new RandomLookAroundGoal((Mob)this)));
    }

    protected PathNavigation createNavigation(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)WabEntities.SURFER.get()).create((Level)level);
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.SURFER_EGG.get())).asItem());
        ItemEntity itementity = new ItemEntity((Level)level, this.position().x(), this.position().y(), this.position().z(), itemstack);
        itementity.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        level.addFreshEntity((Entity)itementity);
    }

    public void travel(Vec3 travelVector) {
        if (this.isJumping()) {
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else if (this.isInWater()) {
            this.moveRelative(this.getWaterSpeed(), travelVector);
            Vec3 currentMotion = this.getDeltaMovement();
            double targetYVelocity = 0.0;
            if (this.getNavigation().isInProgress()) {
                Path path = this.getNavigation().getPath();
                if (path != null && !path.isDone()) {
                    double dy = (double)path.getNextNode().y - this.getY();
                    targetYVelocity = Math.signum(dy) * 0.03;
                }
            } else if (this.random.nextFloat() < 0.5f) {
                targetYVelocity = this.isVehicle() ? -0.002 : 0.005;
            }
            this.setDeltaMovement(currentMotion.x, targetYVelocity + currentMotion.y, currentMotion.z);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public float getWaterSpeed() {
        return this.getSpeed() * 1.8f * (this.isWearingArmor() ? 0.85f : 1.0f) * (this.isSprinting() ? 1.3f : 1.0f);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isRelaxing()) {
            if (!this.level().isClientSide) {
                this.setRelaxingTime(0);
                if (!this.approachingPlayer && !this.isTamed()) {
                    this.entityData.set(CAN_BE_TAMED, (Object)true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive() && this.isTamed()) {
            this.openCustomInventoryScreen(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (!this.level().isClientSide && !this.isBaby() && this.isFood(itemstack) && this.canFallInLove()) {
            this.usePlayerItem(player, hand, itemstack);
            this.setInLove(player);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(WabTags.Items.SURFER_FOOD) && (this.isTamed() || this.canBeTamed() || this.isBaby())) {
            boolean flag = false;
            if (this.getCoralColor().equals("base")) {
                if (!this.level().isClientSide) {
                    if (this.coralEatenCount <= 0) {
                        this.coralColorEating = this.coralToColor(itemstack.getItem());
                        this.coralEatenCount = 1;
                    } else if (this.coralColorEating.equals(this.coralToColor(itemstack.getItem()))) {
                        this.coralEatenCount = Math.min(this.coralEatenCount + 1, 64);
                        if (this.coralEatenCount == 64 || this.coralEatenCount >= 32 && this.random.nextFloat() <= 0.03f) {
                            String color = this.coralToColor(itemstack.getItem());
                            this.setCoralColor(color);
                            ((SurferColorTrigger)((Object)WabTriggers.SURFER_COLOR.get())).trigger((ServerPlayer)player, color);
                        }
                    } else {
                        this.coralEatenCount = Math.max(this.coralEatenCount - 3, 0);
                    }
                }
                flag = true;
            } else if (this.getCoralColor().equals(this.coralToColor(itemstack.getItem()))) {
                flag = true;
            }
            if (flag) {
                if (this.isBaby()) {
                    this.ageUp(Surfer.getSpeedUpSecondsWhenFeeding((int)(-this.getAge())), true);
                } else if (!this.level().isClientSide && !this.isTamed()) {
                    if (this.random.nextInt(5) == 0) {
                        this.tameWithName(player);
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                this.usePlayerItem(player, hand, itemstack);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.isTamed()) {
            if (!itemstack.isEmpty()) {
                InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
                if (interactionresult.consumesAction()) {
                    return interactionresult;
                }
                if (!this.isSaddled() && itemstack.is(Items.SADDLE)) {
                    this.usePlayerItem(player, hand, itemstack);
                    this.equipSaddle(itemstack.copy(), SoundSource.PLAYERS);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (this.isBodyArmorItem(itemstack) && !this.isWearingArmor()) {
                    this.equipBodyArmor(player, itemstack);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
            this.doPlayerRide(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void aiStep() {
        super.aiStep();
        for (WabEntityPart<Surfer> part : this.subEntities) {
            part.update();
        }
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        ItemStack armor;
        if (!this.level().isClientSide && this.isRelaxing()) {
            this.setRelaxingTime(0);
        }
        if (!(armor = this.getBodyArmorItem()).isEmpty()) {
            armor.hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.BODY);
        }
        return super.hurt(damageSource, amount);
    }

    public void playerTouch(Player player) {
        if (!this.level().isClientSide && this.isRelaxing()) {
            this.setRelaxingTime(0);
        }
    }

    public void giveOxygenSupply(Player player) {
        if (player.isInWaterOrBubble() && player.getAirSupply() < 300) {
            if (this.oxygen >= 1200) {
                player.setAirSupply(300);
                this.oxygen -= 1200;
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"key.messages.wan_ancient_beasts.special_ability.not_enough_oxygen"), true);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.tickLeft > 0) {
                --this.tickLeft;
            }
        } else {
            if (this.relaxedTime < -600) {
                this.approachingPlayer = false;
                this.entityData.set(CAN_BE_TAMED, (Object)false);
            }
            if (this.relaxedTime > 0 && !this.isTamed()) {
                for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(12.0, 6.0, 12.0))) {
                    if (player.isCrouching() || player.isCreative() || player.isSpectator()) continue;
                    if (this.approachingPlayerPos != null && (this.approachingPlayerPos.x != player.getX() || this.approachingPlayerPos.z != player.getZ())) {
                        this.setRelaxingTime(0);
                        this.approachingPlayer = true;
                        this.approachingPlayerPos = null;
                    }
                    this.approachingPlayerPos = player.position();
                    break;
                }
            }
            this.oxygen = Math.min(this.oxygen + (this.isInWater() ? 1 : 2), 3600);
            this.setRelaxingTime(Math.max(this.relaxedTime - 1, -12000));
            if ((this.level().isNight() || this.level().isRainingAt(this.blockPosition())) && this.relaxedTime > 0) {
                this.setRelaxingTime(0);
            }
            if (this.abortJumpIn > 0) {
                this.abortJumpIn = Math.max(this.abortJumpIn - 1, 0);
                if (this.abortJumpIn == 0) {
                    this.setIsJumping(false);
                    this.isLandingJump = false;
                    this.jumpVec = null;
                    this.abortJumpIn = -1;
                }
                if (this.isJumping() && !this.isInWaterOrBubble()) {
                    this.jumpVec = this.jumpVec.subtract(new Vec3(0.0, 0.08, 0.0));
                    if (this.jumpVec.y < 0.0) {
                        this.setIsJumping(false);
                        this.isLandingJump = true;
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), WabSounds.SURFER_JUMP_LANDING.get(this.isBaby()), SoundSource.NEUTRAL, this.getSoundVolume() * 0.8f, this.getVoicePitch());
                    }
                } else if (this.isLandingJump) {
                    this.jumpVec = this.jumpVec.subtract(new Vec3(0.0, 0.08, 0.0));
                    if (this.isInWaterOrBubble()) {
                        this.isLandingJump = false;
                        this.jumpVec = null;
                        this.abortJumpIn = -1;
                    }
                }
                if (this.jumpVec != null) {
                    this.setDeltaMovement(this.jumpVec);
                }
            }
        }
    }

    protected float nextStep() {
        if (!this.isInWaterOrAbove()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (this.isRunning() ? WabSounds.SURFER_RUN : WabSounds.SURFER_WALK).get(this.isBaby()), SoundSource.NEUTRAL, this.getSoundVolume() * 0.1f, this.getVoicePitch());
        } else {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getSwimSound(), SoundSource.NEUTRAL, this.getSoundVolume() * 0.08f, this.getVoicePitch());
        }
        return super.nextStep();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(Surfer.baby(this));
        controller.add(Surfer.move(this));
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.isBaby()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Surfer> move(Surfer surfer) {
        return new AnimationController((GeoAnimatable)surfer, "move", 1, state -> {
            if (surfer.tickLeft <= 0) {
                if (surfer.isRelaxing()) {
                    surfer.setState(State.RELAX);
                } else if (surfer.isJumping()) {
                    surfer.setState(State.JUMP);
                } else if (surfer.isInWaterOrAbove() && (!surfer.onGround() || surfer.isInWaterOrBubble())) {
                    if (surfer.isMoving()) {
                        if (surfer.isRunning()) {
                            surfer.setState(State.FAST_SWIM);
                        } else {
                            surfer.setState(State.SWIM);
                        }
                    } else {
                        surfer.setState(State.IDLE_WATER);
                    }
                } else if (surfer.isMoving()) {
                    if (surfer.isRunning()) {
                        surfer.setState(State.RUN);
                    } else {
                        surfer.setState(State.WALK);
                    }
                } else {
                    surfer.setState(State.IDLE);
                }
            }
            return state.setAndContinue(surfer.getState().getAnimation());
        });
    }

    public int distanceFromSurface() {
        int distance = 0;
        while (this.level().isWaterAt(this.blockPosition().above(distance))) {
            ++distance;
        }
        return distance;
    }

    public boolean isMoving() {
        return this.getDeltaMovement().x != 0.0 || this.getDeltaMovement().z != 0.0;
    }

    public boolean isInWaterOrAbove() {
        return this.isInWaterOrBubble() || this.level().isWaterAt(this.blockPosition().below());
    }

    public void setRunning(boolean running) {
        this.entityData.set(IS_RUNNING, (Object)running);
    }

    public boolean isRunning() {
        return this.isSprinting() || (Boolean)this.entityData.get(IS_RUNNING) != false;
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.clamp((int)((Integer)this.entityData.get(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        if (state == State.RELAX && this.getState() != State.RELAX && this.getState() != State.IDLE_TO_RELAX) {
            state = State.IDLE_TO_RELAX;
        } else if (state != State.RELAX && this.getState() == State.RELAX) {
            state = State.RELAX_TO_IDLE;
        } else if (state == State.JUMP && this.getState() != State.JUMP && this.getState() != State.JUMP_START) {
            state = State.JUMP_START;
        } else if (state != State.JUMP && this.getState() == State.JUMP) {
            state = State.JUMP_END;
        }
        this.tickLeft = state.getDuration();
        this.entityData.set(STATE, (Object)state.ordinal());
    }

    protected Vec3 getRiddenInput(Player player, Vec3 vec3) {
        if (this.isInWaterOrBubble()) {
            return new Vec3(0.0, (double)(Math.max(Math.min(player.getXRot() / 2.0f, 25.0f), -25.0f) / -20.0f * Math.max(player.zza, 0.0f)), (double)Math.max(player.zza, 0.0f));
        }
        return new Vec3(0.0, 0.0, (double)Math.max(player.zza, 0.0f));
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.25f * (this.isInWaterOrAbove() ? (this.isSprinting() ? 0.7f : 0.9f) : (this.isSprinting() ? 1.2f : 1.0f));
    }

    protected void positionRider(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = new Vec3(0.0, 0.1, -0.2).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        moveFunction.accept(entity, this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
        this.clampRotation(entity);
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        if (!this.isJumping()) {
            Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
            this.setRot(vec2.y, vec2.x);
            this.yBodyRot = this.yHeadRot = this.getYRot();
            this.yRotO = this.yHeadRot;
            this.setSprinting(player.isSprinting());
        }
    }

    private void clampRotation(Entity pEntity) {
        pEntity.setYBodyRot(this.getYRot());
        float f = pEntity.getYRot();
        float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
        float f2 = Mth.clamp((float)f1, (float)-160.0f, (float)160.0f);
        pEntity.yRotO += f2 - f1;
        float f3 = f + f2 - f1;
        pEntity.setYRot(f3);
        pEntity.setYHeadRot(f3);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isImmobile() {
        return super.isImmobile() || this.isRelaxing();
    }

    public boolean canBeCollidedWith() {
        return this.isRelaxing();
    }

    public boolean isWearingArmor() {
        return (Boolean)this.entityData.get(HAS_ARMOR);
    }

    public boolean isBodyArmorItem(ItemStack itemStack) {
        return itemStack.is((Item)WabItems.SURFER_ARMOR.get());
    }

    public boolean canJump() {
        return super.canJump() && this.isInWaterOrAbove() && !this.isJumping() && this.distanceFromSurface() <= 5;
    }

    public boolean isJumping() {
        return (Boolean)this.entityData.get(IS_JUMPING);
    }

    public void setIsJumping(boolean isJumping) {
        super.setIsJumping(isJumping);
        this.entityData.set(IS_JUMPING, (Object)isJumping);
    }

    public void onPlayerJump(int power) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SurferJumpPacket(this.getId(), power), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void jump(int power) {
        if (this.canJump() && this.abortJumpIn == -1) {
            LivingEntity livingEntity;
            this.setIsJumping(true);
            double radians = Math.toRadians(this.getControllingPassenger().getYRot());
            this.jumpVec = new Vec3(-Math.sin(radians) * (0.15 + (double)power / 200.0), 0.2 + (double)power / 200.0, Math.cos(radians) * (0.15 + (double)power / 200.0));
            this.abortJumpIn = 30;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), WabSounds.SURFER_JUMP_START.get(this.isBaby()), SoundSource.NEUTRAL, this.getSoundVolume() * 0.5f, this.getVoicePitch());
            if (power >= 100 && (livingEntity = this.getControllingPassenger()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                ((PlayerTrigger)WabTriggers.SURFER_MAX_JUMP.get()).trigger(player);
            }
        }
    }

    public boolean canSprint() {
        return true;
    }

    public void setSprinting(boolean sprinting) {
        if (!this.level().isClientSide && !this.isSprinting() && sprinting) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), WabSounds.SURFER_ROAR.get(this.isBaby()), SoundSource.NEUTRAL, this.getSoundVolume(), this.getVoicePitch());
        }
        super.setSprinting(sprinting);
    }

    public void setCustomName(@Nullable Component component) {
        super.setCustomName(component);
        if (!this.level().isClientSide && component.getString().equalsIgnoreCase("silver")) {
            WabTriggers.triggerNearby(WabTriggers.SILVER_SURFER, (Entity)this, 6);
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    public boolean canMate(Animal animal) {
        if (animal instanceof Surfer) {
            Surfer surfer = (Surfer)animal;
            return this != surfer && this.canParent() && surfer.canParent();
        }
        return false;
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && !this.isBaby() && this.isInLove();
    }

    public boolean canEatGrass() {
        return false;
    }

    public boolean isApproachingPlayer() {
        return this.approachingPlayer;
    }

    public String coralToColor(Item item) {
        return ((Registry)this.level().registryAccess().registry(Registries.ITEM).get()).getKey((Object)item).getPath().replace("_coral_fan", "");
    }

    public boolean isRelaxing() {
        return (Boolean)this.entityData.get(IS_RELAXING);
    }

    public boolean isAwake() {
        return this.relaxedTime < -State.RELAX_TO_IDLE.getDuration();
    }

    public void setRelaxingTime(int time) {
        if (time > 0 && this.relaxedTime <= 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), WabSounds.SURFER_IDLE_TO_RELAX.get(this.isBaby()), SoundSource.NEUTRAL, this.getSoundVolume(), this.getVoicePitch());
        } else if (time <= 0 && this.relaxedTime > 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), WabSounds.SURFER_RELAX_TO_IDLE.get(this.isBaby()), SoundSource.NEUTRAL, this.getSoundVolume(), this.getVoicePitch());
        }
        this.relaxedTime = time;
        this.entityData.set(IS_RELAXING, (Object)(this.relaxedTime > 0 ? 1 : 0));
    }

    public int getRelaxingTime() {
        return this.relaxedTime;
    }

    public boolean canBeTamed() {
        return (Boolean)this.entityData.get(CAN_BE_TAMED);
    }

    public void setCoralColor(String color) {
        this.coralColor = color;
        this.entityData.set(CORAL_COLOR, (Object)color);
    }

    public String getCoralColor() {
        return (String)this.entityData.get(CORAL_COLOR);
    }

    public String getColor() {
        return this.getDisplayName().getString().equalsIgnoreCase("silver") ? "silver" : this.getCoralColor();
    }

    protected void playGallopSound(SoundType soundType) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isRelaxing()) {
            return WabSounds.SURFER_RELAX.get(this.isBaby());
        }
        return this.isInWaterOrAbove() ? WabSounds.SURFER_IDLE_WATER.get(this.isBaby()) : WabSounds.SURFER_IDLE.get(this.isBaby());
    }

    protected SoundEvent getSwimSound() {
        return this.isRunning() ? WabSounds.SURFER_FAST_SWIM.get(this.isBaby()) : WabSounds.SURFER_SWIM.get(this.isBaby());
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)WabSounds.SURFER_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return WabSounds.SURFER_DEATH.get(this.isBaby());
    }

    protected float getSoundVolume() {
        return 0.9f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.idle"), true),
        WALK(RawAnimation.begin().thenPlay("move.walk"), true),
        RUN(RawAnimation.begin().thenPlay("move.run"), true),
        IDLE_TO_RELAX(RawAnimation.begin().thenPlay("misc.idle_to_relax"), false, 10),
        RELAX(RawAnimation.begin().thenPlay("misc.relax"), false),
        RELAX_TO_IDLE(RawAnimation.begin().thenPlay("misc.relax_to_idle"), false, 15),
        IDLE_WATER(RawAnimation.begin().thenPlay("misc.idle_water"), true),
        SWIM(RawAnimation.begin().thenPlay("move.swim"), false),
        FAST_SWIM(RawAnimation.begin().thenPlay("move.fast_swim"), false),
        JUMP_START(RawAnimation.begin().thenPlay("jump.start"), false, 10),
        JUMP(RawAnimation.begin().thenPlay("jump.pose"), false),
        JUMP_END(RawAnimation.begin().thenPlay("jump.end"), false, 15);

        private final RawAnimation animation;
        private final boolean turnHead;
        private final int duration;

        private State(RawAnimation animation, boolean turnHead) {
            this(animation, turnHead, 0);
        }

        private State(RawAnimation animation, boolean turnHead, int duration) {
            this.animation = animation;
            this.turnHead = turnHead;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public boolean canTurnHead() {
            return this.turnHead;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

