/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.crusher;

import java.util.Random;
import net.minecraft.world.entity.ai.goal.Goal;
import net.wanmine.wab.entity.Crusher;

public class CrusherIdleGoal
extends Goal {
    private final Crusher crusher;
    private final Random random = new Random();
    private int ticksLeft = 0;

    public CrusherIdleGoal(Crusher crusher) {
        this.crusher = crusher;
    }

    public void tick() {
        this.ticksLeft = Math.max(--this.ticksLeft, 0);
    }

    public void stop() {
        this.crusher.setIdle2(false);
        this.ticksLeft = 0;
        this.crusher.getNavigation().setSpeedModifier(1.0);
    }

    public void start() {
        this.crusher.setIdle2(true);
        this.ticksLeft = 80;
        this.crusher.getNavigation().setSpeedModifier(0.0);
    }

    public boolean canContinueToUse() {
        return this.ticksLeft > 0 && (this.crusher.getTarget() == null || !this.crusher.getTarget().isAlive()) && this.crusher.getStateAttack() == Crusher.StateAttack.NONE && this.crusher.ticksLeft <= -20;
    }

    public boolean canUse() {
        return this.random.nextInt(200) == 0 && (this.crusher.getTarget() == null || !this.crusher.getTarget().isAlive()) && this.crusher.getStateAttack() == Crusher.StateAttack.NONE && this.ticksLeft <= 0 && this.crusher.ticksLeft <= -20;
    }
}

