/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.crusher;

import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.wanmine.wab.entity.Crusher;
import net.wanmine.wab.init.world.WabSounds;

public class CrusherMeleeAttackGoal
extends MeleeAttackGoal {
    private final Random random = new Random();

    public CrusherMeleeAttackGoal(Crusher crusher, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super((PathfinderMob)crusher, speedModifier, followingTargetEvenIfNotSeen);
    }

    protected void checkAndPerformAttack(LivingEntity enemy) {
        if (this.canPerformAttack(enemy)) {
            Crusher.StateAttack state = this.getAttack();
            if (state == Crusher.StateAttack.ATTACK_AREA) {
                this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), (SoundEvent)WabSounds.CRUSHER_ATTACK_AREA.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            } else {
                this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), (SoundEvent)WabSounds.CRUSHER_ATTACK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            this.getCrusher().setStateAttack(state);
            this.resetAttackCooldown();
        }
    }

    private Crusher.StateAttack getAttack() {
        int r = this.random.nextInt(10);
        if (r == 0) {
            return Crusher.StateAttack.ATTACK_AREA;
        }
        if (r == 1 || r == 2) {
            return Crusher.StateAttack.ATTACK_KNOCKBACK;
        }
        return Crusher.StateAttack.ATTACK;
    }

    protected boolean isTimeToAttack() {
        return this.getCrusher().ticksLeft <= -20;
    }

    protected int getTicksUntilNextAttack() {
        return this.getCrusher().ticksLeft + 20;
    }

    protected void resetAttackCooldown() {
        this.getCrusher().ticksLeft = this.getCrusher().getStateAttack().getDuration();
    }

    public Crusher getCrusher() {
        return (Crusher)this.mob;
    }
}

