/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.eater;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.wanmine.wab.entity.Eater;

public class EaterBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    protected final Eater eater;
    protected final Level level;
    protected Eater partner;
    private int loveTime;
    private final double speedModifier;

    public EaterBreedGoal(Eater eater, double speedModifier) {
        this.eater = eater;
        this.level = eater.level();
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.eater.isInLove()) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null;
    }

    public boolean canContinueToUse() {
        return this.partner.isAlive() && this.partner.isInLove() && this.loveTime < 60 && !this.partner.isPanicking();
    }

    public void stop() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void tick() {
        this.eater.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.eater.getMaxHeadXRot());
        this.eater.getNavigation().moveTo((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.adjustedTickDelay(60) && this.eater.distanceToSqr((Entity)this.partner) < 10.0) {
            this.breed();
        }
    }

    @Nullable
    private Eater getFreePartner() {
        List list = this.level.getNearbyEntities(Eater.class, PARTNER_TARGETING, (LivingEntity)this.eater, this.eater.getBoundingBox().inflate(16.0));
        double d0 = Double.MAX_VALUE;
        Eater partner = null;
        for (Eater animal1 : list) {
            if (!this.eater.canMate(animal1) || animal1.isPanicking() || !(this.eater.distanceToSqr((Entity)animal1) < d0)) continue;
            partner = animal1;
            d0 = this.eater.distanceToSqr((Entity)animal1);
        }
        return partner;
    }

    protected void breed() {
        this.eater.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
    }
}

