/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.eater;

import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.init.world.WabEffects;
import net.wanmine.wab.init.world.WabSounds;

public class RoarFirstGoal
extends NearestAttackableTargetGoal<Player> {
    private final Eater entity;
    private int ticksLeft = 0;

    public RoarFirstGoal(Eater entity, Class<Player> player, boolean mustSee) {
        super((Mob)entity, player, mustSee);
        this.entity = entity;
    }

    public void tick() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                this.reset();
            } else if (this.ticksLeft == 42) {
                this.entity.setState(Eater.State.ROAR);
            } else if (this.ticksLeft == 33) {
                if (this.entity.isBaby()) {
                    this.entity.level().playSeededSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), (SoundEvent)WabSounds.BABY_EATER_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f, 0L);
                } else {
                    this.entity.level().playSeededSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), (SoundEvent)WabSounds.EATER_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f, 0L);
                }
                for (LivingEntity target : this.entity.level().getEntitiesOfClass(LivingEntity.class, this.entity.getBoundingBox().inflate(16.0, 24.0, 16.0))) {
                    if (target instanceof Eater) continue;
                    if (target instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)target;
                        if (player.gameMode.getGameModeForPlayer() == GameType.CREATIVE) continue;
                    }
                    target.addEffect(new MobEffectInstance(WabEffects.FEAR, 140));
                }
            }
        }
    }

    private void reset() {
        this.ticksLeft = -1;
        this.entity.setState(Eater.State.IDLE);
    }

    public void stop() {
        this.entity.applyFutureTarget();
        this.entity.setRoared(true);
    }

    public void start() {
        this.ticksLeft = 52;
        if (!this.entity.level().isClientSide && this.entity.getTarget() != null) {
            this.entity.getLookControl().setLookAt((Entity)this.entity.getTarget(), 30.0f, 30.0f);
        }
    }

    public boolean canContinueToUse() {
        return this.ticksLeft > 0;
    }

    public boolean canUse() {
        if (!this.entity.isBaby()) {
            Random random;
            if (this.entity.shouldRoar()) {
                return true;
            }
            if (super.canUse() && (random = new Random()).nextInt(99) == 0) {
                for (Eater eater : this.entity.level().getEntitiesOfClass(Eater.class, this.entity.getBoundingBox().inflate(16.0, 8.0, 16.0))) {
                    if (!eater.isBaby()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

