/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.fly;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FlyFollowOwnerGoal
extends Goal {
    private final TamableAnimal mob;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public FlyFollowOwnerGoal(TamableAnimal mob, double pSpeedModifier, float pStartDistance, float pStopDistance) {
        this.mob = mob;
        this.level = mob.level();
        this.speedModifier = pSpeedModifier;
        this.navigation = mob.getNavigation();
        this.startDistance = pStartDistance;
        this.stopDistance = pStopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.mob.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.isSpectator()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.mob.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.mob.isOrderedToSit() || this.mob.isPassenger() || this.mob.isLeashed();
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (this.mob.distanceToSqr((Entity)this.owner) >= 1024.0) {
                this.teleportToOwner();
            } else {
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-5, 5);
            int k = this.randomIntInclusive(-3, 3);
            int l = this.randomIntInclusive(-5, 5);
            boolean flag = this.maybeTeleportTo(blockpos.getX() + j, blockpos.getY() + k, blockpos.getZ() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.getX()) < 3.0 && Math.abs((double)pZ - this.owner.getZ()) < 3.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.mob.moveTo((double)pX + 0.5, (double)pY, (double)pZ + 0.5, this.mob.getYRot(), this.mob.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        PathType blockpathtypes = WalkNodeEvaluator.getPathTypeStatic((Mob)this.mob, (BlockPos)pPos.mutable());
        if (blockpathtypes != PathType.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pPos.subtract((Vec3i)this.mob.blockPosition());
        return this.level.noCollision((Entity)this.mob, this.mob.getBoundingBox().move(blockpos));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.mob.getRandom().nextInt(pMax - pMin + 1) + pMin;
    }
}

