/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.event;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.init.data.WabAttachments;
import net.wanmine.wab.init.world.WabEffects;
import net.wanmine.wab.item.ReinforcedShield;
import net.wanmine.wab.network.client.EaterAlphaPacket;

@EventBusSubscriber(modid="wan_ancient_beasts")
public class Entities {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity source;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && (source = (LivingEntity)entity).hasEffect(WabEffects.ALPHA)) {
            source.setData(WabAttachments.ALPHA_COUNT, (Object)((Integer)source.getData(WabAttachments.ALPHA_COUNT) + 1));
        }
    }

    @SubscribeEvent
    public static void getDamage(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity2;
            if (entity.isUsingItem() && entity.getUseItem().getItem() instanceof ReinforcedShield && entity.getEyePosition().distanceTo(source.getEyePosition()) < 1.5) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    source.hurt(player.damageSources().playerAttack(player), 4.0f);
                } else {
                    source.hurt(entity.damageSources().mobAttack(entity), 4.0f);
                }
            }
            if (source.hasEffect(WabEffects.ALPHA)) {
                event.setNewDamage(event.getNewDamage() + (float)((Integer)source.getData(WabAttachments.ALPHA_COUNT)).intValue());
            }
        }
    }

    @SubscribeEvent
    public static void runAway(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            if (!(entity instanceof WitherBoss) && !(entity instanceof Eater)) {
                if (mob instanceof Villager) {
                    mob.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal(mob, Eater.class, 16.0f, 0.6, 0.7));
                } else {
                    mob.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal(mob, Eater.class, 16.0f, 1.4, 1.5));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).getPersistentData().getBoolean("has_alpha") && !entity.hasEffect(WabEffects.ALPHA)) {
            if (entity instanceof Eater) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new EaterAlphaPacket(entity.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            entity.setData(WabAttachments.ALPHA_COUNT, (Object)0);
            entity.getPersistentData().putBoolean("has_alpha", false);
        }
    }
}

